/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.llm.retrieval.BaseVectorStoreQuerySettings;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2py.annotations.PyModel;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PyModel
public class RAGLLMSettings
extends BaseVectorStoreQuerySettings {
    public String kbRef;
    public String llmId;
    public boolean printSources = true;
    public boolean includeContentInSources = true;
    public RAGOutputFormat outputFormat = RAGOutputFormat.SEPARATED;
    public SearchInputStrategySettings searchInputStrategySettings = new SearchInputStrategySettings();
    public RetrievalSource retrievalSource = RetrievalSource.EMBEDDING;
    @Nullable
    public String retrievalColumn;
    public GuardrailsSettings ragSpecificGuardrails = new GuardrailsSettings();
    public static final String DEFAULT_CONTEXT_MESSAGE = "Use the following pieces of context to answer the question at the end.\nIf you do not know the answer, just say that you do not know, do not try to make up an answer.";
    public String contextMessage = "Use the following pieces of context to answer the question at the end.\nIf you do not know the answer, just say that you do not know, do not try to make up an answer.";

    public boolean hasFaithfulnessGuardrailsEnabled() {
        return this.ragSpecificGuardrails != null && (this.ragSpecificGuardrails.faithfulnessSettings != null && this.ragSpecificGuardrails.faithfulnessSettings.enabled || this.ragSpecificGuardrails.multimodalFaithfulnessSettings != null && this.ragSpecificGuardrails.multimodalFaithfulnessSettings.enabled);
    }

    public boolean hasRelevancyGuardrailsEnabled() {
        return this.ragSpecificGuardrails != null && (this.ragSpecificGuardrails.relevancySettings != null && this.ragSpecificGuardrails.relevancySettings.enabled || this.ragSpecificGuardrails.multimodalRelevancySettings != null && this.ragSpecificGuardrails.multimodalRelevancySettings.enabled);
    }

    public boolean hasGuardrailsEnabled() {
        return this.hasFaithfulnessGuardrailsEnabled() || this.hasRelevancyGuardrailsEnabled();
    }

    public void disableGuardrails() {
        this.disableTextGuardrails();
        this.disableMultimodalGuardrails();
    }

    public void disableTextGuardrails() {
        if (this.ragSpecificGuardrails != null) {
            if (this.ragSpecificGuardrails.faithfulnessSettings != null) {
                this.ragSpecificGuardrails.faithfulnessSettings.enabled = false;
            }
            if (this.ragSpecificGuardrails.relevancySettings != null) {
                this.ragSpecificGuardrails.relevancySettings.enabled = false;
            }
        }
    }

    public void disableMultimodalGuardrails() {
        if (this.ragSpecificGuardrails != null) {
            if (this.ragSpecificGuardrails.multimodalFaithfulnessSettings != null) {
                this.ragSpecificGuardrails.multimodalFaithfulnessSettings.enabled = false;
            }
            if (this.ragSpecificGuardrails.multimodalRelevancySettings != null) {
                this.ragSpecificGuardrails.multimodalRelevancySettings.enabled = false;
            }
        }
    }

    private static String setDefaultPromptIfBlank(@Nullable String currentPrompt, String defaultPrompt) {
        return StringUtils.isBlank((String)currentPrompt) ? defaultPrompt : currentPrompt;
    }

    public RAGLLMSettings withDefaultPrompts() {
        RAGLLMSettings settingsWithDefaults = (RAGLLMSettings)JSON.deepCopy((Object)this);
        settingsWithDefaults.contextMessage = RAGLLMSettings.setDefaultPromptIfBlank(settingsWithDefaults.contextMessage, DEFAULT_CONTEXT_MESSAGE);
        settingsWithDefaults.searchInputStrategySettings = settingsWithDefaults.searchInputStrategySettings.withDefaultPrompts();
        return settingsWithDefaults;
    }

    @PyModel
    public static enum RAGOutputFormat {
        TEXT,
        JSON,
        SEPARATED;

    }

    @PyModel
    public static class SearchInputStrategySettings {
        private static final String DEFAULT_REWRITE_PROMPT = "When a message requires document retrieval, rewrite it to optimize retrieval from the vector store.\nFocus on clarity, disambiguation, and extracting the core intent.\nOutput only the rewritten query. Do not include comments or tips.";
        public SearchInputStrategy strategy = SearchInputStrategy.RAW_QUERY;
        @Nullable
        public String conditionalRetrievalPrompt;
        public String rewritePrompt = "When a message requires document retrieval, rewrite it to optimize retrieval from the vector store.\nFocus on clarity, disambiguation, and extracting the core intent.\nOutput only the rewritten query. Do not include comments or tips.";

        public static String getNoRetrievalKey() {
            return DKUApp.getParams().getParam("dku.rag.settings.noRetrievalKey", "NORETRIEVAL");
        }

        private static String getDefaultConditionalRetrievalPrompt() {
            String conditionalRetrievalPrompt = DKUApp.getParams().getParam("dku.rag.settings.defaultConditionalRetrievalPrompt", "You are responsible for determining whether the user's last message requires document retrieval.\nAssume all knowledge is stored in the vector store. Do not use your internal knowledge to answer any knowledge-seeking queries.\nIf the message requests knowledge, facts, or clarification, proceed to rewrite it for retrieval.\nIf the message does not request any new information (e.g., it's chitchat, thanks, or commentary), output only: %s.");
            return conditionalRetrievalPrompt.formatted(SearchInputStrategySettings.getNoRetrievalKey());
        }

        public SearchInputStrategySettings withDefaultPrompts() {
            SearchInputStrategySettings sissWithDefaults = (SearchInputStrategySettings)JSON.deepCopy((Object)this);
            sissWithDefaults.conditionalRetrievalPrompt = RAGLLMSettings.setDefaultPromptIfBlank(this.conditionalRetrievalPrompt, SearchInputStrategySettings.getDefaultConditionalRetrievalPrompt());
            sissWithDefaults.rewritePrompt = RAGLLMSettings.setDefaultPromptIfBlank(this.rewritePrompt, DEFAULT_REWRITE_PROMPT);
            return sissWithDefaults;
        }
    }

    @PyModel
    public static enum RetrievalSource {
        EMBEDDING,
        CUSTOM,
        MULTIMODAL;

    }

    @PyModel
    public static class GuardrailsSettings {
        @Nullable
        public String llmId;
        @Nullable
        public String embeddingModelId;
        public FaithfulnessSettings faithfulnessSettings = new FaithfulnessSettings();
        public RelevancySettings relevancySettings = new RelevancySettings();
        public FaithfulnessSettings multimodalFaithfulnessSettings = new FaithfulnessSettings();
        public RelevancySettings multimodalRelevancySettings = new RelevancySettings();
    }

    @PyModel
    public static class FaithfulnessSettings
    extends GuardrailSettings {
        public String answerOverwrite = "Could not come up with a factual enough answer.";
    }

    @PyModel
    public static class RelevancySettings
    extends GuardrailSettings {
        public String answerOverwrite = "Could not come up with a relevant enough answer.";
    }

    @PyModel
    public static enum BelowThresholdHandling {
        FAIL,
        OVERWRITE_ANSWER;

    }

    @PyModel
    private static abstract class GuardrailSettings {
        public boolean enabled = false;
        public double threshold = 0.8;
        public BelowThresholdHandling handling = BelowThresholdHandling.FAIL;

        private GuardrailSettings() {
        }
    }

    @PyModel
    public static enum SearchInputStrategy {
        RAW_QUERY,
        REWRITE_QUERY;

    }
}

