/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.metrics.checks.CheckMetadata;
import com.dataiku.dip.metrics.checks.CustomPythonCheck;
import com.dataiku.dip.metrics.checks.ExternalCheck;
import com.dataiku.dip.metrics.checks.MetricInNumericRangeCheck;
import com.dataiku.dip.metrics.checks.MetricInValueSetCheck;
import com.dataiku.dip.metrics.checks.PythonCheck;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;

public abstract class Check
extends DataQualityRule {
    public CheckMetadata meta = new CheckMetadata();

    public CheckMetadata getMeta() {
        return this.meta;
    }

    public Check withType(String type) {
        this.type = type;
        return this;
    }

    public Check withMeta(CheckMetadata meta) {
        this.meta = meta;
        return this;
    }

    public Check withComputeOnBuildMode(Probe.ComputeMode computeOnBuildMode) {
        this.computeOnBuildMode = computeOnBuildMode;
        return this;
    }

    public abstract Check trimForSave();

    protected abstract String getLegacyDatabaseId();

    @Override
    public void updateDisplayName() {
        if (StringUtils.isBlank((CharSequence)this.displayName)) {
            this.displayName = this.getLegacyDatabaseId();
        }
    }

    @Override
    public String getId() {
        String id = super.getId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return id;
        }
        return this.getLegacyDatabaseId();
    }

    public static void registerJsonAdapters() {
        JSON.registerAdapter(Check.class, Check.getAdapter());
    }

    public static JSON.Adapter<Check> getAdapter() {
        return new JSON.Adapter<Check>(){

            public Check deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject jsonObj = json.getAsJsonObject();
                String checkType = jsonObj.get("type").getAsString();
                if (checkType.startsWith("custom_python")) {
                    CustomPythonCheck check = (CustomPythonCheck)ctx.deserialize(json, CustomPythonCheck.class);
                    check.loadCheckType();
                    return check;
                }
                if (checkType.equals("python")) {
                    return (Check)ctx.deserialize(json, PythonCheck.class);
                }
                return (Check)ctx.deserialize(json, AbstractPolyJsonableCheck.class);
            }

            public JsonElement serialize(Check check, Type type, JsonSerializationContext ctx) {
                if (check instanceof CustomPythonCheck) {
                    return ctx.serialize((Object)check, CustomPythonCheck.class);
                }
                if (check instanceof PythonCheck) {
                    return ctx.serialize((Object)check, PythonCheck.class);
                }
                if (check instanceof AbstractPolyJsonableCheck) {
                    return ctx.serialize((Object)check, AbstractPolyJsonableCheck.class);
                }
                return null;
            }
        };
    }

    @PolyJSON(value={@Mapping(value=MetricInNumericRangeCheck.class, type="numericRange"), @Mapping(value=MetricInValueSetCheck.class, type="valueSet"), @Mapping(value=ExternalCheck.class, type="external")})
    public static abstract class AbstractPolyJsonableCheck
    extends Check {
    }
}

