/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.custom.CustomJavaOutputFormatter;
import com.dataiku.dip.formats.custom.CustomPythonOutputFormatter;
import com.dataiku.dip.formats.excel.ExcelOutputFormatter;
import com.dataiku.dip.formats.geo.GeoJSONOutputFormatter;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.FileNamingAbleOutputWriter;
import com.dataiku.dip.output.JSONOutputFormatter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.VerticaCopyCSVFormatter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class ExtensibleOutputWriter
extends OutputWriter
implements FileNamingAbleOutputWriter {
    protected List<SplitChunk> chunks = new ArrayList<SplitChunk>();
    protected List<SplitChunk> activeChunks = new ArrayList<SplitChunk>();
    protected boolean headerEmitted;
    protected ColumnFactory cf;
    protected Output.WriteMode writeMode;
    protected final SerializedDataset.ReadWriteOptions readWriteOptions;
    protected int splitId;
    protected String compress;
    protected final Schema schema;
    protected final AuthCtx authCtx;
    protected final String projectKey;
    protected final String formatType;
    protected final FormatParams formatParams;
    protected final WarningsContext warningsContext;
    protected int rows = 0;
    protected long maxSplitChunkSize = 0L;
    protected FileNamingAbleOutputWriter.FileNamingMode fileNamingMode = FileNamingAbleOutputWriter.FileNamingMode.EXTENT;
    protected String fixedChunkId;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.writer.extensible");

    protected ExtensibleOutputWriter(AuthCtx authCtx, String projectKey, int splitId, int nbChunks, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, Output.WriteMode writeMode, String compress, SerializedDataset.ReadWriteOptions readWriteOptions) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.formatType = formatType;
        this.formatParams = formatParams;
        this.warningsContext = warningsContext;
        this.writeMode = writeMode;
        this.compress = compress;
        this.splitId = splitId;
        this.readWriteOptions = readWriteOptions;
        this.schema = schema;
        if (nbChunks == 0) {
            nbChunks = 1;
        }
        for (int i = 0; i < nbChunks; ++i) {
            SplitChunk chunk = this.makeNewChunk(authCtx, projectKey, formatType, formatParams, schema, warningsContext);
            this.chunks.add(chunk);
            this.activeChunks.add(chunk);
        }
    }

    public void setMaxSplitChunkSize(long maxSplitChunkSize) {
        this.maxSplitChunkSize = maxSplitChunkSize;
    }

    protected SplitChunk makeNewChunk(AuthCtx authCtx, String projectKey, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext) {
        SplitChunk chunk = new SplitChunk();
        chunk.id = this.chunks.size();
        chunk.formatter = FormatFactory.buildFormatter(authCtx, projectKey, formatType, formatParams);
        if (schema != null) {
            chunk.formatter.setOutputSchema(schema);
        }
        if (warningsContext != null) {
            chunk.formatter.setWarningsContext(warningsContext);
        }
        return chunk;
    }

    protected void onChunkInitDone(int chunkId, String fileName) {
    }

    public void setFileNamingMode(FileNamingAbleOutputWriter.FileNamingMode newMode, String batchId) {
        this.fileNamingMode = newMode;
        this.fixedChunkId = batchId;
    }

    public void emitRow(Row row) throws Exception {
        if (!this.headerEmitted) {
            for (SplitChunk split : this.activeChunks) {
                split.formatter.header(this.cf, split.finalOutputStream);
            }
            this.headerEmitted = true;
        }
        int split = this.rows++ % this.activeChunks.size();
        SplitChunk splitChunk = this.activeChunks.get(split);
        if (this.maxSplitChunkSize > 0L && this.rows % 1000 == 0 && splitChunk.countingStream.getByteCount() > this.maxSplitChunkSize) {
            logger.infoV("Split %d grew too big, reopening", new Object[]{split});
            splitChunk = this.reopenChunk(splitChunk);
        }
        splitChunk.formatter.format(row, this.cf, splitChunk.finalOutputStream);
    }

    public SplitChunk reopenChunk(SplitChunk chunk) throws Exception {
        return chunk;
    }

    public void lastRowEmitted() throws Exception {
        for (SplitChunk split : this.activeChunks) {
            this.closeChunk(split);
        }
    }

    protected void closeChunk(SplitChunk split) throws Exception {
        split.formatter.footer(this.cf, split.finalOutputStream);
        split.finalOutputStream.close();
        split.fos.close();
        this.chunkFinishedHook(split);
    }

    public void cancel() throws Exception {
        for (SplitChunk split : this.activeChunks) {
            this.cancelChunk(split);
        }
    }

    protected void cancelChunk(SplitChunk split) throws Exception {
        split.formatter.cancel(split.finalOutputStream);
        split.finalOutputStream.close();
        split.fos.close();
        this.chunkCancelledHook(split);
    }

    protected void chunkFinishedHook(SplitChunk chunk) throws IOException, CodedException, DKUSecurityException {
    }

    protected void chunkCancelledHook(SplitChunk chunk) throws IOException, CodedException, DKUSecurityException {
    }

    public long writtenBytes() throws IOException {
        long r = 0L;
        for (SplitChunk split : this.chunks) {
            r += split.countingStream.getByteCount();
        }
        return r;
    }

    protected String makeChunkBaseName(int chunkId) {
        if (this.readWriteOptions != null && this.readWriteOptions.forceSingleOutputFile && StringUtils.isNotBlank((String)this.readWriteOptions.singleOutputFileBaseName)) {
            return this.readWriteOptions.singleOutputFileBaseName;
        }
        String chunkBaseName = null;
        chunkBaseName = this.chunks.size() > 1 ? "out-s" + this.splitId + "-c" + chunkId : "out-s" + this.splitId;
        return chunkBaseName;
    }

    protected String makeExtension() {
        Object extension = "";
        if (!this.chunks.isEmpty()) {
            SplitChunk chunk = this.chunks.get(0);
            if (chunk.formatter instanceof CSVOutputFormatter || chunk.formatter instanceof VerticaCopyCSVFormatter) {
                extension = ".csv";
            } else if (chunk.formatter instanceof ExcelOutputFormatter) {
                extension = ".xlsx";
            } else if (chunk.formatter instanceof JSONOutputFormatter || chunk.formatter instanceof GeoJSONOutputFormatter) {
                extension = ".json";
            } else if (chunk.formatter instanceof CustomPythonOutputFormatter) {
                extension = ((CustomPythonOutputFormatter)chunk.formatter).getExtension();
            } else if (chunk.formatter instanceof CustomJavaOutputFormatter) {
                extension = ((CustomJavaOutputFormatter)chunk.formatter).getExtension();
            }
        }
        if ("gz".equals(this.compress)) {
            extension = (String)extension + ".gz";
        }
        return extension;
    }

    protected static class SplitChunk {
        public int id;
        public CountingOutputStream countingStream;
        public OutputStream finalOutputStream;
        public OutputStream fos;
        public OutputFormatter formatter;
        public String finalFilePath;
        public String tmpFilePath;

        protected SplitChunk() {
        }
    }
}

