/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FilePartitioningDetector {
    private static Logger logger = Logger.getLogger((String)"dip.partitioning.detection");

    static boolean validates(String pattern, List<FSPath> paths) {
        return FilePartitioningDetector.countOKPaths(Pattern.compile(pattern), paths) > paths.size() / 2;
    }

    static int countOKPaths(Pattern pattern, List<FSPath> paths) {
        int okPaths = 0;
        for (FSPath p : paths) {
            if (!pattern.matcher(p.path()).matches()) continue;
            ++okPaths;
        }
        return okPaths;
    }

    static PartitioningScheme timeScheme(String pattern, String dimensionName, TimeDimension.Period period) {
        PartitioningScheme scheme = new PartitioningScheme().withFilePathPattern(pattern).addDimension((Dimension)new TimeDimension(dimensionName, period));
        return scheme;
    }

    public static PartitioningScheme autodetect(AuthCtx authCtx, Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (!DatasetInspector.isFS(dataset)) {
            throw ErrorContext.iaef((String)"Can't autodetect partitioning on dataset %s, invalid type %s", (Object)dataset.getName(), (Object[])new Object[]{dataset.getType()});
        }
        AbstractFSDatasetHandler handler = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);
        try {
            List<FSPath> paths;
            try {
                paths = handler.enumerateFilesystem();
            }
            catch (FileNotFoundException e) {
                logger.info((Object)"Trying to detext partitioning on an empty dataset", (Throwable)e);
                PartitioningScheme partitioningScheme = null;
                if (handler != null) {
                    handler.close();
                }
                return partitioningScheme;
            }
            PartitioningScheme partitioningScheme = FilePartitioningDetector.autodetect(paths);
            return partitioningScheme;
        }
        finally {
            if (handler != null) {
                try {
                    handler.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public static PartitioningScheme autodetect(List<FSPath> paths) {
        Pattern fieldEqualsYYYYMMDD = Pattern.compile("/([A-z0-9]*)=[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}/.*");
        int okPaths = 0;
        String field = null;
        for (FSPath p : paths) {
            Matcher m = fieldEqualsYYYYMMDD.matcher(p.path());
            if (!m.matches()) continue;
            ++okPaths;
            field = m.group(1);
        }
        if (okPaths > paths.size() / 2) {
            return FilePartitioningDetector.timeScheme("/" + field + "=%Y-%M-%D/.*", field, TimeDimension.Period.DAY);
        }
        if (FilePartitioningDetector.validates("/[0-9]{4}-[0-9]{1,2}-[0-9]{1,2}/.*", paths)) {
            return FilePartitioningDetector.timeScheme("/%Y-%M-%D/.*", "day", TimeDimension.Period.DAY);
        }
        if (FilePartitioningDetector.validates("/[0-9]{4}-[0-9]{1,2}/.*", paths)) {
            return FilePartitioningDetector.timeScheme("/%Y-%M/.*", "month", TimeDimension.Period.MONTH);
        }
        if (FilePartitioningDetector.validates("/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/.*", paths)) {
            return FilePartitioningDetector.timeScheme("/%Y/%M/%D/.*", "day", TimeDimension.Period.DAY);
        }
        if (FilePartitioningDetector.validates("/[0-9]{4}/[0-9]{1,2}/.*", paths)) {
            return FilePartitioningDetector.timeScheme("/%Y/%M/.*", "month", TimeDimension.Period.MONTH);
        }
        if (FilePartitioningDetector.validates("/[0-9]{4}[0-9]{2}[0-9]{2}/.*", paths)) {
            return FilePartitioningDetector.timeScheme("/%Y%M%D/.*", "day", TimeDimension.Period.DAY);
        }
        if (FilePartitioningDetector.validates("/[0-9]{4}[0-9]{2}/.*", paths)) {
            return FilePartitioningDetector.timeScheme("/%Y%M/.*", "month", TimeDimension.Period.MONTH);
        }
        return null;
    }
}

