/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.highcardinality;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import com.google.refine.udaf.UdafUtils;

public class BinsAndTensorsSafetyChecks {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.pivot.dss");

    private static int getMaxAxisBins(PivotTableAggregatedRequest request) {
        int instanceWideMaxAxisBins = BinsAndTensorsSafetyChecks.getInstanceWideMaxAxisBins();
        if (request == null) {
            return instanceWideMaxAxisBins;
        }
        if (request.maxAllocatedBinsPerAxis <= 0 || request.maxAllocatedBinsPerAxis > instanceWideMaxAxisBins) {
            return instanceWideMaxAxisBins;
        }
        return request.maxAllocatedBinsPerAxis;
    }

    public static int getInstanceWideMaxAxisBins() {
        return DKUApp.getParams().getIntParam("dku.charts.maxBins", Integer.valueOf(1000000));
    }

    public static int getInstanceWideMaxStringDictCardinality() {
        return DKUApp.getParams().getIntParam("dku.charts.maxAlphanumColumnCardinality", Integer.valueOf(1000000));
    }

    public static void failIfTooManyBinsBasedOnExplicitConfiguration(PivotTableAggregatedRequest request, AxisDef[] axes) {
        int usedMaxAxisBins = BinsAndTensorsSafetyChecks.getMaxAxisBins(request);
        for (AxisDef axe : axes) {
            if (axe.numParams == null || axe.numParams.nbBins <= usedMaxAxisBins) continue;
            throw new UnsupportedOperation(String.format("The configuration of the chart generated %d bins, which is above the limit of %d bins. Update the chart configuration to generate less bins.", axe.numParams.nbBins, usedMaxAxisBins));
        }
    }

    public static void failIfTooManyBinsOnSingleAxis(PivotTableAggregatedRequest request, int numBins) {
        int usedMaxAxisBins = BinsAndTensorsSafetyChecks.getMaxAxisBins(request);
        if (numBins > usedMaxAxisBins) {
            throw new UnsupportedOperation(String.format("The configuration of the chart generated %d bins, which is above the limit of %d bins. Update the chart configuration to generate less bins.", numBins, usedMaxAxisBins));
        }
    }

    public static void failIfTensorWouldBeTooLargeOrTooManyBins(PivotTableAggregatedRequest request, int[] numBinsPerAxis, VariablesContext variablesContext) throws MemoryLimitExceededException {
        BinsAndTensorsSafetyChecks.failIfTensorWouldBeTooLargeOrTooManyBins(request, numBinsPerAxis, BinsAndTensorsSafetyChecks.getNumbersOfAggregations(request, variablesContext));
    }

    public static void failIfTensorWouldBeTooLargeOrTooManyBins(PivotTableAggregatedRequest request, int[] numBinsPerAxis, long numbersOfAggregations) throws MemoryLimitExceededException {
        long instanceWideMaxTensorBytes = DKUApp.getParams().getLongParam("dku.charts.maxTensorBytes", 200000000L);
        long usedMaxTensorBytes = request.maxTensorBytes <= 0 || (long)request.maxTensorBytes > instanceWideMaxTensorBytes ? instanceWideMaxTensorBytes : (long)request.maxTensorBytes;
        int usedMaxAxisBins = BinsAndTensorsSafetyChecks.getMaxAxisBins(request);
        long tensorBytes = 2L * (DataTensor.getUsedBytes(numBinsPerAxis) * numbersOfAggregations + LongDataTensor.getUsedBytes(numBinsPerAxis));
        for (int numBins : numBinsPerAxis) {
            tensorBytes += (long)numBins * 172L;
        }
        logger.infoV("Pre-Tensor-allocation safety check: bins=%s tensorBytes=%s maxTensorBytes=%s maxAxisBins=%s", new Object[]{JSON.json((Object)numBinsPerAxis), tensorBytes, usedMaxTensorBytes, usedMaxAxisBins});
        for (int numBins : numBinsPerAxis) {
            if (numBins <= usedMaxAxisBins) continue;
            throw new UnsupportedOperation(String.format("The configuration of the chart generated %d bins on one axis, which is above the limit of %d bins. Update the chart configuration to generate less bins.", numBins, usedMaxAxisBins));
        }
        if (tensorBytes > usedMaxTensorBytes) {
            throw new MemoryLimitExceededException("Chart computation memory limit reached: " + tensorBytes + " > " + usedMaxTensorBytes);
        }
    }

    private static long getNumbersOfAggregations(PivotTableAggregatedRequest request, VariablesContext variablesContext) {
        long nbAggregations = 0L;
        for (Aggregation aggregation : request.aggregations) {
            if (aggregation.type == AxisDef.Type.CUSTOM) {
                Expression expression = new Expression(variablesContext != null ? variablesContext.expand(aggregation.customFunction) : aggregation.customFunction, UdafControlFunctionRegistry.getInstance());
                expression.setVariablesContext(variablesContext);
                nbAggregations += UdafUtils.getNumbersOfAggregations(expression.evaluable);
                continue;
            }
            ++nbAggregations;
        }
        return nbAggregations;
    }

    public static class MemoryLimitExceededException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MemoryLimitExceededException(String e) {
            super(e);
        }
    }
}

