/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.pivot.backend.dss.MultipassPivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotTableAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotTableBuilder;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.model.SimpleAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.ValidationPivotTableTensorResponse;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.google.refine.udaf.UdafUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NonBinnedBuilder
extends PivotTableBuilder
implements MultipassPivotTableBuilder {
    private final SimpleAggregatedRequest request;
    private final VariablesContext variablesContext;
    private final LinoReader linoReader;
    private long beforeFilterRecords = 0L;
    private long afterFilterRecords = 0L;
    public List<AbstractAggregator<?>> aggregators = new ArrayList();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.kpi");

    public NonBinnedBuilder(SimpleAggregatedRequest request) {
        this(request, null, null);
    }

    public NonBinnedBuilder(SimpleAggregatedRequest request, VariablesContext variablesContext, LinoReader linoReader) {
        this.request = request;
        this.variablesContext = variablesContext;
        this.linoReader = linoReader;
        this.filtered = request.isFiltered();
    }

    @Override
    public void linoInit(LinoReader linoReader) {
        logger.info((Object)"Init NonBinnedBuilder");
        this.buildLinoFilters(this.request, linoReader);
    }

    @Override
    public void addPass1(ColumnBlock[] axisBlocks, LinoReader linoReader, int blockIdx) {
    }

    @Override
    public void endPass1() {
        this.buildAggregators();
    }

    @Override
    public void addPass2(ColumnBlock[] axisBlocks, List<ColumnBlock> aggrColumns, LinoReader linoReader, int blockIdx) throws IOException {
        this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
        boolean[] filters = null;
        int nbRecords = LinoUtils.nbRecords(linoReader, blockIdx);
        this.beforeFilterRecords += (long)nbRecords;
        if (this.filtered) {
            filters = new boolean[nbRecords];
            this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
            this.afterFilterRecords += (long)FilteringExecutor.countTrue(filters);
        } else {
            this.afterFilterRecords += (long)nbRecords;
        }
        for (int i = 0; i < this.request.aggregations.size(); ++i) {
            ColumnBlock block = aggrColumns.get(i);
            AbstractAggregator<?> aggregator = this.aggregators.get(i);
            UdafUtils.setBlocksIfCustomAggregation(aggregator, linoReader, blockIdx);
            aggregator.handleBlock(block, nbRecords, new int[nbRecords], filters);
            UdafUtils.mergeOtherAggregators(aggregator, null);
        }
    }

    @Override
    public PivotTableTensorResponse end() throws IOException {
        ValidationPivotTableTensorResponse resp = new ValidationPivotTableTensorResponse();
        for (AbstractAggregator<?> aggregator : this.aggregators) {
            aggregator.end();
            resp.hasExpressionPlusWithNotNumeric |= aggregator.expressionNeedsFix();
        }
        for (int aggrId = 0; aggrId < this.request.aggregations.size(); ++aggrId) {
            AbstractAggregator<?> aggregator;
            aggregator = this.aggregators.get(aggrId);
            aggregator.initMerge(aggregator.getOutDT().axisLengths[0]);
            aggregator.mergeTensor();
            aggregator.postProcessEndPhase2();
            resp.aggregations.add(aggregator.getMergeDT());
        }
        this.computeFilterFacets(this.request, resp);
        resp.setRecordCounts(this.beforeFilterRecords, this.afterFilterRecords);
        return resp;
    }

    @Override
    public void cleanup() {
        PivotUtils.cleanupAggregators(this.aggregators);
    }

    public PivotTableTensorResponse buildFromLino(LinoReader linoReader) throws Exception {
        this.linoInit(linoReader);
        logger.info((Object)"Skipped pass 1 start");
        this.endPass1();
        logger.info((Object)"Begin pass 2");
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            List<ColumnBlock> aggrColumns = PivotTableAggrBuilder.getAggrBlocks(linoReader, this.request.aggregations, blockIdx);
            this.addPass2(null, aggrColumns, linoReader, blockIdx);
        }
        return this.end();
    }

    public void buildAggregators() {
        for (Aggregation aggregation : this.request.aggregations) {
            this.aggregators.add(PivotUtils.buildAggregator(this.variablesContext, this.linoReader, this.request.formulaValidation, aggregation, new Object[0]));
        }
    }
}

