/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import java.util.List;

public class NumericalCustomBinsAxisHandler
implements AxisHandler {
    private final List<Double> bins;
    private final NumericalVariableAnalysis analysis;

    public NumericalCustomBinsAxisHandler(AxisDef axis) {
        this.bins = PivotUtils.getValidatedCustomBins(axis);
        this.analysis = new NumericalVariableAnalysis();
        this.analysis.min = Double.MAX_VALUE;
        this.analysis.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public void observe(Row row) {
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
    }

    private void onObservation(double value) {
        this.analysis.min = Math.min(this.analysis.min, value);
        this.analysis.max = Math.max(this.analysis.max, value);
    }

    @Override
    public int getNbBins() {
        if (this.bins == null || this.bins.isEmpty()) {
            return 0;
        }
        return this.bins.size() + 1;
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (filters != null && !filters[i]) {
                ret[i] = -1;
                continue;
            }
            double v = block.doubles[i];
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                ret[i] = -1;
                continue;
            }
            ret[i] = this.findValueBin(v);
            this.onObservation(v);
        }
    }

    private int findValueBin(double value) {
        if (value < this.bins.get(0)) {
            return 0;
        }
        for (int i = 0; i < this.bins.size() - 1; ++i) {
            if (!(value >= this.bins.get(i)) || !(value < this.bins.get(i + 1))) continue;
            return i + 1;
        }
        return this.bins.size();
    }

    @Override
    public List<AxisElt> getAxisElts() {
        return PivotUtils.getCustomBinsAxisElts(this.bins, this.analysis.min, this.analysis.max);
    }
}

