/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFaceter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.utils.DKULogger;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.mutable.MutableInt;

public class NumAsAnumAxisFaceter
implements AxisFaceter {
    private final String column;
    private final ChartFilter.FilterSortingOptions facetSorting;
    private final boolean allValuesInSample;
    CountMap<String> counts = new CountMap();
    private double globalMin = Double.POSITIVE_INFINITY;
    private double globalMax = Double.NEGATIVE_INFINITY;
    private boolean truncated = false;
    private final long facetsSafetyThreshold;
    private static final DKULogger logger = DKULogger.getLogger(NumAsAnumAxisFaceter.class);

    public NumAsAnumAxisFaceter(RowFilter filter) {
        this.column = filter.column;
        this.allValuesInSample = filter.allValuesInSample;
        this.facetSorting = filter.facetSorting;
        this.facetsSafetyThreshold = FilterUtils.getAlphanumFacetsSafetyThreshold();
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            boolean shouldKeep;
            String v;
            double d = block.doubles[i];
            if (!Double.isNaN(d)) {
                this.globalMin = Math.min(d, this.globalMin);
                this.globalMax = Math.max(d, this.globalMax);
            }
            if ((v = block.getAsStringSlow(i)) == null || v.isEmpty()) {
                v = "___dku_no_value___";
            }
            boolean bl = shouldKeep = filters == null || filters[i];
            if (!this.counts.containsKey(v) && (long)this.counts.size() >= this.facetsSafetyThreshold && (shouldKeep || this.allValuesInSample)) {
                this.truncated = true;
                continue;
            }
            if (!shouldKeep && this.allValuesInSample) {
                this.counts.reset(v);
                continue;
            }
            if (!shouldKeep) continue;
            this.counts.inc(v);
        }
    }

    @Override
    public FilterFacet compute(boolean shouldKeepRelevantValuesOnly) {
        FilterFacet ff = new FilterFacet();
        ff.globalMaxValue = this.globalMax;
        ff.globalMinValue = this.globalMin;
        for (Map.Entry<String, MutableInt> count : this.counts.getMap().entrySet()) {
            ff.values.add(new FilterFacet.Val(count.getKey(), count.getKey(), count.getValue().longValue()));
        }
        ff.isTruncated = this.truncated;
        if (this.truncated) {
            logger.error((Object)("Truncated numerical as alphanum facet on column \"" + this.column + "\" (too many values: > " + this.facetsSafetyThreshold + ")"));
        }
        ff.values.sort(PivotUtils.buildDoubleComparator(Objects.requireNonNullElse(this.facetSorting, ChartFilter.FilterSortingOptions.COUNT_DESC)));
        return ff;
    }
}

