/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class NumAsAnumAxisFilter
implements AxisFilter {
    private final RowFilter filter;
    private final Set<String> excluded = new HashSet<String>();
    private final Set<String> selected = new HashSet<String>();
    private final boolean useSelectedValues;

    public NumAsAnumAxisFilter(RowFilter filter) {
        this.filter = filter;
        this.useSelectedValues = FilterUtils.isASelectedValuesFilter(filter);
        if (this.useSelectedValues) {
            if (filter.selectedValues != null) {
                this.selected.addAll(filter.selectedValues);
            }
        } else if (filter.excludedValues != null) {
            this.excluded.addAll(filter.excludedValues);
        }
    }

    @Override
    public boolean filter(Row row) {
        return false;
    }

    @Override
    public void filter(LinoReader reader, int blockIdx, boolean[] ret) throws IOException {
        ColumnBlock block = reader.readColumnBlock(this.filter.column, blockIdx);
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (!ret[i]) continue;
            int n = i;
            ret[n] = ret[n] & this.keep(block.getAsStringSlow(i));
        }
    }

    protected boolean keep(String v) {
        return this.useSelectedValues ? this.keepSelected(v) : this.keepNonExcluded(v);
    }

    private boolean keepNonExcluded(String v) {
        if (v == null || v.isEmpty()) {
            return !this.excluded.contains("___dku_no_value___");
        }
        return !this.excluded.contains(v);
    }

    private boolean keepSelected(String v) {
        if (v == null || v.isEmpty()) {
            return this.selected.contains("___dku_no_value___");
        }
        return this.selected.contains(v);
    }
}

