/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.sql.executors.ColumnMappingSQLExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.utils.DKULogger;
import java.util.concurrent.Callable;

public class ColumnMappingHybridExecutor
implements Callable<ColumnMapper> {
    private ExecutionContext ctx;
    private static DKULogger logger = DKULogger.getLogger(ColumnMappingHybridExecutor.class);

    public ColumnMappingHybridExecutor(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    private void checkTypes(ColumnMapper mapper) throws Exception {
        if (this.ctx.req == null) {
            return;
        }
        if (this.ctx.req instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest treq = (PivotTableTensorRequest)this.ctx.req;
            for (AxisDef axis : treq.axes) {
                this.checkAxis(mapper, axis);
            }
        }
    }

    private void checkAxis(ColumnMapper mapper, AxisDef axis) throws Exception {
        ColumnMapper.TypedExpr column = mapper.get(axis.column);
        switch (axis.type) {
            case ALPHANUM: {
                break;
            }
            case DATE: {
                if (column.type.type == ColumnMapper.BaseType.DATE) break;
                throw new Exception("Type of column " + axis.column + " is not a DATE, but " + column.type.name());
            }
            case NUMERICAL: {
                if (column.type.type == ColumnMapper.BaseType.NUMBER) break;
                throw new Exception("Type of column " + axis.column + " is not NUMBER, but " + column.type.name());
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("Geometry column not supported here");
            }
        }
    }

    @Override
    public ColumnMapper call() throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Detecting data types...");){
            if (this.ctx.cache.columnMapper == null) {
                ColumnMappingSQLExecutor executor = new ColumnMappingSQLExecutor(this.ctx);
                this.ctx.cache.columnMapper = executor.call();
            } else {
                logger.info((Object)"Reuse cached column type mapping");
            }
            this.checkTypes(this.ctx.cache.columnMapper);
            ColumnMapper columnMapper = this.ctx.cache.columnMapper;
            return columnMapper;
        }
    }
}

