/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards.component;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.exceptions.DuplicateComponentException;
import com.dataiku.dip.projectstandards.ProjectStandardsConfigurableCheckRegistry;
import com.dataiku.dip.projectstandards.ProjectStandardsKernelPool;
import com.dataiku.dip.projectstandards.component.LoadedPythonPluginProjectStandardsCheckSpec;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsCheckSpecDesc;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsCheckSpecMeta;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PythonPluginProjectStandardsService
extends CustomPythonElementService<PythonPluginProjectStandardsCheckSpecDesc, LoadedPythonPluginProjectStandardsCheckSpec> {
    @Autowired
    private ProjectStandardsKernelPool projectStandardsKernelPool;

    @Override
    public String getFolderName() {
        return "python-project-standards-check-specs";
    }

    @Override
    public String getPrefix() {
        return "project_standards_check_spec";
    }

    @Override
    protected void removeElement(LoadedPythonPluginProjectStandardsCheckSpec desc) {
        ProjectStandardsConfigurableCheckRegistry.deregister(desc.elementType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return String.format("project_standards_check_spec_%s_%s", pluginId, elementId);
    }

    @Override
    protected LoadedPythonPluginProjectStandardsCheckSpec load(String elementType, String pluginId, String elementId, File file) throws IOException, DuplicateComponentException {
        LoadedPythonPluginProjectStandardsCheckSpec loaded = new LoadedPythonPluginProjectStandardsCheckSpec(elementId, pluginId, elementType, (PythonPluginProjectStandardsCheckSpecDesc)JSON.parseFile((File)file, PythonPluginProjectStandardsCheckSpecDesc.class));
        PythonPluginProjectStandardsCheckSpecMeta projectStandardsCheckSpecMeta = new PythonPluginProjectStandardsCheckSpecMeta(loaded);
        ProjectStandardsConfigurableCheckRegistry.register(projectStandardsCheckSpecMeta);
        return loaded;
    }

    @Override
    public Class<PythonPluginProjectStandardsCheckSpecDesc> getDescClass() {
        return PythonPluginProjectStandardsCheckSpecDesc.class;
    }

    @Override
    public Class<LoadedPythonPluginProjectStandardsCheckSpec> getLoadedDescClass() {
        return LoadedPythonPluginProjectStandardsCheckSpec.class;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final PythonPluginProjectStandardsCheckSpecDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, PythonPluginProjectStandardsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }

    @Override
    public synchronized void removeComponentTypeForOnePlugin(String pluginId) {
        super.removeComponentTypeForOnePlugin(pluginId);
        this.projectStandardsKernelPool.invalidateKernels(pluginId);
    }
}

