/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.scala;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.recipes.code.scala.ScalaKernelHandle;
import com.dataiku.dip.recipes.code.scala.ScalaKernelsManager;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.streaming.scala.StreamingSparkScalaRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScalaService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private DatasetAccessService datasetsService;
    @Autowired
    private ScalaKernelsManager scalaKernelsManager;
    private Lock kernelStartLock = new ReentrantLock();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.scala");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScalaKernelHandle getKernel(ClusterSettings clusterSettings) throws Exception {
        boolean locked = this.kernelStartLock.tryLock(30000L, TimeUnit.MILLISECONDS);
        if (!locked) {
            throw new TimeoutException("Waited too long for Scala kernel startup");
        }
        try {
            ScalaKernelHandle scalaKernelHandle = (ScalaKernelHandle)this.scalaKernelsManager.acquireKernel(clusterSettings);
            return scalaKernelHandle;
        }
        finally {
            this.kernelStartLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScalaRecipeValidationResult checkSyntax(AuthCtx authCtx, String code, SerializedRecipe sa, @Nullable String targetPartition) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ScalaKernelHandle kernel = this.getKernel(new ClusterSelector().selectForProject(authCtx, sa.getProjectKey()));
        try {
            CodeMode mode = ((SparkScalaRecipeMeta.SparkScalaRecipeParams)sa.params).codeMode;
            logger.infoV("Submit to SEK: check Scala syntax (recipe=%s.%s mode=%s)", new Object[]{sa.projectKey, sa.name, mode});
            ScalaRecipeValidationResult scalaRecipeValidationResult = (ScalaRecipeValidationResult)kernel.getAPIClient().postAnyToJSON("/scala/check-syntax?mode=" + mode.name(), ScalaRecipeValidationResult.class, (HttpEntity)new StringEntity(code));
            return scalaRecipeValidationResult;
        }
        finally {
            this.scalaKernelsManager.releaseKernel(kernel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScalaRecipeValidationResult checkSyntaxStreaming(AuthCtx authCtx, String code, SerializedRecipe sa, @Nullable String targetPartition) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ScalaKernelHandle kernel = this.getKernel(new ClusterSelector().selectForProject(authCtx, sa.getProjectKey()));
        try {
            CodeMode mode = ((StreamingSparkScalaRecipeMeta.StreamingSparkScalaRecipeParams)sa.params).codeMode;
            logger.infoV("Submit to SEK: check Scala syntax (recipe=%s.%s mode=%s)", new Object[]{sa.projectKey, sa.name, mode});
            ScalaRecipeValidationResult scalaRecipeValidationResult = (ScalaRecipeValidationResult)kernel.getAPIClient().postAnyToJSON("/scala/check-syntax?mode=" + mode.name(), ScalaRecipeValidationResult.class, (HttpEntity)new StringEntity(code));
            return scalaRecipeValidationResult;
        }
        finally {
            this.scalaKernelsManager.releaseKernel(kernel);
        }
    }

    public AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult validateSparkSQL(AuthCtx authCtx, Pair<String[], Integer[]> sqlStatementsAndOffsets, SerializedRecipe recipe) throws Exception {
        HashSet<String> projects = new HashSet<String>();
        projects.add(recipe.projectKey);
        for (SerializedRecipe.RecipeInput input : recipe.getFlatInputs()) {
            projects.add(AnyLoc.resolveSmart(recipe.projectKey, input.ref).getProjectKey());
        }
        for (SerializedRecipe.RecipeOutput output : recipe.getFlatOutputs()) {
            projects.add(AnyLoc.resolveSmart(recipe.projectKey, output.ref).getProjectKey());
        }
        return this.validateSparkSQL(authCtx, sqlStatementsAndOffsets, recipe, projects);
    }

    public AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult validateSparkSQL(AuthCtx authCtx, Pair<String[], Integer[]> sqlStatementsAndOffsets, SerializedRecipe sa, Iterable<String> relevantProjects) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        AbstractSQLQueryRecipeTester.SQLRecipeValidationRequest request = new AbstractSQLQueryRecipeTester.SQLRecipeValidationRequest();
        request.serializedRecipe = sa;
        request.sqlStatementsAndOffsets = sqlStatementsAndOffsets;
        ScalaKernelHandle kernel = this.getKernel(new ClusterSelector().selectForProject(authCtx, sa.getProjectKey()));
        try {
            AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult sQLQuerySimpleValidationResult;
            block18: {
                APITicketService.ExpirableTicket ticket = this.apiTicketService.createExpiringTicket(authCtx, "sparksql_validation:" + sa.projectKey + "." + sa.name, null);
                try {
                    AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult ret;
                    request.apiTicket = ticket.getSecret();
                    try (Transaction t = this.transactionService.beginRead();){
                        for (SerializedRecipe.RecipeInput input : sa.getFlatInputs()) {
                            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(sa.projectKey, input.ref);
                            Dataset ds = this.datasetsService.getMandatoryUnsafe(loc);
                            FlowDatasetRef fdr = SparkRecipeUtils.getInputFlowDatasetRef(ds, new InputDatasetsReadParams(), ((SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams)sa.params).useGlobalMetastore, sa.getProjectKey(), null);
                            request.inputRefs.add(fdr);
                        }
                    }
                    UserImpersonationTarget utarget = null;
                    if (this.impersonationService.isEnabled()) {
                        utarget = this.impersonationService.getTargetUser(sa.projectKey, authCtx);
                    }
                    ClusterSettings clusterSettings = new ClusterSelector().selectForProject(authCtx, sa.projectKey);
                    request.execEnv.fillInBackendOrJEK(relevantProjects, authCtx, utarget, clusterSettings.getHadoopSettings(), false);
                    logger.infoV("Submit to SEK: check SparkSQL syntax  (recipe=%s.%s)", new Object[]{sa.projectKey, sa.name});
                    sQLQuerySimpleValidationResult = ret = (AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult)kernel.getAPIClient().postObject("/scala/validate-sparksql", AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult.class, (Object)request);
                    if (ticket == null) break block18;
                }
                catch (Throwable throwable) {
                    if (ticket != null) {
                        try {
                            ticket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ticket.close();
            }
            return sQLQuerySimpleValidationResult;
        }
        finally {
            this.scalaKernelsManager.releaseKernel(kernel);
        }
    }

    public static class ScalaRecipeValidationResult {
        public GenericRecipesValidationService.RecipeValidationResult genericCheckResult = new GenericRecipesValidationService.RecipeValidationResult();
    }
}

