/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeJobDef;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeRunnerBase;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SparkSQLExecutor
extends SparkSQLQueryRecipeRunnerBase
implements AbortableRecipeRunner {
    private String originalQuery;
    private String finalQuery;
    private SparkSQLExecutorParams params;
    static Logger logger = Logger.getLogger((String)"dku.recipes.embeddableSparkSQL");

    public SparkSQLExecutor(JobActivity activity, SparkSQLExecutorParams params, String sql) {
        super(activity);
        this.params = params;
        this.originalQuery = sql;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
        this.finalQuery = this.jobDefBuilder.buildFinalQuery(this.originalQuery);
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)("SparkSQL query:\n" + this.finalQuery));
        Object queryWithPreQueries = this.finalQuery;
        if (!StringUtils.isBlank((String)this.params.preQueries)) {
            queryWithPreQueries = this.params.preQueries + "\n;\n" + (String)queryWithPreQueries;
        }
        SparkSQLQueryRecipeJobDef jobDef = this.jobDefBuilder.buildJobDef((String)queryWithPreQueries, this.params.overwriteOutputSchema, this.params.useGlobalMetastore, this.params.readParams);
        this.clearOutputIfNeeded();
        this.executeJobDef(jobDef, this.params.sparkConfig, this.params.executionEngine);
    }

    public static class SparkSQLExecutorParams
    extends AbstractSparkRecipeParams {
        public boolean overwriteOutputSchema = false;
        public boolean useGlobalMetastore = false;
        public InputDatasetsReadParams readParams = new InputDatasetsReadParams();
        public String preQueries;
    }
}

