/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.univariate.OneWayAnova;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractNSampleTestStat;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.utils.JSON;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class OneWayAnovaTestStat
extends AbstractNSampleTestStat {
    private static final String ONE_WAY_ANOVA_TEST = "ONE_WAY_ANOVA_TEST_N_SAMPLE";

    public OneWayAnovaTestStat(String testColumn, String groupByColumn, @Nullable List<String> groupValues, int maxPopulations) {
        super(testColumn, groupByColumn, groupValues, maxPopulations);
    }

    public OneWayAnovaTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), ONE_WAY_ANOVA_TEST);
    }

    @Override
    protected Computation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        return new OneWayAnova(this.testColumn, this.getPopulationGrouping(), payloadParams.confidenceLevel);
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row) {
        OneWayAnova.OneWayAnovaResult tr = result.as(OneWayAnova.OneWayAnovaResult.class);
        this.fillCIs(tr.groups, 1.0 - significanceLevel, tr.means, tr.ciLowers, tr.ciUppers, row, cf);
        double pValue = tr.pvalue;
        String conclusion = OneWayAnovaTestStat.conclusion(pValue, significanceLevel);
        row.put(cf.column("f_statistic"), tr.statistic);
        row.put(cf.column("degrees_of_freedom"), tr.dof);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("conclusion"), conclusion);
    }

    private void fillCIs(GroupingResult groups, double confidenceLevel, double[] means, double[] ciLowers, double[] ciUppers, Row row, ColumnFactory cf) {
        LinkedHashMap<String, AbstractTestStat.SampleMeanCI> sampleMeanCIs = new LinkedHashMap<String, AbstractTestStat.SampleMeanCI>();
        List<Filter> filters = groups.listFilters();
        int nGroups = filters.size();
        if (means.length != nGroups) {
            throw new IllegalArgumentException(String.format("Expected as many means as groups, got %d means and %d groups", means.length, nGroups));
        }
        if (ciLowers.length != nGroups) {
            throw new IllegalArgumentException(String.format("Expected as many CIs as groups, got %d CI lower bounds and %d groups", means.length, nGroups));
        }
        if (ciUppers.length != nGroups) {
            throw new IllegalArgumentException(String.format("Expected as many CIs as groups, got %d CI upper bounds and %d groups", ciUppers.length, nGroups));
        }
        for (int i = 0; i < nGroups; ++i) {
            List<String> values = OneWayAnovaTestStat.extractPopulationValues(filters.get(i));
            if (values.size() != 1) {
                throw new IllegalArgumentException(String.format("Expected exactly 1 modality, got %d", values.size()));
            }
            String modality = values.get(0);
            AbstractTestStat.SampleMeanCI sampleMeanCI = new AbstractTestStat.SampleMeanCI(means[i], confidenceLevel, ciLowers[i], ciUppers[i]);
            sampleMeanCIs.put(modality, sampleMeanCI);
        }
        if (!sampleMeanCIs.isEmpty()) {
            row.put(cf.column("sample_mean_confidence_interval"), JSON.json(sampleMeanCIs));
        }
    }
}

