/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseMoodTest;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractPairwiseTestStat;
import java.util.List;
import javax.annotation.Nullable;

public class PairwiseMoodTestStat
extends AbstractPairwiseTestStat {
    private static final String PAIRWISE_MEDIAN_MOOD_TEST = "MEDIAN_MOOD_TEST_PAIRWISE";

    public PairwiseMoodTestStat(String testColumn, String groupByColumn, @Nullable List<String> groupValues, int maxPopulations, @Nullable String referenceGroup, PValueAdjustmentMethod adjustmentMethod) {
        super(testColumn, groupByColumn, groupValues, maxPopulations, referenceGroup, adjustmentMethod);
    }

    public PairwiseMoodTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), PAIRWISE_MEDIAN_MOOD_TEST);
    }

    @Override
    protected Computation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        return new PairwiseMoodTest(this.testColumn, this.getPopulationGrouping(), this.referenceGroup != null, this.adjustmentMethod);
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row, int i, int j, int rowIndex) {
        PairwiseMoodTest.PairwiseMoodTestResult tr = result.as(PairwiseMoodTest.PairwiseMoodTestResult.class);
        if (rowIndex >= tr.adjustedPvalues.length) {
            throw new IllegalArgumentException(String.format("Requested test index %d superior to number of available test results %d", rowIndex, tr.adjustedPvalues.length));
        }
        double pValue = tr.pvalues[rowIndex];
        double adjustedPValue = tr.adjustedPvalues[rowIndex];
        String conclusion = PairwiseMoodTestStat.conclusion(adjustedPValue, significanceLevel);
        row.put(cf.column("pearson_chi2_statistic"), tr.statistics[rowIndex]);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("adjusted_p_value"), adjustedPValue);
        row.put(cf.column("conclusion"), conclusion);
    }
}

