/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.docextraction.ScreenshotterService;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipePayloadBaseParams;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipeRunnerBase;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsIndexer;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecordManager;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRuleApplier;
import com.dataiku.dip.recipes.nlp.embed_documents.ExtractedDataWriter;
import com.dataiku.dip.recipes.nlp.embed_documents.IndexerComputationResult;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EmbedDocumentsRecipeRunner
extends EmbeddingRecipeRunnerBase {
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected ScreenshotterService screenshotterService;
    @Autowired
    protected LLMRefEnricherService llmRefEnricherService;
    protected EmbedDocumentsRecipePayloadParams desc;
    protected final EmbedDocumentsRecipeParams recipeParams;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.embed_documents");

    public EmbedDocumentsRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.recipeParams = this.recipe.getModel().getParamsAs(EmbedDocumentsRecipeParams.class);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (EmbedDocumentsRecipePayloadParams)JSON.parse((String)payload, EmbedDocumentsRecipePayloadParams.class);
    }

    @Override
    public EmbeddingRecipePayloadBaseParams parseRecipePayload(String payload) {
        return (EmbeddingRecipePayloadBaseParams)JSON.parse((String)payload, EmbedDocumentsRecipePayloadParams.class);
    }

    @Override
    protected List<String> getIgnoredVersionFiles() {
        return Arrays.asList("kb.json", "recipe_settings.json", "version_info.json", "kb_status.json");
    }

    @Override
    protected boolean shouldClearKnownledgeBankIfPreviousVersionNotComplete(EmbeddingRecipePayloadBaseParams.VectorStoreUpdateMethod vectorStoreUpdateMethod) {
        logger.info((Object)"Need to clear the KB to create a new record manager");
        return true;
    }

    @Override
    protected boolean shouldClearKnowledgeBankAfterSettingsChange(RetrievableKnowledge currentRk, RetrievableKnowledge previousRk, EmbeddingRecipePayloadBaseParams currentDesc, EmbeddingRecipePayloadBaseParams previousDesc, File previousVersionFolder) {
        boolean doClear = false;
        File previousRecordManagerFile = DKUApp.getFile((File)previousVersionFolder, (String[])new String[]{"dss_record_manager_cache.sqlite"});
        if (!previousRecordManagerFile.exists()) {
            logger.warn((Object)String.format("Previous KB folder exists & contains the settings files, but does not contain the record manager file: %s missing in %s", "dss_record_manager_cache.sqlite", previousVersionFolder.getAbsolutePath()));
            return this.shouldClearKnownledgeBankIfPreviousVersionNotComplete(currentDesc.getVectorStoreUpdateMethod());
        }
        if (currentDesc.getVectorStoreUpdateMethod().isSmart && !Objects.equals((Object)currentRk.vectorStoreType, (Object)previousRk.vectorStoreType)) {
            logger.info((Object)"Clearing knowledge bank after settings change (vectorStoreType)");
            doClear = true;
        }
        return doClear;
    }

    @Override
    public EmbeddingRecipePayloadBaseParams getRecipeBaseDesc() {
        return this.desc;
    }

    private List<InputRefs.ManagedFolderDocumentRefWithMetadata> listFolderContent(ManagedFolder folder, FlowComputable input) throws IOException, CodedException, DKUSecurityException {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        ArrayList<InputRefs.ManagedFolderDocumentRefWithMetadata> filesInFolder = new ArrayList<InputRefs.ManagedFolderDocumentRefWithMetadata>();
        try (ManagedFolderHandler inputHandler = (ManagedFolderHandler)folder.buildHandler(this.authCtx);){
            List<Partition> sources = subgraph.getSourcePartitions(input);
            for (Partition source : sources) {
                ManagedFolderHandler.ManagedFolderListing sourceFiles = inputHandler.listFS(source, true, false);
                logger.info((Object)("listing partition " + source.toString()));
                for (ManagedFolderHandler.ManagedFolderListingItem item : sourceFiles.items) {
                    filesInFolder.add(new InputRefs.ManagedFolderDocumentRefWithMetadata(new InputRefs.ManagedFolderDocumentRef(folder.getFullId(), item.toPath()), null, new HashMap<String, String>()));
                }
            }
        }
        logger.info((Object)("Done listing folder: \n" + String.valueOf(filesInFolder.stream().map(doc -> doc.documentRef.filePath).toList())));
        return filesInFolder;
    }

    private void indexAndProcessDocumentsInFolder(ManagedFolder inputFolder, FlowComputable folderAsFlowComputable, EmbedDocumentsRuleApplier ruleApplier, IndexerComputationResult indexerResult, EmbedDocumentsIndexer indexer, ExtractedDataWriter extractedDataWriter) throws Exception {
        List<InputRefs.ManagedFolderDocumentRefWithMetadata> inputDocuments = this.listFolderContent(inputFolder, folderAsFlowComputable);
        for (InputRefs.ManagedFolderDocumentRefWithMetadata document : inputDocuments) {
            ruleApplier.handleLoadedDocument(document, null, indexer, indexerResult, extractedDataWriter);
        }
        ruleApplier.onExtractionEnd(indexer, indexerResult);
        logger.info((Object)("Done loading input files: " + String.valueOf(inputDocuments.stream().map(doc -> doc.documentRef.filePath).toList())));
    }

    private void indexAndProcessDocumentsInBothDatasetAndFolder(Dataset dataset, final ManagedFolder folder, final EmbedDocumentsRuleApplier ruleApplier, final IndexerComputationResult indexerResult, final EmbedDocumentsIndexer indexer, final ExtractedDataWriter extractedDataWriter) throws Exception {
        if (this.desc.filePathMetadataColumn == null) {
            throw new IOException("Select a path column from the input dataset to use it as a metadata dataset");
        }
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        final Column pathColumn = scf.column(this.desc.filePathMetadataColumn);
        final Column securityColumn = this.desc.securityTokensColumn != null ? scf.column(this.desc.securityTokensColumn) : null;
        final Set allDatasetColumns = dataset.getSchema().columns.stream().map(arg_0 -> EmbedDocumentsRecipeRunner.lambda$indexAndProcessDocumentsInBothDatasetAndFolder$2((ColumnFactory)scf, arg_0)).collect(Collectors.toSet());
        final Set metadataColumns = this.desc.userDefinedMetadataColumns != null ? this.desc.userDefinedMetadataColumns.stream().map(arg_0 -> EmbedDocumentsRecipeRunner.lambda$indexAndProcessDocumentsInBothDatasetAndFolder$3((ColumnFactory)scf, arg_0)).collect(Collectors.toSet()) : null;
        final HashSet filesInBothDatasetAndFolder = new HashSet();
        logger.info((Object)"Reading dataset & matching corresponding documents to recipe rules");
        try (final ManagedFolderHandler inputHandler = (ManagedFolderHandler)folder.buildHandler(this.authCtx);){
            UniversalSingleThreadPusher threadPush = new UniversalSingleThreadPusher(this.authCtx, dataset, new ProcessorOutput(){

                public void setMaxMemoryUsed(long size) {
                }

                public void lastRowEmitted() throws Exception {
                }

                public void emitRow(Row row) throws Exception {
                    String filePath = row.get(pathColumn);
                    if (filePath == null) {
                        logger.warn((Object)("Skipping dataset row. Path column `" + pathColumn.getName() + "` is empty in row: " + String.valueOf(row)));
                        return;
                    }
                    FSPathOrDirectory fsPath = null;
                    try {
                        fsPath = inputHandler.getFile(filePath);
                    }
                    catch (Exception e) {
                        logger.error((Object)String.format("File %s missing from folder, skipping: %s", fsPath, e.getMessage()));
                        return;
                    }
                    if (fsPath != null) {
                        String securityTokens = securityColumn != null ? row.get(securityColumn) : null;
                        HashMap<String, String> metadataValues = new HashMap<String, String>();
                        if (metadataColumns != null) {
                            for (Column col : metadataColumns) {
                                metadataValues.put(col.getName(), row.get(col));
                            }
                        }
                        HashMap<String, String> rowValues = new HashMap<String, String>();
                        for (Column col : allDatasetColumns) {
                            rowValues.put(col.getName(), row.get(col));
                        }
                        filesInBothDatasetAndFolder.add(filePath);
                        InputRefs.ManagedFolderDocumentRefWithMetadata document = new InputRefs.ManagedFolderDocumentRefWithMetadata(new InputRefs.ManagedFolderDocumentRef(folder.getFullId(), (FSPath)fsPath), securityTokens, metadataValues);
                        ruleApplier.handleLoadedDocument(document, rowValues, indexer, indexerResult, extractedDataWriter);
                    }
                }

                public void cancel() throws Exception {
                }
            }, (ColumnFactory)scf, (RowFactory)srf, true);
            threadPush.push();
            ruleApplier.onExtractionEnd(indexer, indexerResult);
            logger.info((Object)("Done loading input files: ( " + threadPush.getProcessedRowCount() + " dataset rows, from which " + filesInBothDatasetAndFolder.size() + " correctly found in the input folder): " + String.valueOf(filesInBothDatasetAndFolder)));
        }
    }

    @Override
    public void run() throws Exception {
        SerializedRecipe.RecipeOutput ro2;
        logger.info((Object)"Embed documents recipe runner started");
        SerializedRecipe.RecipeOutput ro = (SerializedRecipe.RecipeOutput)this.recipe.getModel().getOutputsForRole("knowledge_bank").stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Knowledge bank output not found"));
        this.rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(ro.getLoc(this.recipe.getProjectKey()));
        this.checkKnowledgeBanksAllowed(this.rk);
        SerializedRecipe.RecipeInput ri = (SerializedRecipe.RecipeInput)this.recipe.getModel().getInputsForRole("main").stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Folder input not found"));
        ManagedFolder inputFolder = (ManagedFolder)this.managedFolderDAO.getMandatory(ri.getLoc(this.recipe.getProjectKey()));
        Dataset inputDataset = null;
        Optional optionalRecipeInputDataset = this.recipe.getModel().getInputsForRole("metadata_dataset").stream().findFirst();
        if (optionalRecipeInputDataset.isPresent()) {
            logger.info((Object)"Metadata Dataset is filled");
            SerializedRecipe.RecipeInput dataset_ri = (SerializedRecipe.RecipeInput)optionalRecipeInputDataset.orElseThrow(() -> new IllegalArgumentException("Input metadata dataset not found"));
            inputDataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(dataset_ri.getLoc(this.recipe.getProjectKey())));
        }
        this.desc.metadataColumns = new ArrayList();
        this.desc.metadataColumns.add(new EmbeddingRecipePayloadBaseParams.MetadataColumn("dku_file_path"));
        this.rk.metadataColumnsSchema = new ArrayList<SchemaColumn>();
        if (inputDataset != null && !this.desc.userDefinedMetadataColumns.isEmpty()) {
            Set userDefinedMetaColNames = this.desc.userDefinedMetadataColumns.stream().map(col -> col.column).collect(Collectors.toSet());
            this.desc.metadataColumns.addAll(this.desc.userDefinedMetadataColumns);
            this.rk.metadataColumnsSchema.addAll(inputDataset.getSchema().columns.stream().filter(sc -> userDefinedMetaColNames.contains(sc.getName())).toList());
        }
        this.rk.metadataColumnsSchema.add(new SchemaColumn("dku_file_path", Type.STRING));
        FlowComputable folderAsFlowComputable = this.recipe.getSourcesWithRoles().stream().filter((Predicate<FlowComputable.FlowComputableWithRole>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$9(com.dataiku.dip.dataflow.graph.FlowComputable$FlowComputableWithRole ), (Lcom/dataiku/dip/dataflow/graph/FlowComputable$FlowComputableWithRole;)Z)()).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$10(), ()Ljava/lang/IllegalArgumentException;)()).computable;
        if (folderAsFlowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) {
            throw new IllegalStateException("Embed documents recipe expect a folder as input");
        }
        ManagedFolder outfolder = null;
        boolean needFolderUpdate = false;
        if (this.recipe.getModel().getOutputsForRole("images").stream().findFirst().isPresent() && !(outfolder = (ManagedFolder)this.managedFolderDAO.getMandatory((ro2 = (SerializedRecipe.RecipeOutput)this.recipe.getModel().getOutputsForRole("images").stream().findFirst().get()).getLoc(this.recipe.getProjectKey()))).getFullId().equals(this.rk.managedFolderId)) {
            logger.warn((Object)("Output managed folder change detected from=" + this.rk.managedFolderId + ", to=" + outfolder.getFullId() + ", KB folder will be updated accordingly"));
            this.rk.managedFolderId = outfolder.getFullId();
            needFolderUpdate = true;
        }
        EnrichedLLMStructuredRef embeddingModelRef = this.llmRefEnricherService.getEnrichedLLMRef(this.rk.embeddingLLMId, this.authCtx, this.recipe.getProjectKey());
        EmbedDocumentsRuleApplier ruleApplier = new EmbedDocumentsRuleApplier(this.recipeParams.getRules(embeddingModelRef), this.recipeParams.getAllOtherFilesRule(), outfolder, this.authCtx, this.recipe.getProjectKey(), this.ticketService, this.activity, this.screenshotterService);
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("embed-documents-recipe", "pyrun");){
            File baseFolder = DKUApp.getFile((String[])new String[]{"knowledge-banks", this.rk.projectKey, this.rk.id});
            MLPaths.createIfNeededFolderAndRestrictPermissions(baseFolder);
            this.desc.clearVectorStore = this.desc.clearVectorStore || this.shouldClearKnowledgeBank(this.rk);
            String version = "" + System.currentTimeMillis();
            File rkFolder = DKUApp.getFile((File)baseFolder, (String[])new String[]{"versions", version});
            MLPaths.createIfNeededFolderAndRestrictPermissions(rkFolder);
            if (!this.desc.clearVectorStore) {
                this.copyPreviousVersionFolder(this.rk, rkFolder);
            }
            EmbedDocumentsRecordManager recordManager = new EmbedDocumentsRecordManager(rkFolder, this.recipe.getProjectKey());
            EmbedDocumentsIndexer indexer = new EmbedDocumentsIndexer(this.desc.vectorStoreUpdateMethod, recordManager);
            ExtractedDataWriter extractedDataWriter = new ExtractedDataWriter(outputTmpDir);
            IndexerComputationResult indexerResult = indexer.startIndexing();
            if (inputDataset != null) {
                this.indexAndProcessDocumentsInBothDatasetAndFolder(inputDataset, inputFolder, ruleApplier, indexerResult, indexer, extractedDataWriter);
            } else {
                this.indexAndProcessDocumentsInFolder(inputFolder, folderAsFlowComputable, ruleApplier, indexerResult, indexer, extractedDataWriter);
            }
            extractedDataWriter.dumpOutdatedChunksUuids(indexer.getChunksIdsToDelete(indexerResult));
            this.desc.knowledgeColumn = "DKU_GENERATED_EMBEDDING";
            this.desc.documentSplittingMode = EmbeddingRecipePayloadBaseParams.DocumentSplittingMode.NONE;
            InitializableAbortableRecipeRunner runner = this.createRunner(baseFolder, rkFolder, outputTmpDir);
            SpringUtils.getInstance().autowire((Object)runner);
            runner.init();
            this.abortableRunner = runner;
            runner.run();
            if (needFolderUpdate) {
                this.updateManagedFolderId();
            }
            String runID = JobContext.getCurrentJobContext().jobId;
            indexer.updateRecordManagerAndCleanOutdatedScreenshots(indexerResult, extractedDataWriter.processedDocumentResourcesAccumulator, outfolder, this.authCtx, runID);
            this.updateMetadataColsSchema(this.rk);
            this.updateKBVersionOnDisk(this.rk, rkFolder, version);
            this.updateKBStatusOnDisk(rkFolder);
        }
    }

    private void updateManagedFolderId() throws IOException {
        String secret = this.ticketService.getSingleTicket().getSecret();
        try (TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);){
            logger.info((Object)("Setting new managed folder " + this.rk.managedFolderId + " on knowledge bank " + this.rk.getFullId()));
            tClient.postFormToJSON("/dip/api/tintercom/knowledge-bank/set-managed-folder", Void.class, new Object[]{"knowledgeBankFullId", this.rk.getFullId(), "managedFolderId", this.rk.managedFolderId});
            this.retrievableKnowledgeDAO.save(this.rk);
        }
    }

    private void updateKBStatusOnDisk(File rkFolder) throws Exception {
        File statusFile = DKUApp.getFile((File)rkFolder, (String[])new String[]{"kb_status.json"});
        RetrievableKnowledge.RetrievableKnowledgeStatus status = new RetrievableKnowledge.RetrievableKnowledgeStatus();
        if (statusFile.exists()) {
            String kbStatus = DKUFileUtils.readFileToStringUTF8((File)statusFile);
            status = (RetrievableKnowledge.RetrievableKnowledgeStatus)JSON.parse((String)kbStatus, RetrievableKnowledge.RetrievableKnowledgeStatus.class);
        }
        EmbedDocumentsRecordManager recordManager = new EmbedDocumentsRecordManager(rkFolder, this.recipe.getProjectKey());
        status.nbChunks = recordManager.getNumberOfChunks();
        status.nbDocuments = recordManager.getNumberOfDocuments();
        DKUFileUtils.writeFileUTF8((File)statusFile, (String)JSON.pretty((Object)status));
    }

    private InitializableAbortableRecipeRunner createRunner(File baseFolder, final File rkFolder, final AutoDelete outputTmpDir) throws Exception {
        File additionalLogsDir = FlowJobUtils.getJobMadeDir("embed-documents-recipe", "additional-logs");
        File mainLogFile = FlowJobUtils.getJobTouchedFile("embed-documents-recipe", "python.log");
        final Optional<CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo> remoteVectorStoreConnectionInfo = this.getRemoteVectorStoreConnectionInfo(this.authCtx, this.rk.connection);
        JobContext.getCurrentActivitySummary().engineType = "DSS";
        return new AbstractPythonRecipeRunner(this.activity){

            @Override
            public void run() throws Exception {
                String envName = new CodeEnvSelector().selectForPythonRecipe(this.recipe.getProjectKey(), ((EmbedDocumentsRecipeRunner)EmbedDocumentsRecipeRunner.this).rk.envSelection);
                logger.info((Object)("Run embed documents in code env " + StringUtils.defaultIfBlank((String)envName, (String)"built-in")));
                logger.info((Object)("Dumping desc to recipe_Settings.json" + String.valueOf(EmbedDocumentsRecipeRunner.this.desc)));
                JSON.prettyToFile((Object)EmbedDocumentsRecipeRunner.this.desc, (File)new File(rkFolder, "recipe_settings.json"));
                JSON.prettyToFile((Object)EmbedDocumentsRecipeRunner.this.rk, (File)new File(rkFolder, "kb.json"));
                this.executeModule(envName, (File)outputTmpDir, "dataiku.llm.rag.embed_documents_recipe", false, rkFolder.getAbsolutePath());
            }

            @Override
            public void init() throws Exception {
            }

            @Override
            public void enrichModuleProcess(ProcessBuilder builder) {
                remoteVectorStoreConnectionInfo.ifPresent(connectionLocationInfo -> builder.environment().put("DKU_KB_CONNECTION_INFO", JSON.json((Object)connectionLocationInfo)));
            }
        };
    }

    private static /* synthetic */ IllegalArgumentException lambda$run$10() {
        return new IllegalArgumentException("Folder input not found from recipe sources");
    }

    private static /* synthetic */ boolean lambda$run$9(FlowComputable.FlowComputableWithRole source) {
        return source.role.equals("main");
    }

    private static /* synthetic */ Column lambda$indexAndProcessDocumentsInBothDatasetAndFolder$3(ColumnFactory scf, EmbeddingRecipePayloadBaseParams.MetadataColumn col) {
        return scf.column(col.column);
    }

    private static /* synthetic */ Column lambda$indexAndProcessDocumentsInBothDatasetAndFolder$2(ColumnFactory scf, SchemaColumn schemaColumn) {
        return scf.column(schemaColumn.getName());
    }
}

