/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.services;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.server.services.RecipeSchemaChangeService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipeIOChangeService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipeSchemaChangeService recipeSchemaChangeService;

    public RecipeIOChangeResponse getChangeResponse_NT(SerializedRecipe.SerializedRecipeAndPayload beforeChange, SerializedRecipe.SerializedRecipeAndPayload afterChange, String projectKey) throws IOException {
        SerializedRecipe.SerializedRecipeAndPayload updated = (SerializedRecipe.SerializedRecipeAndPayload)JSON.deepCopy((Object)afterChange);
        RecipeIOChangeResponse ret = new RecipeIOChangeResponse();
        try (Transaction t = this.transactionService.beginRead();){
            new PDepsFixuper().fixupInPlace(updated.recipe);
        }
        InfoMessage.InfoMessages messages = this.recipeSchemaChangeService.collectIOChanges_NT(projectKey, beforeChange, afterChange);
        ret.messages.mergeFrom(messages);
        ret.updated = updated;
        return ret;
    }

    public static class RecipeIOChangeResponse {
        SerializedRecipe.SerializedRecipeAndPayload updated;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }
}

