/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dashboards.insights.report.ReportInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.reports.RMarkdownReportRunner;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportCodes;
import com.dataiku.dip.reports.ReportSnapshot;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportsSnapshotsService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private VariablesService variablesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.reports.snapshots");

    public FutureResponse<ReportSnapshotResponse> startCreate(Report report, String script, AuthCtx authCtx) throws Exception {
        logger.infoV("Create a new report snapshot: %s.%s", new Object[]{report.projectKey, report.id});
        this.checkParams(report.params);
        Set<Report.ReportOutputFormat> formats = this.listSnapshotFormats(report.params);
        ReportSnapshotFutureThread ft = new ReportSnapshotFutureThread(report, script, formats, authCtx);
        return this.futureService.runFuture(ft, 1000L, new TypeToken<FutureResponse<ReportSnapshotResponse>>(){});
    }

    public List<ReportSnapshot> listSorted_NT(String projectKey, String id) {
        ArrayList<ReportSnapshot> ret = new ArrayList<ReportSnapshot>();
        HashMap<Long, ReportSnapshot> snapshotByTimestamp = new HashMap<Long, ReportSnapshot>();
        File dir = this.getSnapshotsDir(projectKey, id);
        Object[] files = dir.listFiles();
        if (files == null) {
            return ret;
        }
        Arrays.sort(files);
        Collections.reverse(Arrays.asList(files));
        for (Object f : files) {
            ReportSnapshot snapshot = this.fileToReportSnapshot((File)f, projectKey, id);
            if (snapshot == null) continue;
            if (snapshotByTimestamp.containsKey(snapshot.timestamp)) {
                ReportSnapshot previous = (ReportSnapshot)snapshotByTimestamp.get(snapshot.timestamp);
                previous.withFormat(snapshot.availableFormats.iterator().next());
                continue;
            }
            snapshotByTimestamp.put(snapshot.timestamp, snapshot);
            ret.add(snapshot);
        }
        return ret;
    }

    public ReportSnapshot getLast_NT(String projectKey, String id) throws NotFoundException {
        List<ReportSnapshot> snapshots = this.listSorted_NT(projectKey, id);
        if (snapshots.isEmpty()) {
            throw new NotFoundException("Report has no snapshots");
        }
        return snapshots.get(0);
    }

    public ReportSnapshot getForTimestamp_NT(String projectKey, String id, long timestamp) throws NotFoundException {
        List<ReportSnapshot> snapshots = this.listSorted_NT(projectKey, id);
        for (ReportSnapshot s : snapshots) {
            if (s.timestamp != timestamp) continue;
            return s;
        }
        throw new NotFoundException("Report snapshot not found for timestamp " + timestamp);
    }

    public ReportSnapshot getSnapshotFromInsight_NT(Insight insight) throws NotFoundException {
        ReportInsightParams params = insight.getParamsAs(ReportInsightParams.class);
        AnyLoc reportLoc = AnyLoc.resolveSmart(insight.projectKey, params.reportSmartId);
        if (params.loadLast) {
            return this.getLast_NT(reportLoc.getProjectKey(), reportLoc.getId());
        }
        return this.getForTimestamp_NT(reportLoc.getProjectKey(), reportLoc.getId(), params.exportTimestamp);
    }

    public Report.ReportOutputFormat findExistingFormatForBackwardsCompatibility(ReportSnapshot snapshot) {
        for (ReportSnapshot s : this.listSorted_NT(snapshot.projectKey, snapshot.reportId)) {
            if (s.timestamp != snapshot.timestamp || s.availableFormats == null || !s.availableFormats.iterator().hasNext()) continue;
            return s.availableFormats.iterator().next();
        }
        return null;
    }

    public File getSnapshotOutputFile(ReportSnapshot snapshot, Report.ReportOutputFormat viewFormat) {
        return new File(this.getSnapshotsDir(snapshot), snapshot.timestamp + "." + viewFormat.getExtension());
    }

    void deleteForReport(String projectKey, String id) {
        try {
            File file = this.getSnapshotsDir(projectKey, id);
            if (file.exists()) {
                DKUFileUtils.forceDelete((File)file);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete code report snapshots", (Throwable)e);
        }
    }

    private Set<Report.ReportOutputFormat> listSnapshotFormats(Report.ReportParams params) {
        HashSet<Report.ReportOutputFormat> ret = new HashSet<Report.ReportOutputFormat>();
        if (params.snapshotFormats != null) {
            for (Report.ReportOutputFormat format : Report.ReportOutputFormat.values()) {
                String name = format.toString();
                if (!params.snapshotFormats.containsKey(name) || !params.snapshotFormats.get(name).booleanValue()) continue;
                ret.add(format);
            }
        }
        ret.add(params.viewFormat);
        return ret;
    }

    private void checkParams(Report.ReportParams params) throws CodedException {
        if (params == null) {
            throw new IllegalArgumentException("Empty code report params");
        }
        if (params.snapshotFormats == null || params.snapshotFormats.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)ReportCodes.ERR_INVALID_REPORT_CONFIG, "No snapshot format specified in report settings");
        }
    }

    private File getSnapshotsDir(String projectKey, String reportId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"code-reports", projectKey, reportId, "snapshots"});
    }

    private File getSnapshotsDir(ReportSnapshot snapshot) {
        return this.getSnapshotsDir(snapshot.projectKey, snapshot.reportId);
    }

    private ReportSnapshot fileToReportSnapshot(File f, String projectKey, String reportId) {
        if (f.isFile()) {
            String filename = f.getName();
            if (f.isFile() && filename.indexOf(46) > 0) {
                int dot = filename.indexOf(46);
                String extension = filename.substring(dot + 1);
                filename = filename.substring(0, dot);
                Report.ReportOutputFormat format = Report.ReportOutputFormat.getByExtension(extension);
                if (format != null && filename.matches("\\d*")) {
                    long timestamp = Long.parseLong(filename);
                    return new ReportSnapshot(projectKey, reportId, timestamp).withFormat(format);
                }
            }
        }
        return null;
    }

    private class ReportSnapshotFutureThread
    extends SimpleFutureThread<ReportSnapshotResponse> {
        private Report report;
        private String script;
        private Set<Report.ReportOutputFormat> formats;
        private DKUtils.SmartLogTailBuilder smartLogTailBuilder;

        public ReportSnapshotFutureThread(Report report, String script, Set<Report.ReportOutputFormat> formats, AuthCtx owner) {
            super(owner);
            this.smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.report = report;
            this.script = script;
            this.formats = formats;
        }

        public SmartLogTail getLog() {
            return this.smartLogTailBuilder.get();
        }

        public FuturePayload getPayload() {
            FuturePayload ret = new FuturePayload();
            ret.targets = Lists.newArrayList((Object[])new FuturePayload.FuturePayloadTarget[]{DSSFuturePayloadUtils.forTaggableObject(this.report)});
            ret.displayName = "Build report";
            ret.action = "BUILD_REPORT";
            return ret;
        }

        @Override
        public ReportSnapshotResponse compute() throws Exception {
            try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("RMarkdown snapshot " + this.report.projectKey + "." + this.report.id));){
                logger.info((Object)"Starting thread to snapshot RMarkdown report");
                ReportSnapshotResponse ret = new ReportSnapshotResponse();
                ret.snapshot = new ReportSnapshot(this.report.projectKey, this.report.id, System.currentTimeMillis());
                for (Report.ReportOutputFormat format : this.formats) {
                    logger.info((Object)("Starting to snapshot to format " + String.valueOf((Object)format)));
                    ret.snapshot.withFormat(format);
                    File outputFile = this.getSnapshotsFile(ret.snapshot, format);
                    RMarkdownReportRunner builder = new RMarkdownReportRunner(this.report, this.script, format, outputFile, this.owner);
                    builder.build(this.smartLogTailBuilder);
                    logger.info((Object)("Snapshot built for format " + String.valueOf((Object)format)));
                }
                this.writeRmdFile(ret.snapshot);
                ReportSnapshotResponse reportSnapshotResponse = ret;
                return reportSnapshotResponse;
            }
        }

        private void writeRmdFile(ReportSnapshot snapshot) throws IOException {
            File scriptFile = new File(ReportsSnapshotsService.this.getSnapshotsDir(snapshot), snapshot.timestamp + ".Rmd");
            Map variables = ReportsSnapshotsService.this.variablesService.getContext(this.report.projectKey).getAllVariables();
            String expanded = StrSubstitutor.replace((Object)this.script, (Map)variables);
            FileUtils.write((File)scriptFile, (CharSequence)expanded, (String)"utf8");
        }

        private File getSnapshotsFile(ReportSnapshot snapshot, Report.ReportOutputFormat format) {
            return new File(ReportsSnapshotsService.this.getSnapshotsDir(snapshot), snapshot.timestamp + "." + format.getExtension());
        }
    }

    public static class ReportSnapshotResponse {
        public ReportSnapshot snapshot;
    }
}

