/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SavedModelsAgentsService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.service");

    public SavedModel createAgent(AuthCtx authCtx, String projectKey, SavedModel.SavedModelType type, String name, String zoneId) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = type;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Agent " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit("Created Agent: " + name + ": " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public FullModelId createAgentVersion(AuthCtx authCtx, SavedModel sm, String versionId, SavedModel.SavedModelInlineVersion smiv) throws Exception {
        if (sm.savedModelType == SavedModel.SavedModelType.PLUGIN_AGENT) {
            throw new IllegalArgumentException("Plugin agents do not support versioning");
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier("_");
        List usedIds = sm.inlineVersions.stream().map(version -> version.versionId).collect(Collectors.toList());
        transmogrifier.addAllAlreadyTransmogrifiedAcceptDupes(usedIds);
        smiv.versionId = versionId = transmogrifier.transmogrify(versionId);
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        sm.inlineVersions.add(smiv);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) == null) {
                throw new IllegalArgumentException("Saved model " + sm.id + " does not exist");
            }
            if (sm.inlineVersions.size() == 1) {
                sm.activeVersion = versionId;
            }
            this.savedModelsCRUDService.save(sm, false, false);
            t.commit("Added Agent version: " + sm.id + " / Version: " + versionId);
        }
        return new FullModelId(sm.projectKey, sm.id, versionId);
    }

    public SavedModel createPluginAgentAndVersion(AuthCtx authCtx, String projectKey, String pluginAgentType, String name, String zoneId) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = SavedModel.SavedModelType.PLUGIN_AGENT;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        SavedModel.SavedModelInlineVersion smiv = new SavedModel.SavedModelInlineVersion();
        smiv.pluginAgentType = pluginAgentType;
        smiv.pluginAgentConfig = new JsonObject();
        smiv.versionId = "v1";
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        sm.inlineVersions.add(smiv);
        sm.activeVersion = smiv.versionId;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Agent " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit("Created Agent: " + name + ": " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public SavedModel createToolsUsingAgentAndVersion(AuthCtx authCtx, String projectKey, String name, String zoneId) throws Exception {
        SavedModel sm = new SavedModel();
        sm.projectKey = projectKey;
        sm.id = SecretKeyGenerator.generate((int)8);
        sm.name = name;
        sm.savedModelType = SavedModel.SavedModelType.TOOLS_USING_AGENT;
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, sm.projectKey, targetSMFolder);
        SavedModel.SavedModelInlineVersion smiv = new SavedModel.SavedModelInlineVersion();
        smiv.versionId = "v1";
        smiv.creationTag = new VersionTag(authCtx.getIdentifier());
        smiv.versionTag = new VersionTag(authCtx.getIdentifier());
        sm.inlineVersions.add(smiv);
        sm.activeVersion = smiv.versionId;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            if (this.savedModelsDAO.getOrNull(sm.projectKey, sm.id) != null) {
                throw new IllegalArgumentException("Agent " + sm.id + " already exists");
            }
            this.savedModelsCRUDService.save(sm, true, false);
            if (StringUtils.isNotBlank((String)zoneId)) {
                this.flowZonesService.attachObjectToZone(zoneId, projectKey, sm, true);
            }
            t.commit("Created Agent: " + name + ": " + sm.id);
            SavedModel savedModel = sm;
            return savedModel;
        }
    }

    public SavedModel save(AuthCtx authCtx, SavedModel sm, @Nullable String versionId) throws Exception {
        if (versionId != null) {
            SavedModel preExisting = (SavedModel)this.savedModelsDAO.getMandatory(sm.projectKey, sm.id);
            SavedModel.SavedModelInlineVersion preExistingInlineVersion = preExisting.getVersion(versionId).orElseThrow(() -> new IllegalArgumentException("Agent version " + versionId + " does not exist."));
            SavedModel.SavedModelInlineVersion currentInlineVersion = sm.getVersion(versionId).orElseThrow(() -> new IllegalArgumentException("Agent version " + versionId + " does not exist."));
            currentInlineVersion.versionTag = VersionTag.increment(preExistingInlineVersion.versionTag, authCtx.getIdentifier());
            currentInlineVersion.creationTag = (VersionTag)JSON.deepCopy((Object)preExistingInlineVersion.creationTag);
        }
        return this.savedModelsCRUDService.save(sm, false, false);
    }

    public List<LogsService.LogDesc> listLogs(String projectKey, String smId, String versionId) throws IOException {
        File logsDir = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs"});
        if (!logsDir.isDirectory()) {
            logger.info((Object)"logs dir does not exist");
            return new ArrayList<LogsService.LogDesc>();
        }
        return Files.find(logsDir.toPath(), 3, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]).map(path -> new LogsService.LogDesc(path.toFile(), logsDir)).collect(Collectors.toList());
    }

    public SmartLogTail getLog(String projectKey, String smId, String versionId, String logName) throws IOException {
        File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
        if (logFile.isFile()) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        throw new IOException("Log file doesn't exist");
    }

    public void streamLog(String projectKey, String smId, String versionId, String logName, OutputStream os) throws IOException {
        block11: {
            File logFile = DKUApp.getFile((String[])new String[]{"saved_models", projectKey, smId, "versions", versionId, "logs", logName});
            if (logFile.isFile()) {
                logger.info((Object)("Start compressed stream from " + String.valueOf(logFile)));
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file doesn't exist");
        }
    }
}

