/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.helpers;

import com.dataiku.scoring.models.DecisionTreeModel;

public class NodeRescaler {
    private final double baseline;
    private final double shrinkage;

    public NodeRescaler(double baseline, double shrinkage) {
        this.baseline = baseline;
        this.shrinkage = shrinkage;
    }

    public DecisionTreeModel.Node<Double> rescale(DecisionTreeModel.Node<Double> root) {
        return this.rescaleNode(root);
    }

    private DecisionTreeModel.Node<Double> rescaleNode(DecisionTreeModel.Node<Double> node) {
        if (node.isLeaf) {
            double rescaledLabel = this.baseline + this.shrinkage * (Double)node.label;
            return DecisionTreeModel.Node.leaf((long)node.id, (Object)rescaledLabel);
        }
        return DecisionTreeModel.Node.node((long)node.id, (int)node.variable, (double)node.threshold, this.rescaleNode((DecisionTreeModel.Node<Double>)node.leftSon), this.rescaleNode((DecisionTreeModel.Node<Double>)node.rightSon), (Boolean)node.missingGoesLeft);
    }
}

