/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.util.DatasetLocUtils;

public abstract class ConfigurablePublicAPIKey
extends PublicAPIKey {
    public String dssUserForImpersonation;

    public ConfigurablePublicAPIKey() {
    }

    public ConfigurablePublicAPIKey(String key) {
        this.key = key;
    }

    public ConfigurablePublicAPIKey(ConfigurablePublicAPIKey key) {
        super((PublicAPIKey)key);
        this.dssUserForImpersonation = key.dssUserForImpersonation;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public abstract boolean hasDirectDatasetPrivilege(Privileges.DatasetLevelPrivilegeType var1, DatasetLocUtils.DatasetLoc var2);

    public boolean hasEffectiveDatasetPrivilege(Privileges.DatasetLevelPrivilegeType privilegeType, DatasetLocUtils.DatasetLoc loc) {
        if (this.hasDirectDatasetPrivilege(privilegeType, loc)) {
            return true;
        }
        return this.hasProjectPrivilege(privilegeType.requiredProjectPrivilege, loc.getProjectKey());
    }

    public abstract boolean hasSQLikePrivilege();

    public abstract boolean hasProjectPrivilege(Privileges.ProjectLevelPrivilegeType var1, String var2);

    public abstract boolean mayDevelopPlugins();

    public abstract boolean mayEditLibFolders();

    public abstract boolean mayCreateCodeEnvs();

    public abstract boolean mayManageCodeEnvs();

    public abstract boolean mayCreateClusters();

    public abstract boolean mayManageClusters();

    public abstract boolean mayCreateCodeStudioTemplates();

    public abstract boolean mayManageCodeStudioTemplates();

    public abstract boolean mayCreateActiveWebContent();

    public abstract boolean hasCodeEnvPrivilege(Privileges.CodeEnvLevelPrivilegeType var1, CodeEnvModel.EnvLang var2, String var3);

    public abstract boolean hasClusterPrivilege(Privileges.ClusterLevelPrivilegeType var1, String var2);

    public abstract boolean hasCodeStudioTemplatePrivilege(Privileges.CodeStudioTemplatePrivilegeType var1, String var2);

    public abstract boolean hasPluginPrivilege(Privileges.PluginLevelPrivilegeType var1, boolean var2, String var3);

    public abstract boolean hasPluginPresetPrivilege(Privileges.PluginPresetLevelPrivilegeType var1, boolean var2, String var3);

    public abstract boolean hasProjectFolderPrivilege(Privileges.ProjectFolderLevelPrivilegeType var1, String var2);

    public abstract boolean hasPluginParameterSetPrivilege(Privileges.PluginParameterSetLevelPrivilegeType var1, boolean var2, String var3);

    public abstract boolean mayManageFeatureStore();

    public String getKey() {
        return this.key;
    }

    public boolean isGlobalAdmin() {
        return false;
    }
}

