/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGlobalOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.DKUSecurityRuntimeException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CredentialsService
implements ICredentialsService {
    private static final String CONNECTION = "connection";
    private static final String PLUGIN_CREDENTIAL_REQUEST = "plugin credential request";
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private TransactionService transactionService;

    @Override
    public ICredentialsService.Credential getDecryptedCredential_AutoTXN(AuthCtx authCtx, DSSConnection conn) throws IOException {
        Validate.notNull((Object)authCtx);
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        ICredentialsService.Credential cred = this.getCredential_AutoTXN(authCtx, conn);
        cred.decryptInPlace(cryptoService);
        return cred;
    }

    @Override
    public ICredentialsService.Credential getDecryptedCredential_AutoTXN(AuthCtx authCtx, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) throws IOException {
        Validate.notNull((Object)authCtx);
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        ICredentialsService.Credential cred = this.getUserCredential_AutoTXN(authCtx, credentialRequestInfo);
        if (cred != null) {
            cred.decryptInPlace(cryptoService);
        }
        return cred;
    }

    @Override
    public ICredentialsService.Credential getCredential_AutoTXN(AuthCtx authCtx, DSSConnection connection) throws IOException {
        if (StringUtils.isNotBlank((String)connection.customBasicConnectionCredentialProviderClass)) {
            try {
                Class<?> clazz = Class.forName(connection.customBasicConnectionCredentialProviderClass);
                DSSConnection.BasicConnectionCredentialProvider provider = (DSSConnection.BasicConnectionCredentialProvider)clazz.newInstance();
                provider.setConnection(connection);
                provider.setParams(connection.customBasicConnectionCredentialProviderParams);
                return provider.getCredential(authCtx);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to resolve connection credential", t);
            }
        }
        switch (connection.credentialsMode) {
            case GLOBAL: {
                if (connection instanceof ConnectionWithGlobalOAuth2Credentials && ((ConnectionWithGlobalOAuth2Credentials)((Object)connection)).actuallyHasGlobalOAuth2Credential()) {
                    throw new SecurityException("Retrieving token for Global OAuth is not supported for connection " + String.valueOf(connection));
                }
                if (connection instanceof ConnectionWithBasicCredential) {
                    return ((ConnectionWithBasicCredential)((Object)connection)).getGlobalCredential();
                }
                throw new SecurityException("Don't know how to get credential for connection " + String.valueOf(connection));
            }
            case PER_USER: {
                return this.getUserCredential_AutoTXN(authCtx, connection);
            }
        }
        throw new Error("unreachable");
    }

    private ICredentialsService.Credential getUserCredential_AutoTXN(AuthCtx authCtx, DSSConnection connection) throws IOException {
        ICredentialsService.Credential userCredential = this.getUserCredential_AutoTXN(authCtx, connection.getNameForCredentials(), CONNECTION);
        if (userCredential == null) {
            throw new DKUSecurityRuntimeException("User '" + authCtx.getDSSUserForImpersonation() + "' does not have credentials for connection '" + connection.name + "' to access " + connection.type).withCode((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_NO_CREDENTIALS).withPayload("connectionName", (Object)connection.getNameForCredentials()).withPayload("user", (Object)authCtx.getDSSUserForImpersonation()).withPayload("sameUser", (Object)authCtx.isUserSameAsParent());
        }
        return userCredential;
    }

    private ICredentialsService.Credential getUserCredential_AutoTXN(AuthCtx authCtx, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) throws IOException {
        ICredentialsService.Credential userCredential = this.getUserCredential_AutoTXN(authCtx, credentialRequestInfo.getNameForCredentialMap(), PLUGIN_CREDENTIAL_REQUEST);
        if (userCredential == null && credentialRequestInfo.mandatory) {
            throw new DKUSecurityRuntimeException("User '" + authCtx.getDSSUserForImpersonation() + "' does not have credentials for plugin parameter '" + credentialRequestInfo.getNameForCredentialMap() + "'").withCode((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_NO_CREDENTIALS).withPayload("pluginId", (Object)credentialRequestInfo.pluginId).withPayload("paramSetId", (Object)credentialRequestInfo.paramSetId).withPayload("presetId", (Object)credentialRequestInfo.presetId).withPayload("paramName", (Object)credentialRequestInfo.paramName).withPayload("user", (Object)authCtx.getDSSUserForImpersonation()).withPayload("sameUser", (Object)authCtx.isUserSameAsParent());
        }
        return userCredential;
    }

    private ICredentialsService.Credential getUserCredential_AutoTXN(AuthCtx authCtx, String credentialName, String type) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.getUserCredential(authCtx, credentialName, type);
        }
        try (Transaction t = this.transactionService.beginRead();){
            ICredentialsService.Credential credential = this.getUserCredential(authCtx, credentialName, type);
            return credential;
        }
    }

    private ICredentialsService.Credential getUserCredential(AuthCtx authCtx, String credentialName, String type) throws IOException {
        String dssUser = authCtx.getDSSUserForImpersonation();
        UsersDAO.User u = this.usersDAO.getMandatoryUnsafe(dssUser);
        ICredentialsService.StoredCredential storedCred = null;
        if (u.credentials != null) {
            storedCred = u.credentials.get(credentialName);
        }
        if (storedCred == null) {
            return null;
        }
        switch (storedCred.type) {
            case SINGLE_FIELD: {
                return new ICredentialsService.SingleFieldCredential(storedCred.password);
            }
            case BASIC: {
                return new ICredentialsService.BasicCredential(storedCred.user, storedCred.password);
            }
            case OAUTH_REFRESH_TOKEN: 
            case AZURE_OAUTH_DEVICECODE: {
                return new ICredentialsService.OAuthRefreshTokenCredential(storedCred.refreshToken, storedCred.lastUpdate);
            }
        }
        throw new Error("unreachable");
    }
}

