/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.ConfigurablePublicAPIKey;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ProjectScopePublicAPIKey
extends ConfigurablePublicAPIKey {
    @JSON.FileTransient
    public String projectKey;
    public boolean execSQLLike;
    private List<LocalDatasetPrivilege> localDatasets = new ArrayList<LocalDatasetPrivilege>();
    public SerializedProject.PermissionItem projectPrivileges = new SerializedProject.PermissionItem();
    public String onBehalf;

    public ProjectScopePublicAPIKey() {
    }

    public ProjectScopePublicAPIKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public ProjectScopePublicAPIKey(String projectKey, String key) {
        super(key);
        this.projectKey = projectKey;
    }

    public ProjectScopePublicAPIKey(ProjectScopePublicAPIKey key) {
        super(key);
        this.projectKey = key.projectKey;
        this.projectPrivileges = key.projectPrivileges.deepCopy();
        key.localDatasets.forEach(d -> this.localDatasets.add(d.deepCopy()));
        this.onBehalf = key.onBehalf;
        this.execSQLLike = key.execSQLLike;
    }

    public ProjectScopePublicAPIKey deepCopy() {
        return new ProjectScopePublicAPIKey(this);
    }

    @Override
    public boolean hasDirectDatasetPrivilege(Privileges.DatasetLevelPrivilegeType privilegeType, DatasetLocUtils.DatasetLoc loc) {
        for (LocalDatasetPrivilege udp : this.localDatasets) {
            for (String dataset : udp.datasets) {
                if (!loc.getProjectKey().equals(this.projectKey) || !loc.getName().equals(dataset) || !udp.privileges.contains((Object)privilegeType)) continue;
                return true;
            }
        }
        return false;
    }

    public List<LocalDatasetPrivilege> getLocalDatasetPrivileges() {
        return this.localDatasets;
    }

    public UsersDAO.GroupPermissions getGlobalPermissions() {
        return new UsersDAO.GroupPermissions();
    }

    @Override
    public boolean hasProjectPrivilege(Privileges.ProjectLevelPrivilegeType requiredProjectPrivilege, String projectKey) {
        if (StringUtils.isBlank((String)projectKey) || !StringUtils.equals((String)projectKey, (String)this.projectKey)) {
            return false;
        }
        return PermissionsService.permissionItemIncludes(this.projectPrivileges, requiredProjectPrivilege);
    }

    @Override
    public boolean hasSQLikePrivilege() {
        return this.execSQLLike;
    }

    @Override
    public boolean mayCreateCodeEnvs() {
        return false;
    }

    @Override
    public boolean mayCreateClusters() {
        return false;
    }

    @Override
    public boolean mayCreateCodeStudioTemplates() {
        return false;
    }

    @Override
    public boolean hasCodeEnvPrivilege(Privileges.CodeEnvLevelPrivilegeType requiredCodeEnvPrivilege, CodeEnvModel.EnvLang envLang, String envName) {
        return false;
    }

    @Override
    public boolean hasClusterPrivilege(Privileges.ClusterLevelPrivilegeType requiredClusterPrivilege, String clusterId) {
        return false;
    }

    @Override
    public boolean hasCodeStudioTemplatePrivilege(Privileges.CodeStudioTemplatePrivilegeType requiredClusterPrivilege, String codeStudioTemplateId) {
        return false;
    }

    @Override
    public boolean hasPluginPrivilege(Privileges.PluginLevelPrivilegeType requiredPluginPrivilege, boolean isDev, String pluginId) {
        return false;
    }

    @Override
    public boolean hasPluginPresetPrivilege(Privileges.PluginPresetLevelPrivilegeType requiredPluginPresetPrivilege, boolean isDev, String elementType) {
        return false;
    }

    @Override
    public boolean hasProjectFolderPrivilege(Privileges.ProjectFolderLevelPrivilegeType privilegeType, String projectFolderId) {
        return false;
    }

    @Override
    public boolean hasPluginParameterSetPrivilege(Privileges.PluginParameterSetLevelPrivilegeType requiredPluginPresetPrivilege, boolean isDev, String elementType) {
        return false;
    }

    @Override
    public boolean mayManageFeatureStore() {
        return false;
    }

    @Override
    public boolean mayDevelopPlugins() {
        return false;
    }

    @Override
    public boolean mayEditLibFolders() {
        return false;
    }

    @Override
    public boolean mayManageCodeEnvs() {
        return false;
    }

    @Override
    public boolean mayManageClusters() {
        return false;
    }

    @Override
    public boolean mayManageCodeStudioTemplates() {
        return false;
    }

    @Override
    public boolean mayCreateActiveWebContent() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectScopePublicAPIKey)) {
            return false;
        }
        ProjectScopePublicAPIKey that = (ProjectScopePublicAPIKey)((Object)o);
        return this.createdOn == that.createdOn && Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.label, that.label) && Objects.equals(this.description, that.description) && Objects.equals(this.createdBy, that.createdBy) && this.execSQLLike == that.execSQLLike && Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.localDatasets, that.localDatasets) && Objects.equals(this.projectPrivileges, that.projectPrivileges) && Objects.equals(this.onBehalf, that.onBehalf);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.label, this.description, this.createdOn, this.createdBy, this.projectKey, this.execSQLLike, this.localDatasets, this.projectPrivileges, this.onBehalf);
    }

    public static class LocalDatasetPrivilege {
        public List<String> datasets = new ArrayList<String>();
        public List<Privileges.DatasetLevelPrivilegeType> privileges = new ArrayList<Privileges.DatasetLevelPrivilegeType>();

        public LocalDatasetPrivilege() {
        }

        LocalDatasetPrivilege(LocalDatasetPrivilege privilege) {
            this.datasets = new ArrayList<String>(privilege.datasets);
            this.privileges = new ArrayList<Privileges.DatasetLevelPrivilegeType>(privilege.privileges);
        }

        public LocalDatasetPrivilege deepCopy() {
            return new LocalDatasetPrivilege(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalDatasetPrivilege)) {
                return false;
            }
            LocalDatasetPrivilege that = (LocalDatasetPrivilege)o;
            return Objects.equals(this.datasets, that.datasets) && Objects.equals(this.privileges, that.privileges);
        }

        public int hashCode() {
            return Objects.hash(this.datasets, this.privileges);
        }
    }

    public static class KeyList
    extends ArrayList<ProjectScopePublicAPIKey> {
        private static final long serialVersionUID = 1L;
    }
}

