/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.apideployer;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.apideployer.monitoring.ApiEndpointDeploymentActivityAndSystemMetrics;
import com.dataiku.dip.apideployer.monitoring.DeploymentAndEndpoint;
import com.dataiku.dip.apideployer.monitoring.ExternalApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.apideployer.monitoring.ManagedApiEndpointUnifiedMonitoringActivityMetrics;
import com.dataiku.dip.apideployer.monitoring.MetricsAggregation;
import com.dataiku.dip.apideployer.monitoring.ScopeAndEndpoint;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UnifiedMonitoringApiRunAsUserLoginDTO;
import com.dataiku.dip.dao.UnifiedMonitoringBatchIntervalsDTO;
import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfrasService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerCRUDService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerComputationService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerService;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertCRUDService;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertConfig;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertWithRunsInfo;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertingService;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.AbstractMonitoredApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.MonitoredManagedApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.logs.UnifiedMonitoringLogsService;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.settings.UnifiedMonitoringSettingsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/unified-monitoring/deployer"})
public class UnifiedMonitoringDeployerController
extends DIPInternalControllerBase {
    @Autowired
    UnifiedMonitoringDeployerComputationService unifiedMonitoringDeployerComputationService;
    @Autowired
    UnifiedMonitoringDeployerCRUDService unifiedMonitoringDeployerCRUDService;
    @Autowired
    ApiEndpointActivityMonitoringService apiEndpointActivityMonitoringService;
    @Autowired
    APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;
    @Autowired
    UnifiedMonitoringSettingsService unifiedMonitoringSettingsService;
    @Autowired
    UnifiedMonitoringLogsService unifiedMonitoringLogsService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    @Autowired
    UnifiedMonitoringDeployerService unifiedMonitoringDeployerService;
    @Autowired
    ExternalInfrasService externalInfrasService;
    @Autowired
    UnifiedMonitoringAlertingService unifiedMonitoringAlertingService;
    @Autowired
    UnifiedMonitoringAlertCRUDService unifiedMonitoringAlertCRUDService;
    @Autowired
    NodesDirectoryService nodesDirectoryService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.deployerController");

    @AuditedCall(value={"msgType", "unified-monitoring-deployed-projects-list"})
    @RequestMapping(value={"/projects/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AbstractMonitoredProjectDeployment> listMonitoredProjectDeployments(HttpServletRequest req) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringDeployerService.listMonitoredProjectDeployments(user);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-deployed-projects-get"})
    @RequestMapping(value={"/projects/get"}, method={RequestMethod.GET})
    @ResponseBody
    public AbstractMonitoredProjectDeployment getMonitoredProjectDeployment(HttpServletRequest req, @RequestParam String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringDeployerService.getMonitoredProjectDeployment(user, deploymentId);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoints-list"})
    @RequestMapping(value={"/api-endpoints/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AbstractMonitoredApiEndpoint> listMonitoredApiEndpoints(HttpServletRequest req) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringDeployerService.listMonitoredApiEndpoints(user, true);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoints-get"})
    @RequestMapping(value={"/api-endpoints/get"}, method={RequestMethod.GET})
    @ResponseBody
    public MonitoredManagedApiEndpoint getMonitoredManagedApiEndpoint(HttpServletRequest req, String deploymentId, String endpointId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringDeployerService.getMonitoredManagedApiEndpoint(user, deploymentId, endpointId);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-managed-api-endpoint-get-activity-metrics"})
    @RequestMapping(value={"/managed-api-endpoints/activity-metrics"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ManagedApiEndpointUnifiedMonitoringActivityMetrics> getManagedActivityMetrics(HttpServletRequest req, @RequestParam List<DeploymentAndEndpoint> endpoints) throws DKUSecurityException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.apiEndpointActivityMonitoringService.getManagedActivityMetricsCounts_NT(user, endpoints);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoint-deployment-get-activity-and-system-metrics", "deploymentId", "${deploymentId}", "endpointId", "${endpointId}", "period", "${period}", "metricsAggregation", "${metricsAggregation}"})
    @RequestMapping(value={"/endpoint-deployments/activity-and-system-metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ApiEndpointDeploymentActivityAndSystemMetrics> getActivityAndSystemMetrics(HttpServletRequest req, @RequestParam String deploymentId, @RequestParam String endpointId, @RequestParam Period period, @RequestParam MetricsAggregation metricsAggregation) throws IOException, UnauthorizedException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringDeployerService.getApiEndpointDeploymentActivityAndSystemMetrics(user, deploymentId, endpointId, period, metricsAggregation);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoints-get-activity-metrics"})
    @RequestMapping(value={"/external-api-endpoints/activity-metrics"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ExternalApiEndpointUnifiedMonitoringActivityMetrics> getExternalActivityMetrics(HttpServletRequest req, @RequestParam List<ScopeAndEndpoint> endpoints) throws DKUSecurityException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.apiEndpointActivityMonitoringService.getExternalActivityMetricsCounts_NT(user, endpoints);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-settings-update"})
    @RequestMapping(value={"/settings/update"}, method={RequestMethod.POST})
    @ResponseBody
    public void updateSettings(HttpServletRequest req, @RequestParam UnifiedMonitoringSettings newUnifiedMonitoringSettings) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        this.unifiedMonitoringSettingsService.save(user, newUnifiedMonitoringSettings);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-create-alert"})
    @RequestMapping(value={"/alert/create"}, method={RequestMethod.POST})
    @ResponseBody
    public void createAlertConfig(HttpServletRequest req, @RequestParam UnifiedMonitoringAlertConfig alertConfig) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        this.unifiedMonitoringAlertCRUDService.createAlertConfig(user, alertConfig);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-edit-alert"})
    @RequestMapping(value={"/alert/edit"}, method={RequestMethod.POST})
    @ResponseBody
    public void editAlert(HttpServletRequest req, @RequestParam UnifiedMonitoringAlertConfig alertConfig) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        this.unifiedMonitoringAlertCRUDService.editAlertConfig(user, alertConfig);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-alert-list"})
    @RequestMapping(value={"/alert/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UnifiedMonitoringAlertWithRunsInfo> listAlertsWithRunsInfo(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        return this.unifiedMonitoringAlertCRUDService.listAlertsWithRunsInfo();
    }

    @AuditedCall(value={"msgType", "unified-monitoring-alert-remove"})
    @RequestMapping(value={"/alert/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteAlertConfigs(HttpServletRequest req, @RequestParam List<String> alertIds) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        this.unifiedMonitoringAlertCRUDService.deleteAlertConfigs(user, alertIds);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-alert-activate"})
    @RequestMapping(value={"/alert/activate"}, method={RequestMethod.POST})
    @ResponseBody
    public void activateAlerts(HttpServletRequest req, @RequestParam List<String> alertIds, @RequestParam boolean isActive) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        this.unifiedMonitoringAlertCRUDService.activateAlertConfigs(user, alertIds, isActive);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-settings"})
    @RequestMapping(value={"/settings/get"}, method={RequestMethod.GET})
    @ResponseBody
    public UnifiedMonitoringSettings getSettings(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        return this.unifiedMonitoringSettingsService.get();
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-run-as-user-login"})
    @RequestMapping(value={"/settings/api-run-as-user-login"}, method={RequestMethod.GET})
    @ResponseBody
    public UnifiedMonitoringApiRunAsUserLoginDTO getApiRunAsUserLogin(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        String apiRunAsUserLogin = this.unifiedMonitoringSettingsService.get().apiRunAsUserLogin;
        return new UnifiedMonitoringApiRunAsUserLoginDTO(apiRunAsUserLogin);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-batch-intervals"})
    @RequestMapping(value={"/settings/batch-intervals"}, method={RequestMethod.GET})
    @ResponseBody
    public UnifiedMonitoringBatchIntervalsDTO getBatchIntervals(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringSettingsService.getBatchIntervalsDto();
    }

    @AuditedCall(value={"msgType", "unified-monitoring-settings-remote-design-nodes-urls"})
    @RequestMapping(value={"/settings/remote-design-nodes-urls"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, List<String>> getRemoteDesignNodesUrls(HttpServletRequest req) throws Exception {
        HashMap<String, List<String>> response = new HashMap<String, List<String>>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            NodesDirectory nodesDirectory = this.nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
            if (nodesDirectory.enabled) {
                response.put("internalUrls", nodesDirectory.nodes.stream().map(n -> n.url).collect(Collectors.toList()));
                response.put("externalUrls", nodesDirectory.nodes.stream().map(n -> n.externalUrl).collect(Collectors.toList()));
                HashMap<String, List<String>> hashMap = response;
                return hashMap;
            }
            response.put("urls", generalSettings.remoteDesignNodeCreds.stream().map(n -> n.url).collect(Collectors.toList()));
            HashMap<String, List<String>> hashMap = response;
            return hashMap;
        }
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoint-delete"})
    @RequestMapping(value={"/external-api-endpoints/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteMonitoredExternalApiEndpoint(HttpServletRequest req, @RequestParam String externalEndpointsScopeName, @RequestParam String endpointName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
        }
        this.unifiedMonitoringDeployerCRUDService.deleteMonitoredExternalApiEndpoint(externalEndpointsScopeName, endpointName);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoint-list-sagemaker-endpoints", "region", "${region}", "connection", "${connection}"})
    @RequestMapping(value={"/external-api-endpoints/list-sagemaker-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listSageMakerEndpoints(HttpServletRequest req, @RequestParam(required=false) String project, @RequestParam String region, @RequestParam(required=false) String connection) throws Exception {
        DSSAuthCtx umUser;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.getUnsafe();
            umUser = unifiedMonitoringSettings.getAPIRunAsUser();
            if (StringUtils.isNotBlank((CharSequence)unifiedMonitoringSettings.apiRunAsUserLogin)) {
                logger.infoV("Using UM configured user for per-user auth: %s", new Object[]{unifiedMonitoringSettings.apiRunAsUserLogin});
            }
        }
        return this.externalInfrasService.listSageMakerEndpointSummaries(umUser, project, region, connection);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoint-list-azureml-endpoints", "project", "${project}", "workspace", "${workspace}", "resourceGroup", "${resourceGroup}", "subscription", "${subscription}", "connection", "${connection}"})
    @RequestMapping(value={"/external-api-endpoints/list-azureml-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listAzureMLEndpoints(HttpServletRequest req, @RequestParam(required=false) String project, @RequestParam String workspace, @RequestParam String resourceGroup, @RequestParam String subscription, @RequestParam(required=false) String connection) throws Exception {
        DSSAuthCtx umUser;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.getUnsafe();
            umUser = unifiedMonitoringSettings.getAPIRunAsUser();
            if (StringUtils.isNotBlank((CharSequence)unifiedMonitoringSettings.apiRunAsUserLogin)) {
                logger.infoV("Using UM configured user for per-user auth: %s", new Object[]{unifiedMonitoringSettings.apiRunAsUserLogin});
            }
        }
        return this.externalInfrasService.listAzureMLEndpoints(umUser, connection, project, workspace, resourceGroup, subscription);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoint-list-vertexai-endpoints", "project", "${project}", "region", "${region}", "connection", "${connection}"})
    @RequestMapping(value={"/external-api-endpoints/list-vertexai-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listVertexAIEndpoints(HttpServletRequest req, @RequestParam String project, @RequestParam String region, @RequestParam(required=false) String connection) throws Exception {
        DSSAuthCtx umUser;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.getUnsafe();
            umUser = unifiedMonitoringSettings.getAPIRunAsUser();
            if (StringUtils.isNotBlank((CharSequence)unifiedMonitoringSettings.apiRunAsUserLogin)) {
                logger.infoV("Using UM configured user for per-user auth: %s", new Object[]{unifiedMonitoringSettings.apiRunAsUserLogin});
            }
        }
        return this.externalInfrasService.listVertexAIEndpoints(umUser, project, region, connection);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoint-list-databricks-endpoints", "project", "${project}", "connection", "${connectionName}"})
    @RequestMapping(value={"/external-api-endpoints/list-databricks-endpoints"})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listDatabricksEndpoints(HttpServletRequest req, @RequestParam(required=false) String project, @RequestParam String connectionName) throws Exception {
        DSSAuthCtx umUser;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.getUnsafe();
            umUser = unifiedMonitoringSettings.getAPIRunAsUser();
            if (StringUtils.isNotBlank((CharSequence)unifiedMonitoringSettings.apiRunAsUserLogin)) {
                logger.infoV("Using UM configured user for per-user auth: %s", new Object[]{unifiedMonitoringSettings.apiRunAsUserLogin});
            }
        }
        return this.externalInfrasService.listDatabricksEndpoints(umUser, connectionName);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoint-list-snowpark-endpoints", "database", "${database}", "schema", "${schema}", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/external-api-endpoints/list-snowpark-endpoints"}, method={RequestMethod.GET})
    @ResponseBody
    public FutureResponse<List<ExternalInfraEndpoint>> listSnowparkEndpoints(HttpServletRequest req, @RequestParam String database, @RequestParam String schema, @RequestParam String connectionName) throws Exception {
        DSSAuthCtx umUser;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(user);
            UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsDAO.getUnsafe();
            umUser = unifiedMonitoringSettings.getAPIRunAsUser();
            if (StringUtils.isNotBlank((CharSequence)unifiedMonitoringSettings.apiRunAsUserLogin)) {
                logger.infoV("Using UM configured user for per-user auth: %s", new Object[]{unifiedMonitoringSettings.apiRunAsUserLogin});
            }
        }
        return this.externalInfrasService.listSnowparkEndpoints(umUser, connectionName, database, schema);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-managed-api-endpoint-list"})
    @RequestMapping(value={"/managed-api-endpoints/list"}, method={RequestMethod.POST})
    @ResponseBody
    @VisibleForTesting
    public List<MonitoredManagedApiEndpoint> listMonitoredManagedApiEndpoints(HttpServletRequest req) throws Exception {
        List<String> unmonitoredInfrastructures;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            unmonitoredInfrastructures = this.unifiedMonitoringSettingsDAO.read().unmonitoredEndpointInfrastructures;
        }
        List<AbstractDeploymentLightStatus> deployments = this.apiServiceDeploymentsService.listLightStatusUnsafe_NT_Check(user);
        List<String> deploymentIds = deployments.stream().filter(deployment -> !unmonitoredInfrastructures.contains(deployment.deploymentBasicInfo.infraId)).map(AbstractDeploymentLightStatus::getDeploymentBasicInfo).map(AbstractDeploymentBasicInfo::getId).collect(Collectors.toList());
        return this.unifiedMonitoringDeployerCRUDService.listMonitoredManagedApiEndpoints(deploymentIds);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-external-api-endpoints-list"})
    @RequestMapping(value={"/external-api-endpoints/list"}, method={RequestMethod.GET})
    @ResponseBody
    @VisibleForTesting
    public List<MonitoredExternalApiEndpoint> listMonitoredExternalApiEndpoints(HttpServletRequest req, @RequestParam boolean filterOutDeployAnywhereEndpoints) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.unifiedMonitoringDeployerService.listMonitoredExternalApiEndpoints(user, filterOutDeployAnywhereEndpoints);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-deployed-projects-compute"})
    @RequestMapping(value={"/deployed-projects/compute"}, method={RequestMethod.POST})
    @ResponseBody
    @VisibleForTesting
    public void computeMonitoredProjects(HttpServletRequest req) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.unifiedMonitoringDeployerComputationService.computeMonitoredProjects_NT(user, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoints-compute"})
    @RequestMapping(value={"/api-endpoints/compute"}, method={RequestMethod.POST})
    @ResponseBody
    @VisibleForTesting
    public void computeMonitoredManagedApiEndpoints(HttpServletRequest req, @RequestParam String infrastructureId, @RequestParam(required=false) String overridingConnectionName) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.unifiedMonitoringDeployerComputationService.computeMonitoredManagedApiEndpoints_NT(user, infrastructureId, overridingConnectionName);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-get-logs"})
    @RequestMapping(value={"/list-logs-files"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LogsService.LogDesc> listLogsFiles(HttpServletRequest req) throws IOException, UnauthorizedException {
        List<LogsService.LogDesc> log;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            log = this.unifiedMonitoringLogsService.listLogFiles_Check(user);
        }
        return log;
    }

    @AuditedCall(value={"msgType", "unified-monitoring-get-logs"})
    @RequestMapping(value={"/get-logs"}, method={RequestMethod.GET})
    @ResponseBody
    public SmartLogTail getLogs(HttpServletRequest req, @RequestParam String fileName) throws IOException, UnauthorizedException {
        SmartLogTail log;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            log = this.unifiedMonitoringLogsService.getLogs_Check(user, fileName);
        }
        return log;
    }

    @AuditedCall(value={"msgType", "unified-monitoring-download-logs"})
    @RequestMapping(value={"/download-all-logs"}, method={RequestMethod.GET})
    public void downloadAllLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException, UnauthorizedException {
        String dlName = "unified-monitoring-logs.zip";
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.unifiedMonitoringLogsService.downloadAllLogs_Check(user, (OutputStream)resp.getOutputStream());
        }
    }

    @AuditedCall(value={"msgType", "unified-monitoring-download-logs"})
    @RequestMapping(value={"/download-logs"}, method={RequestMethod.GET})
    public void downloadLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fileName) throws IOException, UnauthorizedException {
        String dlName = fileName + ".zip";
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.unifiedMonitoringLogsService.downloadLogs_Check(user, fileName, (OutputStream)resp.getOutputStream());
        }
    }
}

