/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.gh;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class GovernIntegrationController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private GovernIntegrationService governIntegrationService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "govern-integration-test"})
    @RequestMapping(value={"/api/admin/govern-integration-test"})
    public void test(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.permissionsService.checkAdmin(authCtx);
        InfoMessage.InfoMessages infoMessages = this.governIntegrationService.testGovernIntegration();
        GovernIntegrationController.writeJSON((HttpServletResponse)resp, (Object)infoMessages);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/govern-integration-sync"})
    public void sync(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.permissionsService.checkAdmin(authCtx);
            GovernIntegrationController.writeJSON((HttpServletResponse)resp, this.governIntegrationService.checkConcurrentAndFullSync(authCtx, "govern-integration-sync", projectKey));
        }
        catch (Exception e) {
            this.auditTrailService.failure("govern-integration-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/govern-integration-deployer-sync"})
    public void syncDeployer(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.permissionsService.checkAdmin(authCtx);
            GovernIntegrationController.writeJSON((HttpServletResponse)resp, this.governIntegrationService.checkConcurrentAndDeployerFullSync(authCtx));
        }
        catch (Exception e) {
            this.auditTrailService.failure("govern-integration-deployer-sync", (Throwable)e).emit();
            throw e;
        }
    }
}

