/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.runtime.CodeStudioLibsProvider;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.webapps.codestudio.backend.CodeStudioWebAppBackendRunner;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class CodeStudiosIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private CodeStudioRuntimeManager codeStudioRuntimeManager;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.intercom");

    private CodeStudioRuntime getRuntime(String executionId, APITicketService.TicketUsage tu) throws IOException, InterruptedException {
        RemoteRunsRegistry.Execution execution = RemoteRunsRegistry.get(executionId);
        if (execution == null) {
            throw new IllegalArgumentException("Code Studio execution is finished");
        }
        if (!(tu.getTicket().getPayload() instanceof CodeStudioObject)) {
            throw new IllegalArgumentException("Wrong ticket, not assiciated with a Code Studio");
        }
        CodeStudioObject codeStudio = (CodeStudioObject)tu.getTicket().getPayload();
        CodeStudioRuntime runtime = this.codeStudioRuntimeManager.getRuntimeOrNull(tu.getAuthCtx(), codeStudio);
        if (runtime == null) {
            throw new IllegalArgumentException("Unable to find Code Studio runtime handle");
        }
        return runtime;
    }

    private CodeStudioLibsProvider getCodeStudioLibsProvider(String executionId, APITicketService.TicketUsage tu) throws IOException, InterruptedException {
        RemoteRunsRegistry.Execution execution = RemoteRunsRegistry.get(executionId);
        if (execution == null) {
            throw new IllegalArgumentException("Code Studio execution is finished");
        }
        if (tu.getTicket().getPayload() instanceof CodeStudioWebAppBackendRunner) {
            return (CodeStudioWebAppBackendRunner)tu.getTicket().getPayload();
        }
        if (tu.getTicket().getPayload() instanceof CodeStudioObject) {
            CodeStudioObject codeStudio = (CodeStudioObject)tu.getTicket().getPayload();
            CodeStudioRuntime runtime = this.codeStudioRuntimeManager.getRuntimeOrNull(tu.getAuthCtx(), codeStudio);
            if (runtime == null) {
                throw new IllegalArgumentException("Unable to find Code Studio runtime handle");
            }
            return runtime;
        }
        throw new IllegalArgumentException("Wrong ticket, not associated with a Code Studio");
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/code-studios/poll-commands"})
    public void pollCommands(HttpServletRequest req, HttpServletResponse resp, @RequestParam String executionId) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            CodeStudioRuntime runtime = this.getRuntime(executionId, tu);
            CodeStudiosIntercomController.writeJSON((HttpServletResponse)resp, runtime.dequeueCommands());
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/code-studios/answer-command/{executionId}/{no:.+}"})
    public void answerCommand(HttpServletRequest req, HttpServletResponse resp, @PathVariable String executionId, @PathVariable int no) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            CodeStudioRuntime runtime = this.getRuntime(executionId, tu);
            runtime.answerCommand(no, IOUtils.toByteArray((InputStream)req.getInputStream()));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/code-studios/push/{zone:.+}"})
    public void pushData(HttpServletRequest req, HttpServletResponse resp, @PathVariable String zone, @RequestParam String executionId, @RequestParam(required=false, defaultValue="-1") int commandNo, @RequestParam(required=false) String commitId, @RequestParam(value="file") MultipartFile file) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            CodeStudioRuntime runtime = this.getRuntime(executionId, tu);
            try (Transaction t = this.transactionService.beginRead();){
                this.permissionsService.checkProjectPrivileges(tu.getAuthCtx(), runtime.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                tu.getAuthCtx().failIfNoSafeCode("Code Studio");
            }
            CodeStudiosIntercomController.writeJSON((HttpServletResponse)resp, (Object)runtime.setCodeStudioBundle_NT(tu.getAuthCtx(), file, zone, commandNo, commitId));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/code-studios/pull/{zone:.+}"})
    public void pullData(HttpServletRequest req, HttpServletResponse resp, @PathVariable String zone, @RequestParam String executionId, @RequestParam(required=false) String commitId) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            CodeStudioLibsProvider runtime = this.getCodeStudioLibsProvider(executionId, tu);
            try {
                runtime.getCodeStudioBundle_NT(zone, commitId, resp);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to send data", (Throwable)e);
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/code-studios/check-conflicts/{zone}/{executionId}/{no:.+}"})
    public void checkProjectLibConflicts(HttpServletRequest req, HttpServletResponse resp, @PathVariable String zone, @PathVariable String executionId, @PathVariable int no, @RequestParam(required=false) String commitId, @RequestParam GitModel.DiffSummary changes) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            CodeStudioRuntime runtime = this.getRuntime(executionId, tu);
            CodeStudiosIntercomController.writeJSON((HttpServletResponse)resp, (Object)runtime.checkConflicts(zone, commitId, changes));
        }
    }
}

