/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class CodeEnvChangedEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "code-env-changed";
    public final String envName;
    public final ActionType action;
    public final String user;

    public CodeEnvChangedEvent(String envName, ActionType action, String user) {
        this.envName = envName;
        this.action = action;
        this.user = user;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("%s %s code env %s", markup.user(this.user, null), markup.text(this.action.toString().toLowerCase()), markup.text(this.envName));
    }

    public static enum ActionType {
        CREATED,
        DELETED;

    }
}

