/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.AbstractCodeEnvRequestEvent;
import com.dataiku.dip.server.notifications.backend.AbstractRequestEvent;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCodeEnvRequestEmailBuilder<T extends AbstractCodeEnvRequestEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private RequestsService requestsService;
    protected static final Logger logger = Logger.getLogger((String)"dku.notifications.emails.abstractCodeEnvRequestBuilder");

    abstract String makeSubject(CodeEnvModel.EnvLang var1, PublicUser var2, String var3, String var4);

    abstract String makeMainText(CodeEnvModel.EnvLang var1, PublicUser var2);

    abstract String makeTitle(String var1);

    abstract String makeRequestUrl(String var1, String var2, CodeEnvModel.EnvLang var3, String var4);

    private String makeMessage(T evt) throws CodedSQLException {
        String requestId = ((AbstractCodeEnvRequestEvent)evt).getRequestId();
        Request request = this.getRequestById(requestId);
        return request.requestMessage;
    }

    private void setEmailRequestMessage(VariableLookup emailTemplateLookup, String message) {
        if (StringUtils.isNotBlank((String)message)) {
            emailTemplateLookup.addVariable("requestMessage", message);
        }
    }

    private void setEmailRequestUrl(VariableLookup emailTemplateLookup, String requestUrl) {
        emailTemplateLookup.addVariable("codeEnvUrl", requestUrl);
    }

    private void setEmailRequestUrlName(VariableLookup emailTemplateLookup, String requestUrlName) {
        emailTemplateLookup.addVariable("codeEnvUrlName", requestUrlName);
    }

    private void setUserIsAdmin(VariableLookup emailTemplateLookup, boolean isUserAdmin) {
        emailTemplateLookup.addVariable("userIsAdmin", isUserAdmin);
    }

    private void setEmailTitle(VariableLookup emailTemplateLookup, String emailTitle) {
        emailTemplateLookup.addVariable("title", emailTitle);
    }

    private void setEmailMainText(VariableLookup emailTemplateLookup, String emailMainText) {
        emailTemplateLookup.addVariable("mainText", emailMainText);
    }

    private void setVariablesOnLookup(T evt, PublicUser destinationUser, PublicUser requesterUser, String studioExternalUrl, String codeEnvName, String codeEnvTargetName, VariableLookup emailTemplateLookup) throws CodedSQLException {
        this.setEmailDSSExternalUrl(emailTemplateLookup, studioExternalUrl);
        this.setEmailPreferenceLinkUrl(emailTemplateLookup, studioExternalUrl);
        this.setEmailCodeEnvName(emailTemplateLookup, codeEnvName);
        CodeEnvModel.EnvLang codeEnvLanguage = this.getCodeEnvLanguageFromCodeEnvRequestEvent(evt);
        String requestId = ((AbstractCodeEnvRequestEvent)evt).getRequestId();
        boolean isUserAdmin = this.checkIsUserAdmin(destinationUser.login);
        String urlCodeEnvName = !Strings.isNullOrEmpty((String)codeEnvTargetName) ? codeEnvTargetName : codeEnvName;
        String requestUrl = this.makeRequestUrl(requestId, urlCodeEnvName, codeEnvLanguage, studioExternalUrl);
        String emailTitle = this.makeTitle(codeEnvTargetName);
        String emailMainText = this.makeMainText(codeEnvLanguage, requesterUser);
        String requestMessage = this.makeMessage(evt);
        this.setUserIsAdmin(emailTemplateLookup, isUserAdmin);
        this.setEmailRequestUrl(emailTemplateLookup, requestUrl);
        this.setEmailRequestUrlName(emailTemplateLookup, urlCodeEnvName);
        this.setEmailCodeEnvIcon(emailTemplateLookup, codeEnvLanguage);
        this.setEmailTitle(emailTemplateLookup, emailTitle);
        this.setEmailMainText(emailTemplateLookup, emailMainText);
        this.setEmailRequestMessage(emailTemplateLookup, requestMessage);
    }

    private void setEmailCodeEnvName(VariableLookup emailTemplateLookup, String codeEnvName) {
        emailTemplateLookup.addVariable("codeEnvName", codeEnvName);
    }

    private void setEmailPreferenceLinkUrl(VariableLookup emailTemplateLookup, String studioExternalUrl) {
        emailTemplateLookup.addVariable("emailPreferencesLink", studioExternalUrl + "/profile/");
    }

    private void setEmailDSSExternalUrl(VariableLookup emailTemplateLookup, String studioExternalUrl) {
        emailTemplateLookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)studioExternalUrl) ? null : studioExternalUrl);
    }

    private void setEmailCodeEnvIcon(VariableLookup emailTemplateLookup, CodeEnvModel.EnvLang codeEnvLanguage) {
        String defaultFallbackIcon = "bird.png";
        switch (codeEnvLanguage) {
            default: 
        }
        String iconFileName = "bird.png";
        emailTemplateLookup.addVariable("iconPath", iconFileName);
    }

    protected String makeBody(T evt, PublicUser destinationUser, PublicUser requesterUser, String codeEnvName, String codeEnvTargetName) throws IOException, TemplateException, CodedSQLException {
        File emailTemplateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "code-env-request-email.ftl"});
        VariableLookup templateVariableLookup = this.createTemplateVariableLookup(evt, destinationUser, requesterUser, codeEnvName, codeEnvTargetName);
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(templateVariableLookup).buildMessage(new TemplatedContent(), emailTemplateFile);
        return expandedTemplate.message;
    }

    protected void sendToUser(T evt, String destinationUserLogin) throws Exception {
        PublicUser requesterUser;
        PublicUser destinationUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            destinationUser = this.usersService.getPublicUser(destinationUserLogin);
            requesterUser = this.usersService.getPublicUser(((AbstractCodeEnvRequestEvent)evt).getUserLogin());
        }
        CodeEnvModel.EnvLang codeEnvLanguage = this.getCodeEnvLanguageFromCodeEnvRequestEvent(evt);
        String codeEnvRequestName = ((AbstractRequestEvent)evt).getObjectId();
        String codeEnvTargetName = this.getCodeEnvTargetName(evt);
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 " + this.makeSubject(codeEnvLanguage, requesterUser, codeEnvRequestName, codeEnvTargetName);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        logger.info((Object)("Sending email to " + destinationUser.login));
        sender.sendToUser(destinationUser.email, params, this.makeBody(evt, destinationUser, requesterUser, codeEnvRequestName, codeEnvTargetName));
    }

    abstract String getCodeEnvTargetName(T var1);

    protected VariableLookup createTemplateVariableLookup(T evt, PublicUser destinationUser, PublicUser requesterUser, String codeEnvName, String codeEnvTargetName) throws IOException, CodedSQLException {
        String studioExternalUrl;
        try (Transaction ignored = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            studioExternalUrl = settings.studioExternalUrl;
        }
        VariableLookup templateVariableLookup = new VariableLookup();
        this.setVariablesOnLookup(evt, destinationUser, requesterUser, studioExternalUrl, codeEnvName, codeEnvTargetName, templateVariableLookup);
        return templateVariableLookup;
    }

    private CodeEnvModel.EnvLang getCodeEnvLanguageFromCodeEnvRequestEvent(T evt) throws CodedSQLException {
        Request request = this.getRequestById(((AbstractCodeEnvRequestEvent)evt).getRequestId());
        return ((Request.CodeEnvRequestDetails)request.requestDetails).envLang;
    }

    private boolean checkIsUserAdmin(String user) {
        boolean isUserAdmin;
        try (Transaction ignored = this.transactionService.beginRead();){
            isUserAdmin = this.usersService.isAdmin(user);
        }
        catch (IOException exception) {
            logger.error((Object)("Could not verify whether user " + user + " is admin or not"), (Throwable)exception);
            throw new IllegalArgumentException("Could not verify the admin status of user " + user);
        }
        return isUserAdmin;
    }

    private Request getRequestById(String requestID) throws CodedSQLException {
        Request request = this.requestsService.getRequestOrNull(requestID);
        if (request == null) {
            throw new IllegalArgumentException("Could not find request with ID " + requestID);
        }
        return request;
    }
}

