/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ATSurveyService {
    public static final int SURVEY_SHORT_DELAY = 10;
    public static final int SURVEY_LONG_DELAY = 90;

    public static long getNextSurveyInstant() {
        return ATSurveyService.getNextSurveyInstant(System.currentTimeMillis());
    }

    public ATSurveySettings getNextSettingsAfterNPSSurvey(ATSurveySettings atSurveySettings) {
        if (atSurveySettings == null) {
            atSurveySettings = new ATSurveySettings();
        }
        atSurveySettings.nextAction = Math.max(atSurveySettings.nextAction, ATSurveyService.getNextSurveyInstant());
        return atSurveySettings;
    }

    public ATSurveySettings getNextSettings(ATSurveySettings atSurveySettings, ATSurveyAction action, String event) {
        if (atSurveySettings.state == ATSurveyState.OPTOUT) {
            atSurveySettings.nextAction = Long.MAX_VALUE;
            return atSurveySettings;
        }
        long now = System.currentTimeMillis();
        switch (action) {
            case OPTOUT: {
                atSurveySettings.surveys.put(event, new ATSurveyOccurrence(ATSurveyService.getNextSameSurveyInstant(now)));
                atSurveySettings.nextAction = Long.MAX_VALUE;
                atSurveySettings.state = ATSurveyState.OPTOUT;
                break;
            }
            case SUBMIT: {
                atSurveySettings.surveys.put(event, new ATSurveyOccurrence(ATSurveyService.getNextSameSurveyInstant(now)));
                atSurveySettings.nextAction = ATSurveyService.getNextSurveyInstant(now);
                break;
            }
            default: {
                atSurveySettings.surveys.put(event, new ATSurveyOccurrence(ATSurveyService.getNextSurveyInstant(now)));
                atSurveySettings.nextAction = ATSurveyService.getNextSurveyInstant(now);
            }
        }
        return atSurveySettings;
    }

    private static long getNextSurveyInstant(long now) {
        return new DateTime(now).plusDays(10).getMillis();
    }

    private static long getNextSameSurveyInstant(long now) {
        return new DateTime(now).plusDays(90).getMillis();
    }

    public static class ATSurveySettings {
        public ATSurveyState state = ATSurveyState.INITIAL;
        public Map<String, ATSurveyOccurrence> surveys = new HashMap<String, ATSurveyOccurrence>();
        public long nextAction;
    }

    public static enum ATSurveyState {
        INITIAL,
        OPTOUT;

    }

    public static enum ATSurveyAction {
        SUBMIT,
        POSTPONE,
        OPTOUT;

    }

    public static class ATSurveyOccurrence {
        public long nextAction;

        public ATSurveyOccurrence(long nextAction) {
            this.nextAction = nextAction;
        }
    }
}

