/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.internal;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.datacatalog.UIDataCatalog;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.catalog.LuceneIndexException;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface IInternalDataCatalogService {
    public static final int MAX_RESULTS = ApplicationConfigurator.getParams().getIntParam("dku.catalog.maxResults", Integer.valueOf(100));

    public LuceneResponseWrapper search(String var1, Map<String, List<String>> var2, AuthCtx var3, Options var4) throws LuceneIndexException, ParseException, IOException, DKUSecurityException;

    public LuceneResponseWrapper searchInternal(String var1, Map<String, List<String>> var2, AuthCtx var3, Options var4) throws LuceneIndexException, ParseException, IOException, DKUSecurityException;

    public LuceneResponseWrapper searchInternal(String var1, Map<String, List<String>> var2, AuthCtx var3, Options var4, Query var5) throws LuceneIndexException, ParseException, IOException, DKUSecurityException;

    public LuceneResponseWrapper searchDataset(String var1, Map<String, List<String>> var2, AuthCtx var3, Options var4, Query var5) throws LuceneIndexException, ParseException, IOException, DKUSecurityException;

    public LuceneResponseWrapper.Hit getDatasetById(String var1, String var2) throws IOException, LuceneIndexException, NoSuchElementException;

    public Pair<List<DataCollection>, Integer> getDataCollectionsOfDataset(AuthCtx var1, String var2, String var3) throws LuceneIndexException, IOException;

    public List<DataCollection> searchDataCollections(AuthCtx var1, String var2) throws LuceneIndexException, IOException, ParseException;

    public LuceneResponseWrapper searchMeaning(String var1, Map<String, List<String>> var2, AuthCtx var3, boolean var4, @Nullable String var5) throws LuceneIndexException, ParseException, IOException;

    public LuceneResponseWrapper columnsWithMeaning(String var1, AuthCtx var2) throws IOException, DKUSecurityException;

    public LuceneResponseWrapper searchColumn(String var1, Map<String, List<String>> var2, AuthCtx var3, @Nullable String var4) throws LuceneIndexException, ParseException, IOException, DKUSecurityException;

    public LuceneResponseWrapper searchColumn(String var1, Map<String, List<String>> var2, AuthCtx var3, Options var4, Query var5) throws LuceneIndexException, ParseException, IOException, DKUSecurityException;

    public UIDataCatalog.AbstractDatasetDetails getReadableDatasetItemDetails_NT(AuthCtx var1, String var2, String var3) throws Exception;

    public UIDataCatalog.DiscoverableDatasetDetails getDiscoverableDatasetItemDetails_NT(AuthCtx var1, String var2, String var3) throws Exception;

    public LuceneResponseWrapper getListedNonEmptyDashboards(AuthCtx var1) throws IOException, LuceneIndexException, DKUSecurityException;

    public String searchResultPostTreatment(AuthCtx var1, Iterable<LuceneResponseWrapper.Hit> var2, String var3, Function<JsonObject, JsonArray> var4) throws DKUSecurityException, IOException;

    public void flush() throws Exception;

    public static class IndexedObjectFields {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String SHORT_DESC = "shortDesc";
        public static final String TAG = "tag";
        public static final String PROJECT_KEY = "projectKey";
        public static final String PROJECT_NAME = "projectName";
        public static final String WORKSPACE_KEY = "workspaceKey";
        public static final String WORKSPACE_NAME = "workspaceName";
        public static final String CREATED_BY = "createdBy";
        public static final String CREATED_ON = "createdOn";
        public static final String LAST_MODIFIED_ON = "lastModifiedOn";
        public static final String LAST_MODIFIED_BY = "lastModifiedBy";
        public static final String OWNER = "owner";
        public static final String LIMITED_VISIBILITY_ENABLED = "limitedVisibilityEnabled";
        public static final String NUM_DATASETS = "numDatasets";
        public static final String NUM_RECIPES = "numRecipes";
        public static final String NUM_MANAGED_FOLDERS = "numManagedFolders";
        public static final String NUM_SCENARIOS = "numScenarios";
        public static final String NUM_MODELS = "numModels";
        public static final String NUM_NOTEBOOKS = "numNotebooks";
        public static final String NUM_ANALYSES = "numAnalyses";
        public static final String NUM_DASHBOARDS = "numDashboards";
        public static final String NUM_INSIGHTS = "numInsights";
        public static final String NUM_WEB_APPS = "numWebApps";
        public static final String NUM_CODE_STUDIOS = "numCodeStudios";
        public static final String NUM_REPORTS = "numReports";
        public static final String NUM_TASKS = "numTasks";
        public static final String NUM_WIKI_ARTICLES = "numWikiArticles";
        public static final String NUM_STATISTICS_WORKSHEETS = "numStatisticsWorksheets";
        public static final String NUM_FLOW_ZONES = "numFlowZones";
        public static final String NUM_LABELING_TASKS = "numLabelingTasks";
        public static final String NUM_KNOWLEDGE_BANKS = "numKnowledgeBanks";
        public static final String NUM_PROMPT_STUDIOS = "numPromptStudios";
        public static final String DATA_STEWARD = "dataSteward";
        public static final String DATA_COLLECTION = "dataCollection";
        public static final String IS_IN_DATA_COLLECTION = "isInDataCollection";
        public static final String NUM_DATA_COLLECTIONS = "numDataCollections";
        public static final String USER = "user";
        public static final String TYPE = "type";
        public static final String AUTHORIZED_MEMBERS = "authorized_members";
        public static final String AUTHORIZED_DASHBOARD_GROUPS = "authorized_dashboard_groups";
        public static final String AUTHORIZED_DASHBOARD_USERS = "authorized_dashboard_users";
        public static final String AUTHORIZED_DISCUSSION_GROUPS = "authorized_discussion_groups";
        public static final String AUTHORIZED_DISCUSSION_USERS = "authorized_discussion_users";
    }

    public static class Options {
        private int maxSize;
        private boolean highlightDisabled;
        private boolean needsAggregation;
        private boolean accurateTotalHits;
        private String explainDocId;
        private String explainDocType;

        public Options(int maxSize, boolean highlightDisabled, boolean needsAggregation, boolean accurateTotalHits) {
            this.maxSize = maxSize;
            this.highlightDisabled = highlightDisabled;
            this.needsAggregation = needsAggregation;
            this.accurateTotalHits = accurateTotalHits;
        }

        public static Options getDefaultOptions() {
            return new Options(MAX_RESULTS, false, true, false);
        }

        public Options withAggregations(boolean needsAggregation) {
            this.needsAggregation = needsAggregation;
            return this;
        }

        public Options withAccurateTotalHits(boolean accurateTotalHits) {
            this.accurateTotalHits = accurateTotalHits;
            return this;
        }

        public Options withMaxSize(int maxSize) {
            if (maxSize > 0 && maxSize <= MAX_RESULTS) {
                this.maxSize = maxSize;
            }
            return this;
        }

        public Options withExplainDocId(String explainDocId) {
            this.explainDocId = explainDocId;
            return this;
        }

        public Options withExplainDocType(String explainDocType) {
            this.explainDocType = explainDocType;
            return this;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public boolean needsAggregation() {
            return this.needsAggregation;
        }

        public boolean needsAccurateTotalHits() {
            return this.accurateTotalHits;
        }

        public boolean isHighlightDisabled() {
            return this.highlightDisabled;
        }

        public String getExplainDocId() {
            return this.explainDocId;
        }

        public String getExplainDocType() {
            return this.explainDocType;
        }
    }
}

