/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.facet.BoundingBoxFaceter;
import com.dataiku.dip.shaker.filter.AlphanumFaceter;
import com.dataiku.dip.shaker.filter.AlphanumValueFilter;
import com.dataiku.dip.shaker.filter.BoundingBoxValueFilter;
import com.dataiku.dip.shaker.filter.DateFaceter;
import com.dataiku.dip.shaker.filter.DateNonRangeFilter;
import com.dataiku.dip.shaker.filter.DateRangeFilter;
import com.dataiku.dip.shaker.filter.DateRelativeFilter;
import com.dataiku.dip.shaker.filter.DisplayFilter;
import com.dataiku.dip.shaker.filter.ExplicitExcludeFilter;
import com.dataiku.dip.shaker.filter.Faceter;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.filter.GlobalSearchFilter;
import com.dataiku.dip.shaker.filter.NumericAsAlphanumericValueFilter;
import com.dataiku.dip.shaker.filter.NumericalFaceter;
import com.dataiku.dip.shaker.filter.NumericalRangeFilter;
import com.dataiku.dip.shaker.filter.ValidityFaceter;
import com.dataiku.dip.shaker.filter.ValidityFilter;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilteringExecutor {
    List<Faceter> faceters = new ArrayList<Faceter>();
    List<DisplayFilter> filterExecutors = new ArrayList<DisplayFilter>();
    List<Boolean> globalFilters = new ArrayList<Boolean>();
    boolean[] filterResult;
    List<FilterFacet> facets = new ArrayList<FilterFacet>();

    public FilteringExecutor(FilterRequest filterRequest) throws Exception {
        for (FilterRequest.FilterElement elt : filterRequest.elements) {
            DisplayFilter filterExecutor = null;
            Faceter faceter = null;
            boolean exclude = elt.selectedValues == null && elt.excludedValues != null;
            switch (elt.type) {
                case ALPHANUM: {
                    if (!elt.isEffective()) break;
                    StringMatchingMode mode = StringMatchingMode.forName(elt.getParam("mode", StringMatchingMode.FULL_STRING.toString()));
                    StringNormalizationMode normalizationMode = StringNormalizationMode.forName(elt.getParam("normalization", StringNormalizationMode.EXACT.toString()));
                    String decimalPlaces = elt.getParam("decimalPlaces", null);
                    filterExecutor = new AlphanumValueFilter(elt.column, elt.selectedValues != null ? elt.selectedValues : elt.excludedValues, exclude, mode, normalizationMode, decimalPlaces != null ? Integer.valueOf(decimalPlaces) : null);
                    break;
                }
                case ALPHANUM_FACET: {
                    if (elt.isEffective()) {
                        filterExecutor = elt.isAGlobalFilter && elt.columnType == AxisDef.Type.NUMERICAL ? new NumericAsAlphanumericValueFilter(elt.column, elt.selectedValues != null ? elt.selectedValues : elt.excludedValues, exclude) : new AlphanumValueFilter(elt.column, elt.selectedValues != null ? elt.selectedValues : elt.excludedValues, exclude, StringMatchingMode.FULL_STRING, StringNormalizationMode.EXACT);
                    }
                    faceter = new AlphanumFaceter(elt.column, AlphanumFaceter.Sort.COUNT, DKUApp.getParams().getIntParam("dku.filtering.alphanumFacetsThreshold", Integer.valueOf(500)));
                    break;
                }
                case NUMERICAL_FACET: {
                    if (elt.isEffective()) {
                        filterExecutor = new NumericalRangeFilter(elt.column, elt.minValue, elt.maxValue, elt.includeEmptyValues);
                    }
                    faceter = new NumericalFaceter(elt.column);
                    break;
                }
                case EXPLICIT_FACET: {
                    if (!elt.isEffective()) break;
                    if (elt.explicitExclude) {
                        filterExecutor = new ExplicitExcludeFilter(elt.explicitConditions);
                        break;
                    }
                    throw new NotImplementedException();
                }
                case BOUNDING_BOX_FACET: {
                    if (elt.isEffective()) {
                        filterExecutor = new BoundingBoxValueFilter(elt.column, elt.selectedValues);
                    }
                    faceter = new BoundingBoxFaceter(elt.column, DKUApp.getParams().getIntParam("dku.filtering.boundingBoxFacetsThreshold", Integer.valueOf(50)));
                    break;
                }
                case DATE_FACET: {
                    if (elt.isEffective()) {
                        filterExecutor = elt.dateFilterType == ChartFilter.DateFilterType.RANGE ? new DateRangeFilter(elt.column, elt.minValue, elt.maxValue, elt.includeEmptyValues) : (elt.dateFilterType == ChartFilter.DateFilterType.RELATIVE ? new DateRelativeFilter(elt.column, elt.dateFilterPart, elt.dateFilterOption, elt.includeEmptyValues) : new DateNonRangeFilter(elt.column, elt.dateFilterPart, Sets.newHashSet((Object[])(elt.selectedValues != null ? elt.selectedValues : elt.excludedValues)), exclude));
                    }
                    faceter = new DateFaceter(elt.column, elt.dateFilterType, elt.dateFilterPart);
                    break;
                }
                case GLOBAL_SEARCH: {
                    if (!elt.isEffective()) break;
                    filterExecutor = new GlobalSearchFilter((elt.selectedValues != null ? elt.selectedValues : elt.excludedValues)[0], StringMatchingMode.SUBSTRING, StringNormalizationMode.LOWERCASE);
                    break;
                }
                case VALIDITY: {
                    boolean ok = elt.getBooleanParam("ok", true);
                    boolean nok = elt.getBooleanParam("nok", true);
                    boolean empty = elt.getBooleanParam("empty", true);
                    IBasicMeaningsService meaningsService = (IBasicMeaningsService)SpringUtils.getBean(IBasicMeaningsService.class);
                    ValidityFilter validiyFilterExecutor = new ValidityFilter(elt.column, meaningsService.buildSingleDetector(elt.getParam("type", null)), ok, nok, empty);
                    faceter = new ValidityFaceter(elt.column, validiyFilterExecutor);
                    if (!elt.active) break;
                    filterExecutor = validiyFilterExecutor;
                }
            }
            this.globalFilters.add(elt.isAGlobalFilter);
            this.filterExecutors.add(filterExecutor);
            this.faceters.add(faceter);
        }
    }

    public void execute(MemTable table) throws InterruptedException {
        for (int i = 0; i < this.faceters.size(); ++i) {
            if (this.faceters.get(i) == null) continue;
            Object filtersI = new boolean[table.nrows()];
            Arrays.fill((boolean[])filtersI, true);
            for (int k = 0; k < this.filterExecutors.size(); ++k) {
                if (k == i || this.filterExecutors.get(k) == null) continue;
                this.filterExecutors.get(k).filter(table, (boolean[])filtersI);
            }
            this.faceters.get(i).observe(table, (boolean[])filtersI);
            FilterFacet facet = this.faceters.get(i).compute();
            facet.isAGlobalFilter = i < this.globalFilters.size() && this.globalFilters.get(i) != false;
            this.facets.add(facet);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        boolean hasAtLeastOneFilter = false;
        for (DisplayFilter filterExecutor : this.filterExecutors) {
            hasAtLeastOneFilter |= filterExecutor != null;
        }
        if (hasAtLeastOneFilter) {
            this.filterResult = new boolean[table.nrows()];
            Arrays.fill(this.filterResult, true);
            int beforeFilterCounts = this.filterResult.length;
            for (int i = 0; i < this.filterExecutors.size(); ++i) {
                if (this.filterExecutors.get(i) != null) {
                    this.filterExecutors.get(i).filter(table, this.filterResult);
                    if (i < this.facets.size()) {
                        int afterFilterCounts = FilteringExecutor.countTrue(this.filterResult);
                        this.facets.get((int)i).filteredRecords = beforeFilterCounts - afterFilterCounts;
                        beforeFilterCounts = afterFilterCounts;
                    }
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
    }

    public static int countTrue(boolean[] array) {
        int ret = 0;
        for (boolean b : array) {
            if (!b) continue;
            ++ret;
        }
        return ret;
    }

    public boolean[] getFilterResult() {
        return this.filterResult;
    }

    public List<FilterFacet> getFaceting() {
        return this.facets;
    }
}

