/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opengis.referencing.FactoryException;

public class EnrichWithRecordContextProcessor {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "EnrichWithRecordContextProcessor";
        }

        @Override
        public String getDocPage() {
            return "enrich-with-record-context";
        }

        @Override
        public Category getCategory() {
            return Category.MISC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.HELP", "Add columns containing information about the current record, when available. This processor is used on partitioned or file-based datasets.\n\n# Options\n\nAdd a column name to create any of the following:\n- **Output partition column:** Create new column with source partition (for partitioned input datasets)\n- **Output partition chunks columns prefix:** Create new column with source partition dimension values (for partitioned input datasets)\n- **Output file path column:** Create column with file path (for file-based datasets)\n- **Output filename column:** Create column with file name (for file-based datasets)\n- **Output file record column:** Create column with record id in file (for file-based datasets)\n- **Output last modified column:** Create column with file last modification timestamp (for file-based datasets)\n\n<u>*Warning*</u>: This processor can only work in the \u201cDSS\u201d engine. It is not compatible with the Spark and SQL engines.\n\n<u>*Note*</u>: This processor will not output any valid data when designing the preparation. The data will only populate when the Prepare recipe runs.\n\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public Object selfReport(Parameter param) {
            return new JsonObject();
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.NO_SPARK_IMPL);
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION", 1.actionVerb("Enrich") + " record with context information")).withParam("partitionOutputColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION.OUTPUT_PARTITION_COLUMN", "Output partition column")).withParam("partitionChunksOutputColumnsPrefix", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION.OUTPUT_PARTITION_CHUNKS", "Output partition chunks columns prefix")).withParam("filepathOutputColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION.OUTPUT_FILEPATH_COLUMN", "Output file path column")).withParam("filenameOutputColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION.OUTPUT_FILENAME_COLUMN", "Output filename column")).withParam("fileRecordOutputColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION.OUTPUT_FILE_RECORD_COLUMN", "Output file record column")).withParam("lastModifiedOutputColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithRecordContextProcessor.DESCRIPTION.OUTPUT_LAST_MODIFIED_COLUMN", "Output last modified time column"));
        }

        @Override
        public StreamImpl build(Parameter parameter) throws Exception {
            return new StreamImpl(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter enrichParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.partitionOutputColumn);
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.filepathOutputColumn);
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.filenameOutputColumn);
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.fileRecordOutputColumn);
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.lastModifiedOutputColumn);
                if (StringUtils.isNotBlank((String)enrichParams.partitionChunksOutputColumnsPrefix)) {
                    updatedRecipeLineage.setUncertain(true);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter parameter;
        private Column partitionOutputCD;
        private Column filepathOutputCD;
        private Column filenameOutputCD;
        private Column fileRecordOutputCD;
        private Column fileModifiedOutputCD;

        public StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        public void init() throws FactoryException {
            if (StringUtils.isNotBlank((String)this.parameter.filepathOutputColumn)) {
                this.filepathOutputCD = this.cf.column(this.parameter.filepathOutputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (StringUtils.isNotBlank((String)this.parameter.filenameOutputColumn)) {
                this.filenameOutputCD = this.cf.column(this.parameter.filenameOutputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (StringUtils.isNotBlank((String)this.parameter.fileRecordOutputColumn)) {
                this.fileRecordOutputCD = this.cf.column(this.parameter.fileRecordOutputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (StringUtils.isNotBlank((String)this.parameter.lastModifiedOutputColumn)) {
                this.fileModifiedOutputCD = this.cf.column(this.parameter.lastModifiedOutputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (StringUtils.isNotBlank((String)this.parameter.partitionOutputColumn)) {
                this.partitionOutputCD = this.cf.column(this.parameter.partitionOutputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
        }

        public void processRow(Row row) throws Exception {
            block15: {
                Partition p;
                block14: {
                    PartitioningScheme ps2;
                    if (!(row instanceof MemRow)) break block14;
                    if (this.filepathOutputCD != null) {
                        row.put(this.filepathOutputCD, "This column will only be valued when running a Prepare recipe");
                    }
                    if (this.filenameOutputCD != null) {
                        row.put(this.filenameOutputCD, "This column will only be valued when running a Prepare recipe");
                    }
                    if (this.fileRecordOutputCD != null) {
                        row.put(this.fileRecordOutputCD, 1);
                    }
                    if (this.fileModifiedOutputCD != null) {
                        DateTime defaultDt = new DateTime(0L);
                        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                        row.put(this.fileModifiedOutputCD, fmt.print((ReadableInstant)defaultDt));
                    }
                    if (this.partitionOutputCD != null) {
                        row.put(this.partitionOutputCD, "This column will only be valued when running a Prepare recipe");
                    }
                    if (!StringUtils.isNotBlank((String)this.parameter.partitionChunksOutputColumnsPrefix) || (ps2 = row.getRowContext().sourcePartitioningScheme) == null) break block15;
                    for (String dimensionName : ps2.getDimensionNames()) {
                        Column c2 = this.cf.column(this.parameter.partitionChunksOutputColumnsPrefix + dimensionName, Processor.ProcessorRole.OUTPUT_COLUMN);
                        row.put(c2, "This column will only be valued when running a Prepare recipe");
                    }
                    break block15;
                }
                if (row.getRowContext().sourceFilepath != null && this.filepathOutputCD != null) {
                    row.put(this.filepathOutputCD, row.getRowContext().sourceFilepath);
                }
                if (row.getRowContext().sourceFilename != null && this.filenameOutputCD != null) {
                    row.put(this.filenameOutputCD, row.getRowContext().sourceFilename);
                }
                if (row.getRowContext().sourceRecord >= 0L && this.fileRecordOutputCD != null) {
                    row.put(this.fileRecordOutputCD, row.getRowContext().sourceRecord);
                }
                if (this.fileModifiedOutputCD != null && row.getRowContext().sourceLastModifiedSupplier != null && row.getRowContext().sourceLastModifiedSupplier.getAsLong() >= 0L) {
                    DateTime dt = new DateTime(row.getRowContext().sourceLastModifiedSupplier.getAsLong());
                    DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                    row.put(this.fileModifiedOutputCD, fmt.print((ReadableInstant)dt));
                }
                if ((p = row.getRowContext().sourcePartition) != null) {
                    if (this.partitionOutputCD != null) {
                        row.put(this.partitionOutputCD, p.id());
                    }
                    if (StringUtils.isNotBlank((String)this.parameter.partitionChunksOutputColumnsPrefix)) {
                        for (Map.Entry dve : p.getDimensionValues().entrySet()) {
                            Column c3 = this.cf.column(this.parameter.partitionChunksOutputColumnsPrefix + (String)dve.getKey(), Processor.ProcessorRole.OUTPUT_COLUMN);
                            row.put(c3, ((DimensionValue)dve.getValue()).id());
                        }
                    }
                }
            }
        }

        public void postProcess() {
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String partitionOutputColumn;
        public String partitionChunksOutputColumnsPrefix;
        public String filepathOutputColumn;
        public String filenameOutputColumn;
        public String fileRecordOutputColumn;
        public String lastModifiedOutputColumn;

        public void validate() throws IllegalArgumentException {
        }
    }
}

