/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.expressions.GrokExpression;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class GrokProcessor {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "GrokProcessor";
        }

        @Override
        public String getDocPage() {
            return "grok";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM, ProcessorTag.STRING, ProcessorTag.SPLIT});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GrokProcessor.HELP", "This processor computes new columns using grok expressions");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GrokProcessor.DESCRIPTION", 1.actionVerb("Extract") + " with Grok expression"), false).withMNEColParam("sourceColumn", this.translate(language, "SHAKER.PROCESSOR.GrokProcessor.DESCRIPTION.SOURCE_COLUMN", "Column")).withMNESParam("grokPattern", this.translate(language, "SHAKER.PROCESSOR.GrokProcessor.DESCRIPTION.GROK_PATTERN", "Grok Expression")).withBool("found_col", this.translate(language, "SHAKER.PROCESSOR.GrokProcessor.DESCRIPTION.FOUND_COL", "Create a special 'found' column")).withParam("found_col_name", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.GrokProcessor.DESCRIPTION.FOUND_COL_NAME", "Name of the found column"), "found");
        }

        @Override
        public StreamImpl build(Parameter param) {
            return new StreamImpl(param);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            GrokExpression grokExpr;
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter grokParam = (Parameter)pss.params;
            try {
                grokExpr = new GrokExpression(grokParam.grokPattern);
            }
            catch (IllegalArgumentException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_DATA_LINEAGE_FAILED, "Prepare Grok processor: Failed to parse grok pattern");
            }
            ArrayList outputColumns = new ArrayList();
            grokExpr.getVariables().forEach(variable -> {
                if ("UNWANTED".equals(variable)) {
                    return;
                }
                outputColumns.add(variable);
            });
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                for (String column : outputColumns) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(grokParam.sourceColumn, column);
                }
                if (grokParam.found_col) {
                    String foundColName = StringUtils.isNotBlank((String)grokParam.found_col_name) ? grokParam.found_col_name : "found";
                    updatedDatasetPairLineage.removeRelationsOnColumn(foundColName);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(grokParam.sourceColumn, foundColName);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.procesor.grok");

    static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter parameter;
        private GrokExpression grokExpr;
        private Map<String, Column> targetColumnDefinition;
        private Column foundCol;

        StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        public void init() throws Exception {
            this.targetColumnDefinition = new HashMap<String, Column>();
            ColumnFactory columnFactory = this.getColumnFactory();
            if (this.parameter.grokPattern == null || this.parameter.grokPattern.isEmpty()) {
                return;
            }
            try {
                this.grokExpr = new GrokExpression(this.parameter.grokPattern);
            }
            catch (IllegalArgumentException e) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, e.getMessage());
            }
            this.grokExpr.getVariables().forEach(v -> {
                if ("UNWANTED".equals(v)) {
                    return;
                }
                Column newColumn = columnFactory.column(v, Processor.ProcessorRole.OUTPUT_COLUMN);
                this.targetColumnDefinition.put(newColumn.getName(), newColumn);
            });
            if (this.parameter.found_col) {
                this.foundCol = columnFactory.column(this.parameter.found_col_name, Processor.ProcessorRole.OUTPUT_COLUMN);
                this.targetColumnDefinition.put(this.foundCol.getName(), this.foundCol);
            }
        }

        public void processRow(Row row) throws Exception {
            if (this.grokExpr == null) {
                return;
            }
            String log = row.get(this.cf.column(this.parameter.sourceColumn));
            Map<String, Object> out = this.grokExpr.capture(log);
            if (out != null) {
                for (Map.Entry<String, Object> entry : out.entrySet()) {
                    String entryKey = entry.getKey();
                    Column foundTargetColumn = this.targetColumnDefinition.get(entryKey);
                    if (foundTargetColumn == null) continue;
                    row.put(foundTargetColumn, entry.getValue().toString());
                }
            }
            if (this.foundCol != null) {
                row.put(this.foundCol, this.grokExpr.grok.match((CharSequence)log).isNull() == false);
            }
        }

        public void postProcess() throws Exception {
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = 1L;
        public String sourceColumn;
        public String grokPattern;
        public boolean found_col;
        public String found_col_name;
        private static final String FOUND_COL_NAME_DEFAULT = "found";

        public void validate() throws IllegalArgumentException {
            this.found_col_name = this.found_col_name == null || this.found_col_name.isEmpty() ? FOUND_COL_NAME_DEFAULT : this.found_col_name;
        }
    }
}

