/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class GeometryInfoExtractor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<GeometryInfoExtractor, Parameter> META = new ProcessorMeta<GeometryInfoExtractor, Parameter>(){

        @Override
        public String getName() {
            return "GeometryInfoExtractor";
        }

        @Override
        public String getDocPage() {
            return "geo-info-extractor";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC, ProcessorTag.ENRICH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GeometryInfoExtractor.HELP", "This processor extracts data from a geometry column.\n\nExtracts:\n\n* Centroid point\n* Length (if input is not a point)\n* Area (if input is a polygon)\n\nWarning: Length and area are expressed in the unit of the CRS, so often in degrees instead of meters.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GeometryInfoExtractor.DESCRIPTION", 1.actionVerb("Extract") + " from geo column")).withMNEColParam("inputCol", this.translate(language, "SHAKER.PROCESSOR.GeometryInfoExtractor.DESCRIPTION.INPUT_COL", "Input Column")).withParam("centroidCol", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.GeometryInfoExtractor.DESCRIPTION.CENTROID_COL", "Centroid output column")).withParam("lengthCol", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.GeometryInfoExtractor.DESCRIPTION.LENGTH_COL", "Length output column")).withParam("areaCol", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.GeometryInfoExtractor.DESCRIPTION.AREA_COL", "Area output column"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (dialect instanceof PostgreSQLDialect || dialect instanceof SnowflakeSQLDialect) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            } else {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use the selected SQL engine, only PostgreSQL with PostGIS support enabled and Snowflake can be used");
            }
            return ret;
        }

        @Override
        public GeometryInfoExtractor build(Parameter parameter) throws Exception {
            return new GeometryInfoExtractor(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter extractorParams = (Parameter)pss.params;
            if (StringUtils.isBlank((String)extractorParams.inputCol)) {
                throw new IllegalConfigurationException("Missing input column information for lineage on the geometry info extractor processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Stream.of(extractorParams.centroidCol, extractorParams.lengthCol, extractorParams.areaCol).filter(StringUtils::isNotBlank).forEach(col -> {
                    if (!Objects.equals(extractorParams.inputCol, col)) {
                        updatedDatasetPairLineage.removeRelationsOnColumn((String)col);
                        updatedDatasetPairLineage.addFactorizedColumnRelations(extractorParams.inputCol, (String)col);
                    }
                });
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    final Parameter parameter;
    Column inputCD;
    Column centroidCD;
    Column lengthCD;
    Column areaCD;
    GeometryFactory factory = new GeometryFactory();
    GeometryMeaning geomMeaning = new GeometryMeaning();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker");

    public GeometryInfoExtractor(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.inputCD = this.getColumnFactory().column(this.parameter.inputCol, Processor.ProcessorRole.INPUT_COLUMN);
        if (!StringUtils.isBlank((String)this.parameter.areaCol)) {
            this.areaCD = this.getColumnFactory().columnAfter(this.parameter.inputCol, this.parameter.areaCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
        if (!StringUtils.isBlank((String)this.parameter.lengthCol)) {
            this.lengthCD = this.getColumnFactory().columnAfter(this.parameter.inputCol, this.parameter.lengthCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
        if (!StringUtils.isBlank((String)this.parameter.centroidCol)) {
            this.centroidCD = this.getColumnFactory().columnAfter(this.parameter.inputCol, this.parameter.centroidCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
    }

    public void processRow(Row row) throws Exception {
        String val = row.get(this.inputCD);
        if (StringUtils.isBlank((String)val)) {
            return;
        }
        Geometry geom = null;
        String error = null;
        try {
            geom = this.geomMeaning.toGeometry(val);
            if (geom == null) {
                error = String.format("Failed to parse geometry '%s'", val);
            }
        }
        catch (Exception e) {
            error = String.format("Failed to parse geometry '%s': %s", val, e.getMessage());
        }
        if (geom != null) {
            try {
                if (this.centroidCD != null) {
                    Point centroidPoint = geom.getCentroid();
                    if (centroidPoint != null) {
                        row.put(this.centroidCD, centroidPoint.toText());
                    } else {
                        error = String.format("Failed to extract centroid point from geometry '%s'", val);
                    }
                }
                if (this.lengthCD != null) {
                    row.put(this.lengthCD, geom.getLength());
                }
                if (this.areaCD != null) {
                    row.put(this.areaCD, geom.getArea());
                }
            }
            catch (Exception e) {
                error = String.format("Failed to extract info from geometry '%s': %s", val, e.getMessage());
            }
        }
        if (error != null) {
            this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_GEO, error, logger);
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inputCol;
        public String centroidCol;
        public String lengthCol;
        public String areaCol;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            String affectedColumn = this.parameter.inputCol;
            if (!StringUtils.isBlank((String)this.parameter.centroidCol)) {
                this.addColumnInChain(this.parameter.centroidCol, chain, affectedColumn);
            }
            if (!StringUtils.isBlank((String)this.parameter.lengthCol)) {
                this.addColumnInChain(this.parameter.lengthCol, chain, affectedColumn);
            }
            if (!StringUtils.isBlank((String)this.parameter.areaCol)) {
                this.addColumnInChain(this.parameter.areaCol, chain, affectedColumn);
            }
            return chain;
        }

        public SQLQueryWithSchema addColumnInChain(String outputColumn, SQLQueryWithSchema chain, String affectedColumn) {
            ExpressionBuilder eb = null;
            Type outputColumnType = outputColumn.equals(this.parameter.centroidCol) ? Type.GEOPOINT : Type.DOUBLE;
            SchemaColumn schemaColumn = new SchemaColumn(outputColumn, outputColumnType);
            chain.addColumn(schemaColumn);
            if (outputColumn.equals(this.parameter.centroidCol)) {
                eb = chain.col(affectedColumn).stCentroid();
            }
            if (outputColumn.equals(this.parameter.areaCol)) {
                eb = chain.col(affectedColumn).stArea();
            }
            if (outputColumn.equals(this.parameter.lengthCol)) {
                eb = chain.col(affectedColumn).stLength();
            }
            chain.select(eb, outputColumn);
            chain.markColumnModified(outputColumn);
            return chain;
        }
    }
}

