/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.TimezonableProcessor;
import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysExtractionHelper;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HolidaysComputer {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "HolidaysComputer";
        }

        @Override
        public String getDocPage() {
            return "holidays-computer";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.DATE});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.HELP", "This processor identifies whether a date is a school holiday, a bank holiday or a weekend.\n\nIt takes as input a datetime with tz column and outputs 3 boolean columns : \n- `*school`: whether this date is a school holiday or not. (FR)\n- `*bank`: whether this date is a bank holiday or not. (FR,US,DE,ES,IN) (only for the whole country, not region-specific)\n- `*weekend`: whether this date is a weekend or not. (FR,US,DE,ES)\n\n\nIt's worth noting that a datetime with tz in DSS corresponds to a point in time, just like a timestamp. Conversely, a holiday is always defined by a timezone-less tuple (year,month,day). Consequently, a timezone must be provided in order to convert this timezone-less representation into a Date. \n\nAlthough the timezone can be specified explicitly, it may be more convenient to use the country's default timezone.\n\n| Country | Default timezone | \n| ------- |:----------------:| \n| FR      | Europe/Paris     | \n| US      | America/New_York | \n| DE      | Europe/Berlin    | \n| ES      | Europe/Madrid    | \n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            ArrayList<String> timezoneIDs = new ArrayList<String>();
            timezoneIDs.add("use_preferred_timezone");
            timezoneIDs.addAll(Arrays.asList(TimezonableProcessor.friendlyTimezoneIds));
            ArrayList<String> timezoneNames = new ArrayList<String>();
            timezoneNames.add(this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.COUNTRY_DEFAULT_TIMEZONE", "Country's default timezone"));
            timezoneNames.addAll(Arrays.asList(TimezonableProcessor.friendlyTimezoneNames(language)));
            ArrayList availableCalendars = Lists.newArrayList((Object[])new String[]{"FR", "US", "IN", "ES", "DE"});
            ArrayList<String> calendarChoiceValues = new ArrayList<String>();
            calendarChoiceValues.add("extract_from_column");
            calendarChoiceValues.addAll(availableCalendars);
            ArrayList<String> calendarChoiceLabels = new ArrayList<String>();
            calendarChoiceLabels.add(this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.USE_COUNTRY_CODE_FROM_OTHER_COLUMN", "Use country code from another column..."));
            calendarChoiceLabels.addAll(availableCalendars);
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION", 1.actionVerb("Flag") + " holidays"), false).withParam("timezone_src", "generic", true, true, this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.TIMEZONE_SRC", "Timezone source column")).withParam(ParamDesc.string("outColPrefix", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.OUT_COL_PREFIX", "Output column prefix"), this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.OUT_COL_PREFIX", "Output column prefix"), "holiday_")).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.IN_COL", "Input date column")).withParam(ParamDesc.advancedSelect("calendar_id", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.CALENDAR_ID", "Calendar"), this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.CALENDAR_ID", "Calendar"), calendarChoiceValues.toArray(new String[0]), calendarChoiceLabels.toArray(new String[0]))).withParam(ParamDesc.advancedSelect("timezone_id", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.TIMEZONE_ID", "Timezone"), "Timezone", timezoneIDs.toArray(new String[0]), timezoneNames.toArray(new String[0])).withDefaultValue("use_preferred_timezone").withCanBeEmpty(false)).withParam(ParamDesc.booleanP("flagWeekends", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.FLAG_WEEKENDS", "Flag weekends"), "", false)).withParam(ParamDesc.booleanP("flagSchoolHolidays", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.FLAG_SCHOOL_HOLIDAYS", "Flag school holidays"), "", false)).withParam(ParamDesc.booleanP("flagBankHolidays", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.FLAG_BANK_HOLIDAYS", "Flag bank holidays"), "", true)).withParam(ParamDesc.booleanP("extractReasons", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.EXTRACT_REASONS", "Extract reasons"), "", false)).withParam(ParamDesc.booleanP("extractZones", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.EXTRACT_ZONES", "Extract zones"), "", false)).withParam("calendar_src", "generic", true, true, this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.CALENDAR_SRC", "Country code source column"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            Parameter p = (Parameter)params;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                if ("extract_from_ip".equals(p.timezone_id)) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Only fixed or column timezone is supported");
                } else {
                    ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                }
            }
            return ret;
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject out = new JsonObject();
            out.addProperty("flagWeekends", Boolean.valueOf(parameter.flagWeekends));
            out.addProperty("flagBankHolidays", Boolean.valueOf(parameter.flagBankHolidays));
            out.addProperty("flagSchoolHolidays", Boolean.valueOf(parameter.flagSchoolHolidays));
            out.addProperty("extractReasons", Boolean.valueOf(parameter.extractReasons));
            out.addProperty("extractZones", Boolean.valueOf(parameter.extractZones));
            return out;
        }

        @Override
        public StreamImpl build(Parameter parameter) throws Exception {
            return new StreamImpl(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter holidayComputerParams = (Parameter)pss.params;
            if (StringUtils.isBlank((String)holidayComputerParams.outColPrefix)) {
                throw new IllegalArgumentException("Flag holidays: output column prefix cannot be empty");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (holidayComputerParams.flagBankHolidays) {
                    this.addRelations(updatedDatasetPairLineage, holidayComputerParams, "bank");
                    if (holidayComputerParams.extractReasons) {
                        this.addRelations(updatedDatasetPairLineage, holidayComputerParams, "bank_reasons");
                    }
                }
                if (holidayComputerParams.flagSchoolHolidays) {
                    this.addRelations(updatedDatasetPairLineage, holidayComputerParams, "school");
                    if (holidayComputerParams.extractReasons) {
                        this.addRelations(updatedDatasetPairLineage, holidayComputerParams, "school_reasons");
                    }
                }
                if (holidayComputerParams.flagWeekends) {
                    this.addRelations(updatedDatasetPairLineage, holidayComputerParams, "weekend");
                }
                if (holidayComputerParams.extractZones) {
                    this.addRelations(updatedDatasetPairLineage, holidayComputerParams, "zones");
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }

        private void addRelations(DatasetPairLineage updatedDatasetPairLineage, Parameter param, String columnName) {
            updatedDatasetPairLineage.addFactorizedColumnRelations(param.inCol, param.outColPrefix + columnName);
            if (StringUtils.equalsIgnoreCase((String)param.calendar_id, (String)"extract_from_column")) {
                updatedDatasetPairLineage.addFactorizedColumnRelations(param.calendar_src, param.outColPrefix + columnName);
            }
            if (Stream.of("extract_from_column", "extract_from_ip").anyMatch(tzId -> StringUtils.equalsIgnoreCase((String)param.timezone_id, (String)tzId))) {
                updatedDatasetPairLineage.addFactorizedColumnRelations(param.timezone_src, param.outColPrefix + columnName);
            }
        }
    };
    private static Logger logger = Logger.getLogger(HolidaysComputer.class);

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inCol;
        public String outColPrefix;
        public String calendar_id = "FR";
        public String calendar_src;
        public String timezone_id = "use_preferred_timezone";
        public String timezone_src;
        public boolean flagWeekends;
        public boolean flagSchoolHolidays;
        public boolean flagBankHolidays;
        public boolean extractReasons;
        public boolean extractZones;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final Parameter parameter;
        private String functionName;

        private SnowflakeUDFSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
            this.functionName = "holidaysFlag_" + SecretKeyGenerator.generate();
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.LOG4J_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR, SnowflakeUDFProcessorTranslator.StandardResource.GUAVA_JAR, SnowflakeUDFProcessorTranslator.StandardResource.ORGJSON_JAR, SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            resources.add(new SnowflakeUDFProcessorTranslator.SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"resources/holidays.db"}), ""));
            resources.add(new SnowflakeUDFProcessorTranslator.SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"resources/weekends.db"}), ""));
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.time.ical.HolidaysComputerUDF.processFixedCalendar", "data TIMESTAMP_TZ, calendar STRING, usePreferedTimezone BOOLEAN, timezone STRING, school BOOLEAN, bank BOOLEAN, weekends BOOLEAN, reasons BOOLEAN, zones BOOLEAN", "TIMESTAMP_TZ, STRING, BOOLEAN, STRING, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN", "ARRAY");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.LOG4J_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR, SnowflakeUDFProcessorTranslator.StandardResource.GUAVA_JAR, SnowflakeUDFProcessorTranslator.StandardResource.ORGJSON_JAR, SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            def.imports.add("holidays.db");
            def.imports.add("weekends.db");
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            chain.select(ebf.expr(String.format("%s(%s, %s, %s, %s, %s, %s, %s, %s, %s)", this.functionName, d.quoteIdentifier(this.parameter.inCol), d.quoteString(this.parameter.calendar_id), StringUtils.equalsIgnoreCase((String)this.parameter.timezone_id, (String)"use_preferred_timezone"), d.quoteString(this.parameter.timezone_id), this.parameter.flagSchoolHolidays, this.parameter.flagBankHolidays, this.parameter.flagWeekends, this.parameter.extractReasons, this.parameter.extractZones)), "HOLIDAYS_RESULT");
            SQLQueryWithSchema outer = chain.makeSubquery();
            int next = 0;
            SchemaColumn inputSchemaColumn = outer.getCurrentColumn(this.parameter.inCol);
            if (this.parameter.flagBankHolidays) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("HOLIDAYS_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "bank", false);
            }
            if (this.parameter.flagSchoolHolidays) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("HOLIDAYS_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "school", false);
            }
            if (this.parameter.flagWeekends) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("HOLIDAYS_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "weekend", false);
            }
            if (this.parameter.extractReasons) {
                if (this.parameter.flagBankHolidays) {
                    outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("HOLIDAYS_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "bank_reasons", false);
                }
                if (this.parameter.flagSchoolHolidays) {
                    outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("HOLIDAYS_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "school_reasons", false);
                }
            }
            if (this.parameter.extractZones) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("HOLIDAYS_RESULT[" + next++ + "]"), Type.STRING, this.parameter.outColPrefix + "zones", false);
            }
            outer.deleteColumn("HOLIDAYS_RESULT");
            outer.deleteSelect("HOLIDAYS_RESULT");
            return outer;
        }
    }

    static class StreamImpl
    extends TimezonableProcessor
    implements ProcessorWithResourceFiles {
        private final Parameter parameter;
        private Column inColCD;
        private boolean usePreferredTimezones;
        private Column outBankColCD;
        private Column outWeekendColCD;
        private Column outSchoolColCD;
        private Column outSchoolReasonsColCD;
        private Column outBankReasonsColCD;
        private Column inCalendarCol;
        private Column outZonesColCD;
        private final AnyTemporal temporalMeaning = new AnyTemporal();

        public StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Map<String, File> gatherRequirements() {
            Map<String, File> requirements = super.gatherRequirements();
            String installDir = ApplicationConfigurator.getInstallFolder();
            if (StringUtils.isBlank((String)installDir)) {
                logger.error((Object)"DKUINSTALLDIR is not defined. Cannot load holidays/weekends database.");
            }
            requirements.put("dku.holidays.db", new File(installDir, "resources/holidays.db"));
            requirements.put("dku.weekends.db", new File(installDir, "resources/weekends.db"));
            return requirements;
        }

        @Override
        public void setRequiredFiles(Map<String, File> requiredFiles) {
            super.setRequiredFiles(requiredFiles);
            File holidaysDBFile = requiredFiles.get("dku.holidays.db");
            File weekendsDBFile = requiredFiles.get("dku.weekends.db");
            HolidaysExtractionHelper.loadSharedDatabase((File)weekendsDBFile, (File)holidaysDBFile);
        }

        public void init() throws Exception {
            this.inColCD = this.getColumnFactory().column(this.parameter.inCol, Processor.ProcessorRole.INPUT_COLUMN);
            if (StringUtils.equalsIgnoreCase((String)this.parameter.calendar_id, (String)"extract_from_column")) {
                this.inCalendarCol = this.getColumnFactory().column(this.parameter.calendar_src, Processor.ProcessorRole.INPUT_COLUMN);
            }
            if (this.parameter.extractZones) {
                this.outZonesColCD = this.getColumnFactory().columnAfter(this.parameter.inCol, this.parameter.outColPrefix + "zones", Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (this.parameter.flagWeekends) {
                this.outWeekendColCD = this.getColumnFactory().columnAfter(this.parameter.inCol, this.parameter.outColPrefix + "weekend", Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (this.parameter.flagSchoolHolidays) {
                this.outSchoolColCD = this.getColumnFactory().columnAfter(this.parameter.inCol, this.parameter.outColPrefix + "school", Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (this.parameter.flagBankHolidays) {
                this.outBankColCD = this.getColumnFactory().columnAfter(this.parameter.inCol, this.parameter.outColPrefix + "bank", Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (this.parameter.extractReasons) {
                if (this.parameter.flagBankHolidays) {
                    this.outBankReasonsColCD = this.getColumnFactory().columnAfter(this.parameter.outColPrefix + "bank", this.parameter.outColPrefix + "bank_reasons", Processor.ProcessorRole.OUTPUT_COLUMN);
                }
                if (this.parameter.flagSchoolHolidays) {
                    this.outSchoolReasonsColCD = this.getColumnFactory().columnAfter(this.parameter.outColPrefix + "school", this.parameter.outColPrefix + "school_reasons", Processor.ProcessorRole.OUTPUT_COLUMN);
                }
            }
            this.usePreferredTimezones = StringUtils.equalsIgnoreCase((String)this.parameter.timezone_id, (String)"use_preferred_timezone");
            if (!this.usePreferredTimezones) {
                this.initTimezonableWithParams(this.parameter.timezone_id, this.parameter.timezone_src);
            }
        }

        private String getCalendarId(Row row) {
            String calId = StringUtils.equalsIgnoreCase((String)this.parameter.calendar_id, (String)"extract_from_column") ? row.get(this.inCalendarCol) : this.parameter.calendar_id;
            if (calId == null) {
                calId = "";
            }
            return calId;
        }

        public void processRow(Row row) throws Exception {
            long dateVal = this.temporalMeaning.longValue(row.get(this.inColCD));
            if (dateVal == Long.MAX_VALUE) {
                return;
            }
            String calendarId = this.getCalendarId(row);
            if (this.usePreferredTimezones) {
                DateTime dt = new DateTime(dateVal);
                this.handleFoundOccurrences(row, HolidaysExtractionHelper.getCachedDB().searchForDay(dt, calendarId));
            } else {
                DateTimeZone currentTimezone = this.getTimezone(row);
                if (currentTimezone == null) {
                    return;
                }
                GregorianCalendar outCal = new GregorianCalendar(currentTimezone.toTimeZone());
                outCal.setTime(new Date(dateVal));
                int year = outCal.get(1);
                int monthofyear = outCal.get(2) + 1;
                int dayofmonth = outCal.get(5);
                this.handleFoundOccurrences(row, HolidaysExtractionHelper.getCachedDB().searchForDay(year, monthofyear, dayofmonth, calendarId));
            }
        }

        private void handleFoundOccurrences(Row row, List<HolidayOccurrence> occurrences) {
            HolidaysExtractionHelper.SearchResult result = HolidaysExtractionHelper.handleOccurences(occurrences, (boolean)this.parameter.flagSchoolHolidays, (boolean)this.parameter.flagBankHolidays, (boolean)this.parameter.flagWeekends, (boolean)this.parameter.extractReasons, (boolean)this.parameter.extractZones);
            if (this.parameter.flagBankHolidays) {
                row.put(this.outBankColCD, result.isBankHoliday);
            }
            if (this.parameter.flagSchoolHolidays) {
                row.put(this.outSchoolColCD, result.isSchoolHoliday);
            }
            if (this.parameter.flagWeekends) {
                row.put(this.outWeekendColCD, result.isWeekend);
            }
            if (this.parameter.extractReasons) {
                if (this.parameter.flagBankHolidays) {
                    row.put(this.outBankReasonsColCD, HolidaysExtractionHelper.jsonify((Collection)result.bankHolidayReasons));
                }
                if (this.parameter.flagSchoolHolidays) {
                    row.put(this.outSchoolReasonsColCD, HolidaysExtractionHelper.jsonify((Collection)result.schoolHolidayReasons));
                }
            }
            if (this.parameter.extractZones) {
                row.put(this.outZonesColCD, HolidaysExtractionHelper.jsonify((Collection)result.zones));
            }
        }

        public void postProcess() throws Exception {
        }
    }
}

