/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysDatabase;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClients;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class HolidaysDatabaseBuilder {
    private static FileWriter writer;

    private static void logMessage(String msg) {
        String installDir = System.getenv("DKUINSTALLDIR");
        if (StringUtils.isBlank((String)installDir)) {
            throw new RuntimeException("DKUINSTALLDIR is not defined");
        }
        try {
            if (writer == null) {
                File buildLog = new File(installDir, "build-resources/holidays/build.log");
                if (buildLog.exists()) {
                    DKUFileUtils.forceDelete((File)buildLog);
                }
                writer = new FileWriter(buildLog);
            }
            System.err.println(msg);
            writer.write(msg);
            writer.write("\n");
        }
        catch (Exception e) {
            throw new RuntimeException("IO error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException, ParserException {
        try {
            HolidaysDatabaseBuilder.logMessage("Welcome to the Dataiku Holidays database builder !");
            String installDir = System.getenv("DKUINSTALLDIR");
            if (StringUtils.isBlank((String)installDir)) {
                throw new IOException("DKUINSTALLDIR is not defined");
            }
            File resources = new File(installDir, "resources");
            if (!resources.isDirectory()) {
                throw new IOException("Unable to find resources directory " + resources.getAbsolutePath());
            }
            File holidayDbFile = new File(resources, "holidays.db");
            File sourceCalendars = new File(installDir, "build-resources/holidays");
            if (!sourceCalendars.isDirectory()) {
                throw new IOException("Unable to find source ICal directory " + sourceCalendars.getAbsolutePath());
            }
            ArrayList<Object> allOccurrences = new ArrayList<Object>();
            Object[] sortedFilenames = sourceCalendars.list();
            if (sortedFilenames == null) {
                sortedFilenames = new String[]{};
            }
            Arrays.sort(sortedFilenames);
            for (Object metaFileName : sortedFilenames) {
                File metaFile = new File(sourceCalendars, (String)metaFileName);
                if (!metaFile.getName().endsWith(".meta") || !metaFile.isFile()) continue;
                MetaFile mf = (MetaFile)JSON.parseFile((File)metaFile, MetaFile.class);
                String metaFileFullPath = metaFile.getAbsolutePath();
                String dataFilePath = StringUtils.removeEnd((String)metaFileFullPath, (String)".meta") + (mf.source == MetaFile.Source.ICAL ? ".ics" : ".psv");
                File dataFile = new File(dataFilePath);
                File dataTmpFile = new File(dataFilePath + ".tmp");
                if (dataTmpFile.exists()) {
                    DKUFileUtils.forceDelete((File)dataTmpFile);
                }
                if (!StringUtils.isBlank((String)mf.url)) {
                    HolidaysDatabaseBuilder.logMessage("Try to update " + dataFile.getName() + " from " + mf.url);
                    try (CloseableHttpClient client = HttpClients.createDefault();){
                        HttpGet get = new HttpGet(mf.url);
                        get.addHeader("User-Agent", "curl/7.54.0");
                        try (CloseableHttpResponse resp = client.execute((HttpUriRequest)get);){
                            String body = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                            if (resp.getStatusLine().getStatusCode() > 299) {
                                throw new IllegalArgumentException("Failed to query, code: " + resp.getStatusLine().getStatusCode() + ", body " + body);
                            }
                            DKUFileUtils.writeFileUTF8((File)dataTmpFile, (String)body);
                        }
                    }
                }
                if (dataTmpFile.isFile() && dataTmpFile.length() > 0L) {
                    DKUFileUtils.forceDelete((File)dataFile);
                    if (!dataTmpFile.renameTo(dataFile)) {
                        throw new IOException("Failed to rename " + String.valueOf(dataTmpFile) + " to " + String.valueOf(dataFile));
                    }
                } else {
                    HolidaysDatabaseBuilder.logMessage("Warn: Cannot download " + dataFile.getName() + " from " + mf.url + ". You might want to update this file manually.");
                }
                if (mf.source == MetaFile.Source.ICAL) {
                    HolidaysDatabaseBuilder.logMessage("Processing ICAL " + dataFile.getName());
                    Pattern exclude = null;
                    if (!StringUtils.isBlank((String)mf.exclude)) {
                        exclude = Pattern.compile(mf.exclude);
                    }
                    byte[] bytes = FileUtils.readFileToByteArray((File)dataFile);
                    List<HolidayOccurrence> occurrences = HolidaysDatabaseBuilder.extractFromICal(mf.calendarId, bytes, new Date(mf.yearFrom - 1900, 1, 1), new Date(mf.yearTo - 1900, 1, 1), mf.preferredTimezone, mf.type, mf.zone, exclude, mf.replacePattern, mf.replaceBy);
                    HolidaysDatabaseBuilder.logMessage("> Imported " + occurrences.size() + " occurrences from ICAL");
                    allOccurrences.addAll(occurrences);
                    continue;
                }
                if (mf.source == MetaFile.Source.MANUAL) {
                    HolidaysDatabaseBuilder.logMessage("Processing PSV " + dataFile.getName());
                    ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>();
                    try (FileInputStream fis = new FileInputStream(dataFile);
                         InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                         BufferedReader br = new BufferedReader(isr);){
                        String line;
                        while ((line = br.readLine()) != null) {
                            if (StringUtils.isBlank((String)line)) {
                                break;
                            }
                            if (line.startsWith("#")) continue;
                            String[] splitted = line.split("\\|");
                            int from = Integer.parseInt(splitted[0]);
                            int to = Integer.parseInt(splitted[1]);
                            HolidayOccurrence.Type type = HolidayOccurrence.Type.valueOf((String)splitted[2]);
                            String zone = splitted[3];
                            String name = splitted[4];
                            if (from >= to) {
                                HolidaysDatabaseBuilder.logMessage("Warn: unable to insert event because duration <= 1day: [" + from + "->" + to + "] " + name);
                            }
                            HolidayOccurrence occurrence = new HolidayOccurrence(name, mf.calendarId, from, to, mf.preferredTimezone, type, zone);
                            occurrences.add(occurrence);
                        }
                    }
                    HolidaysDatabaseBuilder.logMessage("> Imported " + occurrences.size() + " manually crafted holiday occurrences");
                    allOccurrences.addAll(occurrences);
                    continue;
                }
                HolidaysDatabaseBuilder.logMessage("Error: Unknown source");
            }
            HolidaysDatabase db = HolidaysDatabase.updatePreviousHolidaysDatabase((File)holidayDbFile, allOccurrences);
            HolidaysDatabaseBuilder.logMessage("Generated calendars:");
            for (String c2 : db.listAvailableCalendars()) {
                HolidaysDatabaseBuilder.logMessage("  - " + c2);
            }
            HolidaysDatabaseBuilder.logMessage("Total: " + allOccurrences.size() + " entries");
            db.saveToFile(holidayDbFile);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static List<HolidayOccurrence> extractFromICal(String calendarId, byte[] bytes, Date from, Date to, String preferredTimezone, HolidayOccurrence.Type type, String zone, Pattern exclude, String[] replacePattern, String[] replaceBy) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        Calendar cal = builder.build((InputStream)new ByteArrayInputStream(bytes));
        Period period = new Period(new DateTime(from), new DateTime(to));
        ArrayList<HolidayOccurrence> entries = new ArrayList<HolidayOccurrence>();
        for (Object o : cal.getComponents("VEVENT")) {
            VEvent vEvent = (VEvent)o;
            Summary summary = vEvent.getSummary();
            String summaryValue = summary.getValue();
            if (exclude != null && exclude.matcher(summaryValue).find()) {
                HolidaysDatabaseBuilder.logMessage("Info: excluded all occurrences of \"" + summaryValue + "\"");
                continue;
            }
            if (replacePattern != null && replaceBy != null && replacePattern.length == replaceBy.length) {
                for (int i = 0; i < replacePattern.length; ++i) {
                    Pattern pt = Pattern.compile(replacePattern[i]);
                    String newVal = pt.matcher(summaryValue).replaceAll(replaceBy[i]);
                    if (newVal.equals(summaryValue)) continue;
                    HolidaysDatabaseBuilder.logMessage("Renamed \"" + summaryValue + "\" -> \"" + newVal + "\"");
                    summaryValue = newVal;
                    break;
                }
            }
            summaryValue = summaryValue.trim();
            if (summary == null) continue;
            PeriodList list = vEvent.calculateRecurrenceSet(period);
            for (Object po : list) {
                Period p = (Period)po;
                Object dateEnd = p.getEnd();
                DateTime dateStart = p.getStart();
                boolean logFixed = false;
                if (((Date)dateEnd).getYear() == dateStart.getYear() && ((Date)dateEnd).getDate() == dateStart.getDate() && ((Date)dateEnd).getMonth() == dateStart.getMonth()) {
                    logFixed = true;
                    dateEnd = DateUtils.addDays((Date)dateEnd, (int)1);
                }
                int dayFrom = HolidayOccurrence.packDate((int)(dateStart.getYear() + 1900), (int)(dateStart.getMonth() + 1), (int)dateStart.getDate());
                int dayTo = HolidayOccurrence.packDate((int)(((Date)dateEnd).getYear() + 1900), (int)(((Date)dateEnd).getMonth() + 1), (int)((Date)dateEnd).getDate());
                if (logFixed) {
                    HolidaysDatabaseBuilder.logMessage("Info: event because duration was <= 1day but the issue bas been automatically fixed: [" + dayFrom + "->" + dayTo + "] " + summaryValue);
                }
                if (dayFrom >= dayTo) {
                    HolidaysDatabaseBuilder.logMessage("Warn: unable to insert event because duration <= 1day: [" + dayFrom + "->" + dayTo + "] " + summaryValue);
                }
                HolidayOccurrence eventOccurrence = new HolidayOccurrence(summaryValue, calendarId, dayFrom, dayTo, preferredTimezone, type, zone);
                entries.add(eventOccurrence);
            }
        }
        return entries;
    }

    static {
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.vcard", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
    }

    public static class MetaFile {
        String calendarId;
        String preferredTimezone;
        String url;
        String zone;
        HolidayOccurrence.Type type = HolidayOccurrence.Type.BANK;
        Integer yearFrom;
        Integer yearTo;
        String exclude;
        String[] replacePattern;
        String[] replaceBy;
        Source source = Source.ICAL;

        public static enum Source {
            ICAL,
            MANUAL;

        }
    }
}

