/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class ColumnReorder
extends AppliesToProcessor
implements Processor {
    public static final ProcessorMeta<ColumnReorder, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<ColumnReorder, Parameter>(){

        @Override
        public String getName() {
            return "ColumnReorder";
        }

        @Override
        public String getDocPage() {
            return "move-columns";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ColumnReorder.HELP", "Select one or more columns and move them either before/after an existing column or at the beginning/end of all columns.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ColumnReorder.DESCRIPTION", 1.actionVerb("Move") + " columns")).withParam(ParamDesc.advancedSelect("reorderAction", this.translate(language, "SHAKER.PROCESSOR.ColumnReorder.PARAMS.NEW_POSITION", "New position"), this.translate(language, "SHAKER.PROCESSOR.ColumnReorder.PARAMS.NEW_POSITION.HELP", "New position of the column"), ReorderAction.class, language).withDefaultValue(ReorderAction.AT_START)).withParam("referenceColumn", "column", false, true, this.translate(language, "SHAKER.PROCESSOR.ColumnReorder.PARAMS.OTHER_COLUMN", "Other column"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new ProcessorSQLTranslator(){

                @Override
                public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
                    return input;
                }
            };
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = AppliesToProcessor.selfReport(p);
            out.remove("referenceColumn");
            return out;
        }

        @Override
        public ColumnReorder build(Parameter parameter) {
            return new ColumnReorder(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            return previousRecipeLineage;
        }
    };
    private final Parameter parameter;

    public ColumnReorder(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void init() {
        List<Column> selectedColumns;
        this.columns = selectedColumns = this.selectColumns();
        switch (this.parameter.reorderAction) {
            case BEFORE_COLUMN: {
                if (StringUtils.isBlank((String)this.parameter.referenceColumn)) {
                    throw ErrorContext.iae((String)"Other column is mandatory when the new position is set to 'Before another column'.");
                }
                for (Column column : selectedColumns) {
                    String selectedColumn = column.getName();
                    if (this.parameter.referenceColumn.equals(selectedColumn)) continue;
                    this.getColumnFactory().moveBefore(this.parameter.referenceColumn, selectedColumn);
                }
                break;
            }
            case AFTER_COLUMN: {
                if (StringUtils.isBlank((String)this.parameter.referenceColumn)) {
                    throw ErrorContext.iae((String)"Other column is mandatory when the new position is set to 'After another column'.");
                }
                int selectedColumnsSize = selectedColumns.size();
                for (int i = 0; i < selectedColumnsSize; ++i) {
                    String selectedColumn = selectedColumns.get(selectedColumnsSize - 1 - i).getName();
                    if (this.parameter.referenceColumn.equals(selectedColumn)) continue;
                    this.getColumnFactory().moveAfter(this.parameter.referenceColumn, selectedColumn);
                }
                break;
            }
            case AT_START: {
                int selectedColumnsSize = selectedColumns.size();
                for (int i = 0; i < selectedColumnsSize; ++i) {
                    Column selectedColumn = selectedColumns.get(selectedColumnsSize - 1 - i);
                    this.getColumnFactory().moveAtStart(selectedColumn.getName());
                }
                break;
            }
            case AT_END: {
                for (Column column : selectedColumns) {
                    this.getColumnFactory().moveAtEnd(column.getName());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled reorder action: " + String.valueOf(this.parameter.reorderAction));
            }
        }
    }

    private List<Column> selectColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        switch (this.parameter.appliesTo) {
            case SINGLE_COLUMN: {
                if (this.parameter.columns.isEmpty()) break;
                columnList.add(this.getColumnFactory().column((String)this.parameter.columns.get(0), Processor.ProcessorRole.INPUT_COLUMN));
                break;
            }
            case COLUMNS: {
                for (String col : this.parameter.columns) {
                    columnList.add(this.getColumnFactory().column(col, Processor.ProcessorRole.INPUT_COLUMN));
                }
                break;
            }
            case PATTERN: {
                if (StringUtils.isBlank((String)this.parameter.appliesToPattern)) {
                    throw new IllegalArgumentException("The Column pattern is empty");
                }
                try {
                    this.columnNameCompiledPattern = Pattern.compile(this.parameter.appliesToPattern);
                }
                catch (PatternSyntaxException ex) {
                    throw new IllegalArgumentException("The Column pattern is invalid: " + ExceptionUtils.getMessageWithCauses((Throwable)ex), ex);
                }
                for (Column column : this.getColumnFactory().columns()) {
                    if (!this.columnNameCompiledPattern.matcher(column.getName()).matches()) continue;
                    columnList.add(column);
                }
                break;
            }
            case ALL: {
                for (Column column : this.getColumnFactory().columns()) {
                    columnList.add(column);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected appliesTo value: " + String.valueOf((Object)this.parameter.appliesTo));
            }
        }
        return columnList;
    }

    @Override
    public void processRow(Row row) {
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
    }

    @Override
    public AppliesToProcessor.AppliesToParams getParams() {
        return this.parameter;
    }

    public void postProcess() {
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        ReorderAction reorderAction = ReorderAction.AT_END;
        String referenceColumn;

        @Override
        public void validate() {
        }
    }

    public static enum ReorderAction implements Labelled
    {
        AT_START("SHAKER.PROCESSOR.ColumnReorder.ReorderAction.AT_START", "At beginning"),
        BEFORE_COLUMN("SHAKER.PROCESSOR.ColumnReorder.ReorderAction.BEFORE_COLUMN", "Before another column..."),
        AFTER_COLUMN("SHAKER.PROCESSOR.ColumnReorder.ReorderAction.AFTER_COLUMN", "After another column..."),
        AT_END("SHAKER.PROCESSOR.ColumnReorder.ReorderAction.AT_END", "At end");

        private final String translationId;
        private final String defaultLabel;

        private ReorderAction(String translationId, String defaultLabel) {
            this.translationId = translationId;
            this.defaultLabel = defaultLabel;
        }

        @Override
        public String getLabel() {
            return this.getLabel("en");
        }

        @Override
        public String getLabel(String language) {
            TranslationService sts = (TranslationService)SpringUtils.getBean(TranslationService.class);
            return sts.translate(language, this.translationId, this.defaultLabel, new Object[0]);
        }
    }
}

