/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.Boolean;
import com.google.common.collect.Sets;
import java.util.Set;

public class BooleanNot
extends SingleRowProcessor
implements Processor {
    String inCol;
    Column col;
    public static final ProcessorMeta<BooleanNot, Parameter> META = new ProcessorMeta<BooleanNot, Parameter>(){

        @Override
        public String getName() {
            return "BooleanNot";
        }

        @Override
        public String getDocPage() {
            return "negate";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.BooleanNot.HELP", "This processor transforms a boolean value to its negation\n\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.BooleanNot.DESCRIPTION", 1.actionVerb("Negate") + " boolean value")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column"));
        }

        @Override
        public BooleanNot build(Parameter parameter) throws Exception {
            return new BooleanNot(parameter.column);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }
    };

    public void init() throws Exception {
        this.col = this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.INPUT_COLUMN);
    }

    public BooleanNot(String inCol) {
        this.inCol = inCol;
    }

    public void processRow(Row row) throws Exception {
        Object v;
        String value = row.get(this.col);
        if (value == null) {
            return;
        }
        if (value.length() > 0 && (v = Boolean.opposite((String)value.toLowerCase())) != null) {
            if (Character.isUpperCase(value.charAt(0))) {
                v = value.length() > 1 && Character.isUpperCase(value.charAt(1)) ? ((String)v).toUpperCase() : Character.toUpperCase(((String)v).charAt(0)) + ((String)v).substring(1);
            }
            row.put(this.col, (String)v);
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;

        public void validate() throws IllegalArgumentException {
        }
    }
}

