/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.shaker.processors.udf.CustomJythonStepParams;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.shaker.processors.udf.PythonUDFCell;
import com.dataiku.dip.shaker.processors.udf.PythonUDFModeHandler;
import com.dataiku.dip.shaker.processors.udf.PythonUDFMultiRows;
import com.dataiku.dip.shaker.processors.udf.PythonUDFRow;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CustomJythonProcessorDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSON.FileTransient
    public String id;
    public DkuComponentMetadata meta;
    public String paramsTemplate;
    public String paramsModule;
    public String paramsPythonSetup;
    public CustomJythonProcessorMode mode = CustomJythonProcessorMode.CELL;
    public boolean useKernel = false;
    public boolean vectorize = false;
    public List<String> processorTags = Lists.newArrayList();
    public List<ParamDesc> params = new ArrayList<ParamDesc>();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CustomJythonProcessorMode implements Serializable
    {
        CELL{

            @Override
            public PythonUDFModeHandler build(LoadedJythonProcessor loaded, CustomJythonStepParams params) {
                return new PythonUDFCell(loaded, params);
            }
        }
        ,
        ROW{

            @Override
            public PythonUDFModeHandler build(LoadedJythonProcessor loaded, CustomJythonStepParams params) {
                return new PythonUDFRow(loaded, params);
            }
        }
        ,
        ROWS{

            @Override
            public PythonUDFModeHandler build(LoadedJythonProcessor loaded, CustomJythonStepParams params) {
                return new PythonUDFMultiRows(loaded, params);
            }
        };


        public abstract PythonUDFModeHandler build(LoadedJythonProcessor var1, CustomJythonStepParams var2);
    }
}

