/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.services;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColumnStorageTypeInferer;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.meanings.AbstractBasicMeaningsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.shaker.types.Text;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TypeInferrer2 {
    @Autowired
    private AbstractBasicMeaningsService basicMeaningsService;
    @Autowired
    private PubSubService pubSub;
    Cache<String, ColumnCacheEntry> columnsCache = CacheBuilder.newBuilder().expireAfterAccess(10000L, TimeUnit.SECONDS).softValues().maximumSize(2000L).build();
    public static final int NB_THREADS = 4;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.types.inferrer");

    public TypeInferrer2() {
        SpringUtils.getInstance().autowire((Object)this);
        this.pubSub.subscribe("meanings-folder-change", (DSSEventListener)new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) {
                TypeInferrer2.this.columnsCache.invalidateAll();
            }
        });
        this.pubSub.subscribe("meaning-change", (DSSEventListener)new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) {
                TypeInferrer2.this.columnsCache.invalidateAll();
            }
        });
    }

    private ExecutorService newExecutorService(String name) {
        return Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat(name + "-%d").build());
    }

    private FutureAborter.AutoCloseableAbortHook pushHook(final ExecutorService execService) {
        return FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting inferrence threads");
                execService.shutdownNow();
            }
        });
    }

    private void warnIfTransaction() {
        if (TransactionContext.hasAttachedTransaction()) {
            logger.warn((Object)"Type inference with attached transaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processForExplore(String cacheKey, MemTable table, Schema schema) throws Exception {
        this.warnIfTransaction();
        logger.info((Object)("Starting EXPLORE type inference on  " + table.nrows() + " rows"));
        long before = System.currentTimeMillis();
        InferenceContext icontext = new InferenceContext();
        ExecutorService execService = this.newExecutorService("explore-typeinfer");
        try (FutureAborter.AutoCloseableAbortHook aborting = this.pushHook(execService);
             FutureProgress.AutocloseableFutureProgressState detectionState = FutureProgress.pushAutoCloseableState((String)"Detecting column type", (double)table.columnsList.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            int autoDetect = 0;
            int verifyOnly = 0;
            for (MemColumn memColumn : table.columnsList) {
                SchemaColumn schemaColumn;
                memColumn.datasetSchemaColumn = schemaColumn = schema == null ? null : schema.getColumn(memColumn.getName());
                if (schemaColumn != null && StringUtils.isNotBlank((String)schemaColumn.getMeaning())) {
                    ++verifyOnly;
                    futures.add(execService.submit(new VerifyOnlyColumnHandler(icontext, table, memColumn, schemaColumn.getMeaning(), false, null)));
                    continue;
                }
                ++autoDetect;
                futures.add(execService.submit(new InferColumnHandler(icontext, cacheKey, table, memColumn, false, null)));
            }
            for (Future future : futures) {
                future.get();
                detectionState.increment(1.0);
            }
            logger.infoV("Type inference time=" + (System.currentTimeMillis() - before) + " autoDetect=%d verify=%d cacheSize=%d cacheHitRate=%.2f", new Object[]{autoDetect, verifyOnly, this.columnsCache.size(), this.columnsCache.stats().hitRate()});
        }
        finally {
            execService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processForAnalysis(String cacheKey, MemTable table, Map<String, SerializedShakerScript.AnalysisColumnData> columnData) throws Exception {
        this.warnIfTransaction();
        logger.info((Object)("Starting ANALYSIS type inference on  " + table.nrows() + " rows"));
        long before = System.currentTimeMillis();
        InferenceContext icontext = new InferenceContext();
        ExecutorService execService = this.newExecutorService("analysis-typeinfer");
        try (FutureAborter.AutoCloseableAbortHook aborting = this.pushHook(execService);
             FutureProgress.AutocloseableFutureProgressState detectionState = FutureProgress.pushAutoCloseableState((String)"Detecting column type", (double)table.columnsList.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            int autoDetect = 0;
            int verifyOnly = 0;
            for (MemColumn memColumn : table.columnsList) {
                SerializedShakerScript.AnalysisColumnData acd = columnData.get(memColumn.getName());
                if (acd != null && StringUtils.isNotBlank((String)acd.meaning)) {
                    ++verifyOnly;
                    futures.add(execService.submit(new VerifyOnlyColumnHandler(icontext, table, memColumn, acd.meaning, false, null)));
                    continue;
                }
                ++autoDetect;
                futures.add(execService.submit(new InferColumnHandler(icontext, cacheKey, table, memColumn, false, null)));
            }
            for (Future future : futures) {
                future.get();
                detectionState.increment(1.0);
            }
            logger.infoV("Type inference elapsed=%d detect=%d verify=%d colCacheHit=%d colCacheMiss=%d ht=%d pt=%d dt=%d", new Object[]{System.currentTimeMillis() - before, autoDetect, verifyOnly, icontext.columnCacheHits, icontext.columnCacheMiss, icontext.hashTime, icontext.probeTime, icontext.detectTime});
        }
        finally {
            execService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processForRecipe(String cacheKey, MemTable table, DataService.ShakerRecipeSchema currentSchema) throws Exception {
        this.warnIfTransaction();
        logger.info((Object)("Starting RECIPE type inference on  " + table.nrows() + " rows"));
        long before = System.currentTimeMillis();
        InferenceContext icontext = new InferenceContext();
        ExecutorService execService = this.newExecutorService("analysis-typeinfer");
        try (FutureAborter.AutoCloseableAbortHook aborting = this.pushHook(execService);){
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            int autoDetect = 0;
            int verifyOnly = 0;
            for (MemColumn memColumn : table.columnsList) {
                DataService.ShakerRecipeSchemaColumn rSchemaCol = currentSchema.columns.get(memColumn.getName());
                if (rSchemaCol != null && StringUtils.isNotBlank((String)rSchemaCol.column.getMeaning())) {
                    ++verifyOnly;
                    futures.add(execService.submit(new VerifyOnlyColumnHandler(icontext, table, memColumn, rSchemaCol.column.getMeaning(), true, rSchemaCol)));
                    continue;
                }
                ++autoDetect;
                futures.add(execService.submit(new InferColumnHandler(icontext, cacheKey, table, memColumn, true, rSchemaCol)));
            }
            for (Future future : futures) {
                future.get();
            }
            logger.infoV("Type inference time=" + (System.currentTimeMillis() - before) + " autoDetect=%d verify=%d cacheSize=%d cacheHitRate=%.2f", new Object[]{autoDetect, verifyOnly, this.columnsCache.size(), this.columnsCache.stats().hitRate()});
        }
        finally {
            execService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFullAuto(String cacheKey, MemTable table) throws Exception {
        this.warnIfTransaction();
        logger.info((Object)("Starting AUTO type inference on  " + table.nrows() + " rows"));
        long before = System.currentTimeMillis();
        InferenceContext icontext = new InferenceContext();
        ExecutorService execService = this.newExecutorService("analysis-typeinfer");
        try (FutureAborter.AutoCloseableAbortHook aborting = this.pushHook(execService);
             FutureProgress.AutocloseableFutureProgressState detectionState = FutureProgress.pushAutoCloseableState((String)"Detecting column type", (double)table.columnsList.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (MemColumn memColumn : table.columnsList) {
                futures.add(execService.submit(new InferColumnHandler(icontext, cacheKey, table, memColumn, false, null)));
            }
            for (Future future : futures) {
                future.get();
                detectionState.increment(1.0);
            }
            logger.infoV("Type inference time=" + (System.currentTimeMillis() - before) + " cacheSize=%d cacheHitRate=%.2f", new Object[]{this.columnsCache.size(), this.columnsCache.stats().hitRate()});
        }
        finally {
            execService.shutdownNow();
        }
    }

    public static class InferenceContext {
        public int verifyJobs;
        public int inferJobs;
        public int totalProbedTypes;
        public int columnCacheHits;
        public int columnCacheMiss;
        public long hashTime;
        public long probeTime;
        public long detectTime;
        public long totalTime;
    }

    private class VerifyOnlyColumnHandler
    extends ColumnHandlerBase
    implements Callable<Void> {
        String forcedMeaning;

        VerifyOnlyColumnHandler(InferenceContext icontext, MemTable table, MemColumn cd, String forcedMeaning, boolean computeOutputSchemaCol, DataService.ShakerRecipeSchemaColumn currentSchemaCol) {
            this.icontext = icontext;
            this.table = table;
            this.cd = cd;
            this.forcedMeaning = forcedMeaning;
            this.computeoutputSchemaCol = computeOutputSchemaCol;
            this.currentSchemaCol = currentSchemaCol;
        }

        @Override
        public Void call() throws InterruptedException, IOException {
            long colStart = System.currentTimeMillis();
            this.handleNbChars(false);
            long nbCharsDone = System.currentTimeMillis();
            this.notEmptyList.shuffle(this.r);
            long shuffleDone = System.currentTimeMillis();
            int lookupOn = 0;
            double lookupRatio = 0.0;
            if (this.nbNotEmpty < 2000) {
                lookupOn = this.nbNotEmpty;
                lookupRatio = 1.0;
            } else {
                lookupOn = 2000 + (int)((double)(this.nbNotEmpty - 2000) * 0.2);
                lookupRatio = (double)lookupOn / (double)this.nbNotEmpty;
            }
            this.cd.meaningOrigin = MemColumn.MeaningOrigin.USER;
            MeaningDetector type = TypeInferrer2.this.basicMeaningsService.buildSingleDetector(this.forcedMeaning);
            DataTypeMatch match = new DataTypeMatch();
            match.rowStatus = new byte[this.table.rows.size()];
            match.type = type;
            match.nbEmpty = this.nbEmpty;
            for (int li = 0; li < lookupOn; ++li) {
                int rowIdx = this.notEmptyList.get(li);
                MemRow row = this.table.rows.get(rowIdx);
                String value = row.get(this.cd);
                assert (value != null);
                double score = type.detects(value);
                match.totalDetectionScore += score;
                if (score > 0.0) {
                    match.rowStatus[rowIdx] = 1;
                    ++match.nbParses;
                } else {
                    match.rowStatus[rowIdx] = 2;
                    ++match.nbFails;
                }
                if (!this.computeoutputSchemaCol) continue;
                this.storageTypeInferer.invalidateStorageTypes(value);
            }
            match.nbFails = (int)((double)match.nbFails / lookupRatio);
            match.nbParses = (int)((double)match.nbParses / lookupRatio);
            match.totalDetectionScore /= lookupRatio;
            this.cd.candidateTypes.add(match);
            this.cd.selectedType = match;
            long mainDone = System.currentTimeMillis();
            this.computeOutputSchema();
            long schemaDone = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.infoV("DONE: VERIF column=%s notEmpty=%d shuf=%d main=%d schema=%d", new Object[]{this.cd.getName(), nbCharsDone - colStart, shuffleDone - nbCharsDone, mainDone - shuffleDone, schemaDone - mainDone});
            }
            return null;
        }
    }

    class InferColumnHandler
    extends ColumnHandlerBase
    implements Callable<Void> {
        String tableCacheKey;
        public static final int PROBE_NB_ROWS = 100;
        public static final double PROBE_MIN_OK_RATIO = 0.2;
        int pCacheHit;
        int pCacheMiss;

        InferColumnHandler(InferenceContext icontext, String tableCacheKey, MemTable table, MemColumn cd, boolean computeOutputSchemaCol, DataService.ShakerRecipeSchemaColumn currentSchemaCol) {
            this.icontext = icontext;
            this.tableCacheKey = tableCacheKey + "_" + computeOutputSchemaCol;
            this.table = table;
            this.cd = cd;
            this.computeoutputSchemaCol = computeOutputSchemaCol;
            this.currentSchemaCol = currentSchemaCol;
        }

        private void fillLists(List<MeaningDetector> types, List<DataTypeMatch> matches) {
            for (int i = 0; i < types.size(); ++i) {
                DataTypeMatch dtm = new DataTypeMatch();
                dtm.type = types.get(i);
                dtm.rowStatus = new byte[this.table.rows.size()];
                dtm.nbEmpty = this.nbEmpty;
                matches.add(dtm);
            }
        }

        private void normalSetData(List<DataTypeMatch> matches, double score, int rowIdx, int i) {
            if (score > 0.0) {
                matches.get((int)i).rowStatus[rowIdx] = 1;
                ++matches.get((int)i).nbParses;
            } else {
                matches.get((int)i).rowStatus[rowIdx] = 2;
                ++matches.get((int)i).nbFails;
            }
            matches.get((int)i).totalDetectionScore += score;
        }

        private List<MeaningDetector> probe() throws Exception {
            List<MeaningDetector> allTypes = TypeInferrer2.this.basicMeaningsService.buildDetectableDetectors();
            int[] nbOK = new int[allTypes.size()];
            int nbProbe = this.nbNotEmpty > 100 ? 100 : this.nbNotEmpty;
            int probeMinOK = (int)((double)nbProbe * 0.2);
            assert (nbProbe <= this.notEmptyList.size());
            for (int i = 0; i < nbProbe; ++i) {
                MemRow row = this.table.rows.get(this.notEmptyList.get(i));
                String value = row.get(this.cd);
                if (value == null) {
                    throw new Error("col=" + this.cd.getName() + " row=" + this.notEmptyList.get(i) + " EMPTY ? ");
                }
                for (int t = 0; t < allTypes.size(); ++t) {
                    MeaningDetector meaningDetector = allTypes.get(t);
                    try {
                        double score = meaningDetector.detects(value);
                        if (!(score > 0.01)) continue;
                        int n = t;
                        nbOK[n] = nbOK[n] + 1;
                        continue;
                    }
                    catch (RuntimeException e) {
                        logger.warn((Object)String.format("Unable to detect value '%s' for meaning type %s", value, meaningDetector.getClass().getSimpleName()), (Throwable)e);
                    }
                }
            }
            ArrayList<MeaningDetector> selected = new ArrayList<MeaningDetector>();
            for (int t = 0; t < allTypes.size(); ++t) {
                if (nbOK[t] <= probeMinOK) continue;
                selected.add(allTypes.get(t));
            }
            return selected;
        }

        private Integer getMeaningDetectorIdx(List<DataTypeMatch> list, String meaningId) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get((int)i).type.getMeaningId().equals(meaningId)) continue;
                return i;
            }
            return null;
        }

        private void removeMatch(List<DataTypeMatch> matches, String meaningId) {
            Integer idx = this.getMeaningDetectorIdx(matches, meaningId);
            if (idx != null) {
                matches.remove(idx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long colStart = System.currentTimeMillis();
            this.handleNbChars(true);
            long countDone = System.currentTimeMillis();
            this.notEmptyList.shuffle(this.r);
            long shuffleDone = System.currentTimeMillis();
            ColumnCacheEntry cacheEntry = null;
            String colCacheKey = null;
            if (this.tableCacheKey != null) {
                colCacheKey = this.tableCacheKey + "--" + this.cd.getName();
                Cache<String, ColumnCacheEntry> cache = TypeInferrer2.this.columnsCache;
                synchronized (cache) {
                    cacheEntry = (ColumnCacheEntry)TypeInferrer2.this.columnsCache.getIfPresent((Object)colCacheKey);
                }
                if (cacheEntry == null) {
                    cacheEntry = new ColumnCacheEntry();
                    cache = TypeInferrer2.this.columnsCache;
                    synchronized (cache) {
                        TypeInferrer2.this.columnsCache.put((Object)colCacheKey, (Object)cacheEntry);
                    }
                }
            } else {
                cacheEntry = new ColumnCacheEntry();
            }
            int lookupOn = 0;
            double lookupRatio = 0.0;
            if (this.nbNotEmpty < 2000) {
                lookupOn = this.nbNotEmpty;
                lookupRatio = 1.0;
            } else {
                lookupOn = 2000 + (int)((double)(this.nbNotEmpty - 2000) * 0.2);
                lookupRatio = (double)lookupOn / (double)this.nbNotEmpty;
            }
            Hasher hasher = Hashing.goodFastHash((int)32).newHasher();
            for (int li = 0; li < lookupOn; ++li) {
                int rowIdx = this.notEmptyList.get(li);
                MemRow row = this.table.rows.get(rowIdx);
                String value = row.get(this.cd);
                hasher.putString((CharSequence)value, StandardCharsets.UTF_8);
                hasher.putString((CharSequence)(row.isDeleted() ? "1" : "0"), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)String.valueOf(rowIdx), StandardCharsets.UTF_8);
            }
            hasher.putString((CharSequence)String.valueOf(this.notEmptyList.size()), StandardCharsets.UTF_8);
            hasher.putString((CharSequence)String.valueOf(this.nbNotDeletedRows), StandardCharsets.UTF_8);
            String hash = hasher.hash().toString();
            long hashDone = System.currentTimeMillis();
            ArrayList<DataTypeMatch> matches = new ArrayList<DataTypeMatch>();
            ArrayList probedTypes = null;
            if (this.cd.forcedType != null) {
                this.cd.meaningOrigin = MemColumn.MeaningOrigin.PROCESSOR;
                cacheEntry = null;
            } else {
                this.cd.meaningOrigin = MemColumn.MeaningOrigin.INFERENCE;
            }
            if (hash == null || cacheEntry == null || !hash.equals(cacheEntry.recordedHash)) {
                var18_19 = this.icontext;
                synchronized (var18_19) {
                    ++this.icontext.columnCacheMiss;
                }
                if (this.cd.forcedType != null) {
                    this.cd.candidateTypes.clear();
                    probedTypes = Lists.newArrayList((Object[])new MeaningDetector[]{this.cd.forcedType});
                } else {
                    probedTypes = this.probe();
                }
                var18_19 = this.icontext;
                synchronized (var18_19) {
                    this.icontext.totalProbedTypes += probedTypes.size();
                }
                this.fillLists(probedTypes, matches);
            } else {
                var18_19 = this.icontext;
                synchronized (var18_19) {
                    ++this.icontext.columnCacheHits;
                }
            }
            long probeDone = System.currentTimeMillis();
            if (hash == null || cacheEntry == null || !hash.equals(cacheEntry.recordedHash)) {
                Integer idx;
                LongMeaning lm;
                assert (probedTypes != null);
                for (int li = 0; li < lookupOn; ++li) {
                    if ((li & 0x7F) == 0 && Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    int rowIdx = this.notEmptyList.get(li);
                    row = this.table.rows.get(rowIdx);
                    value = ((MemRow)row).get(this.cd);
                    assert (value != null);
                    for (int i = 0; i < probedTypes.size(); ++i) {
                        double score = ((MeaningDetector)probedTypes.get(i)).detects(value);
                        this.normalSetData(matches, score, rowIdx, i);
                    }
                    if (!this.computeoutputSchemaCol) continue;
                    this.storageTypeInferer.invalidateStorageTypes(value);
                }
                for (DataTypeMatch dtm : matches) {
                    dtm.nbFails = (int)((double)dtm.nbFails / lookupRatio);
                    dtm.nbParses = (int)((double)dtm.nbParses / lookupRatio);
                    dtm.totalDetectionScore /= lookupRatio;
                }
                Integer integerIdx = this.getMeaningDetectorIdx(matches, "LongMeaning");
                Integer decimalIdx = this.getMeaningDetectorIdx(matches, "DoubleMeaning");
                if (integerIdx != null && decimalIdx != null) {
                    DataTypeMatch integerDtm = (DataTypeMatch)matches.get(integerIdx);
                    DataTypeMatch decimalDtm = (DataTypeMatch)matches.get(decimalIdx);
                    assert (integerDtm.type.getMeaningId().equals("LongMeaning"));
                    assert (decimalDtm.type.getMeaningId().equals("DoubleMeaning"));
                    if (integerDtm.nbParses > 0 && integerDtm.nbFails > 0 && decimalDtm.nbParses > 0 && decimalDtm.nbFails == 0) {
                        logger.info((Object)("col=" + this.cd.getName() + " Rejecting integer because decimal has 0 fail"));
                        matches.remove(integerIdx);
                    }
                }
                if ((integerIdx = this.getMeaningDetectorIdx(matches, "LongMeaning")) != null) {
                    DataTypeMatch integerDtm = (DataTypeMatch)matches.get(integerIdx);
                    if (integerDtm.nbParses > 0 && integerDtm.nbFails == 0 && (lm = (LongMeaning)integerDtm.type).hasZeroLeadingIntegers()) {
                        matches.remove(integerIdx);
                        this.removeMatch(matches, "DoubleMeaning");
                        this.removeMatch(matches, "FrenchDoubleMeaning");
                        if (this.computeoutputSchemaCol) {
                            this.storageTypeInferer.rejectAutoDetection(Type.TINYINT, Type.SMALLINT, Type.INT, Type.BIGINT, Type.FLOAT, Type.DOUBLE);
                            if (cacheEntry != null) {
                                cacheEntry.rejectedStorageTypesForAutodetection.addAll(this.storageTypeInferer.getRejectedForAutodetection());
                            }
                        }
                    }
                }
                if ((idx = this.getMeaningDetectorIdx(matches, "Boolean")) != null) {
                    DataTypeMatch boolDtm = (DataTypeMatch)matches.get(idx);
                    if (boolDtm.nbParses > 0 && boolDtm.nbFails == 0 && !(lm = (Boolean)boolDtm.type).hasBothPositiveAndNegative() && lm.hasNonLiteralTrueOrFalseValues()) {
                        logger.info((Object)("col=" + this.cd.getName() + " Rejecting boolean because it has either only positive or only negative values that aren't only literal 'true' or 'false' values"));
                        matches.remove(idx);
                        if (this.computeoutputSchemaCol) {
                            this.storageTypeInferer.rejectAutoDetection(Type.BOOLEAN);
                            if (cacheEntry != null) {
                                cacheEntry.rejectedStorageTypesForAutodetection.addAll(this.storageTypeInferer.getRejectedForAutodetection());
                            }
                        }
                    }
                }
                this.cd.candidateTypes.addAll(matches);
                if (cacheEntry != null) {
                    cacheEntry.recordedHash = hash;
                    cacheEntry.recordedMatches = matches;
                }
            } else {
                this.cd.candidateTypes.addAll(cacheEntry.recordedMatches);
                if (this.computeoutputSchemaCol) {
                    for (int li = 0; li < lookupOn; ++li) {
                        int rowIdx = this.notEmptyList.get(li);
                        row = this.table.rows.get(rowIdx);
                        value = ((MemRow)row).get(this.cd);
                        assert (value != null);
                        this.storageTypeInferer.invalidateStorageTypes(value);
                    }
                    for (Type t : cacheEntry.rejectedStorageTypesForAutodetection) {
                        this.storageTypeInferer.rejectAutoDetection(t);
                    }
                }
            }
            long mainDone = System.currentTimeMillis();
            if (this.cd.forcedType != null) {
                logger.info((Object)("Forced on " + String.valueOf(this.cd)));
                assert (this.cd.candidateTypes.size() == 1);
                this.cd.selectedType = this.cd.candidateTypes.get(0);
            } else {
                Collections.sort(this.cd.candidateTypes);
                for (DataTypeMatch candidate : this.cd.candidateTypes) {
                    if (candidate.nbParses == 0 && candidate.nbFails == 0) {
                        this.cd.selectedType = candidate;
                        break;
                    }
                    if (!((double)candidate.nbParses / (double)(candidate.nbFails + 1) > 0.2)) continue;
                    this.cd.selectedType = candidate;
                    break;
                }
            }
            long selectDone = System.currentTimeMillis();
            this.computeOutputSchema();
            long schemaDone = System.currentTimeMillis();
            InferenceContext inferenceContext = this.icontext;
            synchronized (inferenceContext) {
                this.icontext.totalTime += schemaDone - colStart;
                this.icontext.detectTime += schemaDone - hashDone;
                this.icontext.hashTime += hashDone - colStart;
                this.icontext.probeTime += probeDone - hashDone;
            }
            if (logger.isDebugEnabled()) {
                logger.infoV("DONE: column=%s lookup=%d empty=%d notEmpty=%d pcacheHit=%d pcacheMiss=%d count=%d shuf=%d hash=%d probe=%d main=%d select=%d schema=%d", new Object[]{this.cd.getName(), lookupOn, this.nbEmpty, this.nbNotEmpty, this.pCacheHit, this.pCacheMiss, countDone - colStart, shuffleDone - countDone, hashDone - shuffleDone, probeDone - hashDone, mainDone - hashDone, selectDone - mainDone, schemaDone - selectDone});
            }
            return null;
        }
    }

    public static class NbCharESSearchColumnHandler
    extends ColumnHandlerBase
    implements Callable<Void> {
        public NbCharESSearchColumnHandler(MemTable table, MemColumn cd) {
            this.table = table;
            this.cd = cd;
        }

        @Override
        public Void call() throws Exception {
            this.handleNbChars(false);
            return null;
        }
    }

    private static class ColumnHandlerBase {
        protected MemTable table;
        protected MemColumn cd;
        protected int nbEmpty;
        protected int nbNotEmpty;
        protected Random r = new Random(42L);
        protected TIntArrayList notEmptyList;
        protected int nbNotDeletedRows;
        protected InferenceContext icontext;
        boolean computeoutputSchemaCol;
        DataService.ShakerRecipeSchemaColumn currentSchemaCol;
        ColumnStorageTypeInferer storageTypeInferer = new ColumnStorageTypeInferer();

        private ColumnHandlerBase() {
        }

        protected void handleNbChars(boolean withTextDetect) {
            DataTypeMatch gtm = null;
            int nbRows = this.table.rows.size();
            if (withTextDetect) {
                gtm = new DataTypeMatch();
                gtm.type = new Text();
                gtm.rowStatus = new byte[this.table.rows.size()];
            }
            long totalChars = 0L;
            long maxChars = 0L;
            int colIndex = this.cd.index;
            this.notEmptyList = new TIntArrayList(nbRows);
            for (int rowIdx = 0; rowIdx < nbRows; ++rowIdx) {
                int len;
                MemRow mr = this.table.rows.get(rowIdx);
                int n = len = colIndex >= mr.cellOffsets.length ? 0 : mr.cellLengths[colIndex];
                if ((long)len > maxChars) {
                    maxChars = len;
                }
                totalChars += (long)len;
                if (mr.isDeleted()) continue;
                ++this.nbNotDeletedRows;
                if (len > 0) {
                    ++this.nbNotEmpty;
                    this.notEmptyList.add(rowIdx);
                    if (!withTextDetect) continue;
                    assert (gtm != null);
                    ++gtm.nbParses;
                    gtm.rowStatus[rowIdx] = 1;
                    gtm.totalDetectionScore += 0.01;
                    continue;
                }
                ++this.nbEmpty;
                if (!withTextDetect) continue;
                assert (gtm != null);
                ++gtm.nbEmpty;
                gtm.rowStatus[rowIdx] = 3;
            }
            if (withTextDetect) {
                this.cd.candidateTypes.add(gtm);
            }
            maxChars = Math.max((long)(this.cd.getName().length() + 5), maxChars);
            long avgChars = (long)Math.ceil((double)(totalChars += (long)(this.cd.getName().length() + 5)) / (double)(this.table.rows.size() + 1));
            maxChars = Math.min(maxChars, 45L);
            assert (avgChars > 0L);
            this.cd.ncharsToShow = (double)maxChars / (double)avgChars > 2.0 ? (int)((maxChars + avgChars) / 2L) : (int)maxChars;
        }

        protected void computeOutputSchema() {
            if (this.computeoutputSchemaCol) {
                EnumSet<Type> storableAndDetectable = this.storageTypeInferer.getStillStorableAndDetectable();
                EnumSet<Type> storable = this.storageTypeInferer.getStillStorable();
                logger.info((Object)("Computing output schema column for " + this.cd.getName() + " storable " + String.valueOf(storable) + " detectable " + String.valueOf(storableAndDetectable)));
                if (this.currentSchemaCol == null) {
                    this.cd.recipeSchemaColumn = new DataService.ShakerRecipeSchemaColumn();
                    this.cd.recipeSchemaColumn.column = new SchemaColumn(this.cd.getName(), null);
                } else {
                    this.cd.recipeSchemaColumn = this.currentSchemaCol;
                }
                assert (this.cd.recipeSchemaColumn.column != null);
                if (!this.cd.recipeSchemaColumn.persistent) {
                    Type[] fromBestToWorst = ColumnStorageTypeInferer.getFromBestToWorst();
                    if (this.nbNotEmpty == 0) {
                        this.cd.recipeSchemaColumn.column.setType(Type.STRING);
                    } else {
                        if (!"JSONArrayMeaning".equals(this.cd.selectedType.type.getMeaningId())) {
                            storable.remove(Type.ARRAY);
                            storableAndDetectable.remove(Type.ARRAY);
                        }
                        if (!"JSONObjectMeaning".equals(this.cd.selectedType.type.getMeaningId())) {
                            storable.remove(Type.MAP);
                            storableAndDetectable.remove(Type.MAP);
                            storable.remove(Type.OBJECT);
                            storableAndDetectable.remove(Type.OBJECT);
                        }
                        if (this.cd.meaningOrigin == MemColumn.MeaningOrigin.USER && this.cd.selectedType != null && "Text".equals(this.cd.selectedType.type.getMeaningId())) {
                            this.cd.recipeSchemaColumn.column.setType(Type.STRING);
                        } else {
                            for (Type t : fromBestToWorst) {
                                if (!storableAndDetectable.contains(t)) continue;
                                this.cd.recipeSchemaColumn.column.setType(t);
                                break;
                            }
                        }
                    }
                }
                this.cd.recipeSchemaColumn.storableAs = new HashMap<String, java.lang.Boolean>();
                if (this.nbNotEmpty == 0) {
                    this.cd.recipeSchemaColumn.storableAs.put(Type.STRING.getName(), true);
                } else {
                    for (Type t : storable) {
                        if (!storable.contains(t)) continue;
                        this.cd.recipeSchemaColumn.storableAs.put(t.getName(), true);
                    }
                }
                this.cd.recipeSchemaColumn.deleted = !this.table.hasNonDeletedColumn(this.cd.getName());
            }
        }
    }

    static class ColumnCacheEntry {
        String recordedHash;
        List<DataTypeMatch> recordedMatches = new ArrayList<DataTypeMatch>();
        EnumSet<Type> rejectedStorageTypesForAutodetection = EnumSet.noneOf(Type.class);

        ColumnCacheEntry() {
        }
    }
}

