/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractGeometryMeaning;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class GeoPoint
extends AbstractGeometryMeaning {
    public static final Pattern ISO6709_PTN = Pattern.compile("(\\d\\d)\u00b0(\\d\\d)'(\\d+[,.]\\d+)\"([NS])\\s+(\\d\\d)\u00b0(\\d\\d)'(\\d+[,.]\\d+)\"([EW]).*");
    public static final Pattern WKT_PTN = Pattern.compile("POINT\\s*\\((-?\\d+(?:\\.\\d+)?)\\s+(-?\\d+(?:\\.\\d+)?)\\)");
    public static final Pattern COUPLE_PTN = Pattern.compile("\\(['\"]?(-?\\d+(?:[\\.,]\\d+)?)['\"]?\\s*,\\s*['\"]?(-?\\d+(?:[\\.,]\\d+)?)['\"]?\\)");
    private static ThreadLocal<DecimalFormat> latitudeLongitudeFormat = new ThreadLocal();
    GeometryFactory factory4326 = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);

    public static DecimalFormat getLatitudeLongitudeFormat() {
        DecimalFormat format = latitudeLongitudeFormat.get();
        if (format == null) {
            DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols();
            otherSymbols.setDecimalSeparator('.');
            format = new DecimalFormat("#");
            format.setMaximumFractionDigits(20);
            format.setMinimumIntegerDigits(1);
            format.setGroupingUsed(false);
            format.setDecimalFormatSymbols(otherSymbols);
            latitudeLongitudeFormat.set(format);
        }
        return format;
    }

    private static Double parseDouble(String s) {
        String sNormalize = s.replace(",", ".");
        return Double.valueOf(sNormalize);
    }

    private static Coords fromMatch(Matcher m) {
        if (m.groupCount() != 2) {
            return null;
        }
        Double x = GeoPoint.parseDouble(m.group(1));
        Double y = GeoPoint.parseDouble(m.group(2));
        return new Coords(x, y);
    }

    public static Coords convert(String val) {
        Matcher m;
        if (val == null || val.length() < 6 || val.length() > 450) {
            return null;
        }
        if (val.charAt(0) == '(' && (m = COUPLE_PTN.matcher(val)).matches()) {
            return GeoPoint.fromMatch(m);
        }
        if (val.length() < 10) {
            return null;
        }
        m = WKT_PTN.matcher(val);
        if (m.matches()) {
            Double x = GeoPoint.parseDouble(m.group(1));
            Double y = GeoPoint.parseDouble(m.group(2));
            return new Coords(y, x);
        }
        if (val.length() < 22) {
            return null;
        }
        m = ISO6709_PTN.matcher(val);
        if (!m.matches()) {
            return null;
        }
        return GeoPoint.interpretISO6709(m);
    }

    private static double convertSexagesimal(int degree, int minutes, double seconds) {
        return (double)degree + (double)minutes / 60.0 + seconds / 3600.0;
    }

    private static Coords interpretISO6709(Matcher m) {
        String latDegStr = m.group(1);
        int latDeg = Integer.valueOf(latDegStr);
        String latMinStr = m.group(2);
        int latMin = Integer.valueOf(latMinStr);
        String latSecStr = m.group(3).replace(",", ".");
        double latSec = Double.valueOf(latSecStr);
        String NS = m.group(4);
        double latitude = GeoPoint.convertSexagesimal(latDeg, latMin, latSec);
        if (NS.equalsIgnoreCase("S")) {
            latitude = -latitude;
        }
        String longDegStr = m.group(5);
        int longDeg = Integer.valueOf(longDegStr);
        String longMinStr = m.group(6);
        int longMin = Integer.valueOf(longMinStr);
        String longSecStr = m.group(7);
        double longSec = Double.valueOf(longSecStr);
        String EW = m.group(8);
        double longitude = GeoPoint.convertSexagesimal(longDeg, longMin, longSec);
        if (EW.equalsIgnoreCase("W")) {
            longitude = -longitude;
        }
        return new Coords(latitude, longitude);
    }

    public double detects(String val) {
        Matcher m;
        if ((val = val.trim()) == null || val.length() < 6 || val.length() > 450) {
            return 0.0;
        }
        if (val.charAt(0) == '(' && (m = COUPLE_PTN.matcher(val)).matches()) {
            return 0.8;
        }
        if (val.length() < 10) {
            return 0.0;
        }
        m = WKT_PTN.matcher(val);
        if (m.matches()) {
            return 0.9;
        }
        if (val.length() < 22) {
            return 0.0;
        }
        m = ISO6709_PTN.matcher(val);
        if (m.matches()) {
            return 0.9;
        }
        return 0.0;
    }

    @Override
    public Geometry toGeometry(String val) {
        Coords c2 = GeoPoint.convert(val);
        return c2 == null ? null : this.factory4326.createPoint(new Coordinate(c2.longitude, c2.latitude));
    }

    public static class Coords {
        public final double latitude;
        public final double longitude;

        public Coords(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public String toString() {
            return "Coords(" + this.latitude + ", " + this.longitude + ")";
        }

        public String toWKT() {
            DecimalFormat fmt = GeoPoint.getLatitudeLongitudeFormat();
            return "POINT(" + fmt.format(this.longitude) + " " + fmt.format(this.latitude) + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Coords coords = (Coords)o;
            if (Double.compare(coords.latitude, this.latitude) != 0) {
                return false;
            }
            return Double.compare(coords.longitude, this.longitude) == 0;
        }

        public boolean within(Coords other, double meter) {
            double dlatInMeter = (other.latitude - this.latitude) * 3600.0 * 30.92;
            double dlongInMeter = (other.longitude - this.longitude) * 3600.0 * 30.92;
            return dlatInMeter * dlatInMeter + dlongInMeter * dlongInMeter < meter * meter;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.latitude);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.longitude);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

