/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public abstract class HiveLikeSQLDialect
extends GenericSQLDialect {
    private static Pattern validIdentifierPattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    protected final ThreadLocal<SimpleDateFormat> localParser = new ThreadLocal();

    protected void ensureHiveThreadLocalsAreHere() {
        if (this.localParser.get() == null) {
            this.localParser.set(new SimpleDateFormat("yyyy-MM-dd"));
        }
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public String getIdentifierQuoteChar() {
        return "`";
    }

    @Override
    public String quoteString(String str) {
        String sep = this.getStringQuoteChar();
        return sep + (str == null ? null : str.replaceAll("(?=['\\\\])", "\\\\")) + sep;
    }

    @Override
    public String quoteDate(String str) {
        return "CAST(CONCAT(" + this.quoteString(str) + ", ' +00:00') AS TIMESTAMP)";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "TO_DATE(" + this.quoteString(str) + ")";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public boolean needsBackslashDoubling() {
        return true;
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TABLE " + this.getQuotedTableFullName(table) + " STORED AS PARQUET AS " + selectExpr};
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") STORED AS PARQUET ";
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 91: {
                if (dssType == Type.DATE) {
                    Date dt;
                    this.ensureThreadLocalsAreHere();
                    this.ensureHiveThreadLocalsAreHere();
                    SimpleDateFormat dateParser = this.localParser.get();
                    String dateStr = rs2.getString(colIdx);
                    if (StringUtils.isBlank((String)dateStr)) {
                        return null;
                    }
                    TimeZone tz = assumedTz != null ? assumedTz.toTimeZone() : TimeZone.getTimeZone("UTC");
                    dateParser.setTimeZone(tz);
                    try {
                        dt = dateParser.parse(dateStr);
                    }
                    catch (ParseException e) {
                        dt = null;
                    }
                    if (dt == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)dt.getTime());
                }
                return rs2.getString(colIdx);
            }
            case 93: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    String tsStr = rs2.getString(colIdx);
                    if (StringUtils.isBlank((String)tsStr)) {
                        return null;
                    }
                    DateTime ts = CSVDeserializer.hiveDateParser.parseDateTime(tsStr);
                    return DKUtils.isoFormatReadableByDateFormat((long)ts.getMillis());
                }
                return rs2.getString(colIdx);
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return false;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "string", new Integer[0]);
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, 4, "int", new Integer[0]);
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    public long getDefaultLimit() {
        return 100000000L;
    }

    protected String dayOfWeekExpression(String expr) {
        return this.modExpression("dayofweek(" + expr + ") + 5", "7");
    }

    @Override
    public String dateonlyPartExpression(String expr, DatePart part) {
        return this.temporalPartExpression(expr, part);
    }

    @Override
    public String datetimenotzPartExpression(String expr, DatePart part) {
        return this.temporalPartExpression(expr, part);
    }

    @Override
    public String datePartExpression(String expr, DatePart part) {
        return this.temporalPartExpression(expr, part);
    }

    protected String temporalPartExpression(String expr, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "DAYOFMONTH(" + expr + ")";
            }
            case DAY_OF_WEEK: {
                return "(1 + " + this.dayOfWeekExpression(expr) + ")";
            }
            case HOUR_OF_DAY: {
                return "HOUR(" + expr + ")";
            }
            case MINUTE_OF_HOUR: {
                return "MINUTE(" + expr + ")";
            }
            case SECOND_OF_MINUTE: {
                return "SECOND(" + expr + ")";
            }
            case MILLISECOND_OF_SECOND: {
                throw new NotImplementedException("Extracting milliseconds of a timestamp is not supported in Hive");
            }
            case MONTH_OF_YEAR: {
                return "MONTH(" + expr + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "UNIX_TIMESTAMP(" + expr + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(UNIX_TIMESTAMP(" + expr + ") * 1000)";
            }
            case WEEK_OF_YEAR: {
                return "WEEKOFYEAR(" + expr + ")";
            }
            case QUARTER_OF_YEAR: {
                return "(((MONTH(" + expr + ") - 1)/3)+1)";
            }
            case YEAR: {
                return "YEAR(" + expr + ")";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Hive", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, true);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    protected String temporalTrunc(String inputDateExpression, DateRounding rounding, boolean isDateOnly) {
        String secondFromEpoch = this.temporalPartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH);
        switch (rounding) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return this.temporalTruncFromSeconds(secondFromEpoch, rounding, isDateOnly);
            }
            case WEEK: {
                return "DATE_SUB(NEXT_DAY(" + inputDateExpression + ", 'mo'), 7)";
            }
            case QUARTER: {
                String yearPartStr = "CAST(" + this.temporalPartExpression(inputDateExpression, DatePart.YEAR) + " AS " + this.typeNameForCastAsString() + ")";
                String truncatedMonthNumber = "(CEIL(" + this.temporalPartExpression(inputDateExpression, DatePart.MONTH_OF_YEAR) + "/3)-1)*3+1";
                String monthZeroPrefix = "CASE WHEN (" + truncatedMonthNumber + "<10) THEN '0' ELSE '' END";
                String truncatedMonthStr = "CAST(" + truncatedMonthNumber + " AS " + this.typeNameForCastAsString() + ")";
                String concatenated = "CONCAT(" + yearPartStr + ",'-'," + monthZeroPrefix + "," + truncatedMonthStr + ",'-01 00:00:00 +00:00')";
                return "CAST(" + concatenated + " AS TIMESTAMP)";
            }
        }
        throw new UnsupportedOperation("Date truncation is not implemented for '" + String.valueOf(rounding) + "'");
    }

    protected String temporalTruncFromSeconds(String secondFromEpoch, DateRounding rounding, boolean isDateOnly) {
        String format = switch (rounding) {
            case DateRounding.YEAR -> "yyyy";
            case DateRounding.MONTH -> "yyyy-MM";
            case DateRounding.DAY -> "yyyy-MM-dd";
            case DateRounding.HOUR -> "yyyy-MM-dd HH";
            case DateRounding.MINUTE -> "yyyy-MM-dd HH:mm";
            case DateRounding.SECOND -> "yyyy-MM-dd HH:mm:ss";
            default -> throw new UnsupportedOperation("Date truncation is not implemented for '" + String.valueOf(rounding) + "'");
        };
        if (isDateOnly) {
            if (format.length() > 10) {
                format = format.substring(0, 10);
            }
            String fixedPart = "0001-01-01".substring(format.length());
            String asTruncatedFormattedDate = "FROM_UNIXTIME(" + secondFromEpoch + ", '" + format + fixedPart + "')";
            return "CAST(" + asTruncatedFormattedDate + " AS DATE)";
        }
        String fixedPart = "0001-01-01 00:00:00 Z".substring(format.length());
        String asTruncatedFormattedDate = "FROM_UNIXTIME(" + secondFromEpoch + ", '" + format + fixedPart + "')";
        return "CAST(" + asTruncatedFormattedDate + " AS TIMESTAMP)";
    }

    @Override
    public boolean canExtractMilliseconds() {
        return false;
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return false;
    }

    protected String modExpression(String op1Expr, String op2Expr) {
        return "PMOD(" + op1Expr + "," + op2Expr + ")";
    }

    protected String trunc(String x) {
        return "IF(" + x + " < 0, CEIL(" + x + "), FLOOR(" + x + "))";
    }

    protected String datePartDiffExpression(String start, String end, DatePart part) {
        return "(" + this.datePartExpression(end, part) + " - " + this.datePartExpression(start, part) + ")";
    }

    protected String monthDiffExpression(String start, String end) {
        String yyyyMMDiff = this.datePartDiffExpression(start, end, DatePart.YEAR) + " * 12 + " + this.datePartDiffExpression(start, end, DatePart.MONTH_OF_YEAR);
        String clippedStart = "from_unixtime(" + this.datePartExpression(start, DatePart.SECOND_FROM_EPOCH) + ", '2000-01-dd HH:mm:ss')";
        String clippedEnd = "from_unixtime(" + this.datePartExpression(end, DatePart.SECOND_FROM_EPOCH) + ", '2000-01-dd HH:mm:ss')";
        return "(" + yyyyMMDiff + ") + (CASE WHEN " + end + " > " + start + " THEN CASE WHEN " + clippedEnd + " < " + clippedStart + " THEN -1 ELSE 0 END ELSE CASE WHEN " + clippedEnd + " > " + clippedStart + " THEN 1 ELSE 0 END END)";
    }

    protected String dateDiff(String end, String start, String unit, Type type) {
        String diffSeconds = "(UNIX_TIMESTAMP(cast(" + end + " as timestamp)) - UNIX_TIMESTAMP(cast(" + start + " as timestamp)))";
        switch (unit) {
            case "YEAR": {
                return this.trunc("(" + this.monthDiffExpression(start, end) + ") / 12");
            }
            case "MONTH": {
                return this.monthDiffExpression(start, end);
            }
            case "WEEK": {
                return this.trunc("(" + diffSeconds + ")/3600/24/7");
            }
            case "DAY": {
                return this.trunc("(" + diffSeconds + ")/3600/24");
            }
            case "HOUR": {
                return this.trunc("(" + diffSeconds + ")/3600");
            }
            case "MINUTE": {
                return this.trunc("(" + diffSeconds + ")/60");
            }
            case "SECOND": {
                return diffSeconds;
            }
        }
        throw new IllegalArgumentException("Unknown datepart: '" + unit + "'");
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.MOD, "%", QueryUtils.Arity.BINARY, 2){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String op1Expr = this.toSQLNoBrackets(args[0]);
                String op2Expr = this.toSQLNoBrackets(args[1]);
                return HiveLikeSQLDialect.this.modExpression(op1Expr, op2Expr);
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.TRUNC, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.PARENTHESES.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLNoBrackets(args[0]);
                return "IF(" + x1 + " < 0, CEIL(" + x2 + "), FLOOR(" + x2 + "))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Type type = Type.DATE;
                if (args[0].outputType != null && args[0].outputType.dssType != null) {
                    type = args[0].outputType.dssType;
                }
                return HiveLikeSQLDialect.this.dateDiff(end, start, unit, type);
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.CONTAINS, "CONTAINS", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.LIKE.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String haystack = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.LIKE.priority);
                QueryAst.Expr[] concatArgs = new QueryAst.Expr[]{new QueryAst.ConstExpr("%"), HiveLikeSQLDialect.this.getEscapeForUnderscoreAndPercent(this.toSQLNoBrackets(args[1])), new QueryAst.ConstExpr("%")};
                String pattern = HiveLikeSQLDialect.this.getOperator(QueryUtils.OperatorType.CONCAT).apply(concatArgs);
                return haystack + " LIKE " + pattern;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.STARTS_WITH, "STARTS_WITH", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.LIKE.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String haystack = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.LIKE.priority);
                QueryAst.Expr[] concatArgs = new QueryAst.Expr[]{HiveLikeSQLDialect.this.getEscapeForUnderscoreAndPercent(this.toSQLNoBrackets(args[1])), new QueryAst.ConstExpr("%")};
                String pattern = HiveLikeSQLDialect.this.getOperator(QueryUtils.OperatorType.CONCAT).apply(concatArgs);
                return haystack + " LIKE " + pattern;
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.RAND, "RAND", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                if (args.length > 2 && args[2] != null) {
                    return "to_utc_timestamp(from_utc_timestamp(" + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[1]) + "), " + this.toSQLNoBrackets(args[2]) + ")";
                }
                if (args.length > 1 && args[1] != null) {
                    return "to_utc_timestamp(" + this.toSQLNoBrackets(args[0]) + ", " + this.toSQLNoBrackets(args[1]) + ")";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = args[0] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[0]).value instanceof String ? HiveLikeSQLDialect.this.quoteString((String)((QueryAst.ConstExpr)args[0]).value) : this.toSQLNoBrackets(args[0]);
                return "CAST(CONCAT(" + ret + ", ' +00:00') AS TIMESTAMP)";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.DEC2HEX, "HEX", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.DEC2HEX, "LOWER(HEX(", "))"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.FACT, "FACTORIAL(CAST(", " AS INTEGER))"));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(INSTR(", ", COALESCE(", ", '')) - 1)", false));
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
    }

    protected QueryAst.InlineExpr getEscapeForUnderscoreAndPercent(String expr) {
        String escapedCaptureGroup = StringEscapeUtils.escapeJava((String)this.captureGroup(1));
        return new QueryAst.InlineExpr("REGEXP_REPLACE(" + expr + ", '([%_])', '\\\\\\\\" + escapedCaptureGroup + "')");
    }

    protected String typeNameForCastAsString() {
        return "STRING";
    }

    @Override
    public String convertToVarchar(String inputExpr, int len) {
        return "CAST((" + inputExpr + ") AS " + this.typeNameForCastAsString() + ")";
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS STRING) = '' THEN NULL when lower(CAST(" + expr + " AS STRING)) rlike '^" + this.booleanTrueValuesRegex + "$' then true else false END";
        }
        String sqlType = this.getSQLType((Type)requestedType, (int)maxLength, (String)expr).sqlDecl.toUpperCase();
        if (sqlType.startsWith("VARCHAR")) {
            sqlType = this.typeNameForCastAsString();
        }
        return "CAST( (" + expr + ") AS " + sqlType + ")";
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 65500;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.BackTickedNoEscapeFinder.META, QuotedPortionFinders.BackslashEscapedSingleQuotedFinder.META, QuotedPortionFinders.BackslashEscapedDoubleQuotedFinder.META};
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.NONE;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    protected Pattern getValidIdentifierPattern() {
        return validIdentifierPattern;
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }
}

