/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class PostgresLikeSQLDialect
extends GenericSQLDialect {
    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public String useUTCTimezone() {
        return "SET TIMEZONE TO 'UTC'";
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression_internal("(" + inputDateExpression + ") AT TIME ZONE 'UTC'", part);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression_internal("(" + inputDateExpression + ")", part);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression_internal("(" + inputDateExpression + ")", part);
    }

    private String datePartExpression_internal(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "FLOOR(EXTRACT(SECOND FROM " + inputDateExpression + "))";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + inputDateExpression + ")::int % 1000";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(WEEK FROM " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "EXTRACT(ISODOW FROM " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM " + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(EXTRACT(EPOCH FROM " + inputDateExpression + ") * 1000)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on PostgreSQL", part));
    }

    private String atGmtTimezone(String dateExpression) {
        return dateExpression + " AT TIME ZONE 'UTC'";
    }

    @Override
    public String quoteDate(String str) {
        return "CAST(" + this.quoteString(str + "+00") + " AS TIMESTAMPTZ)";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATE)";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = this.atGmtTimezone(inputDateExpression);
        switch (rounding) {
            case DAY: {
                return this.atGmtTimezone("date_trunc('DAY'," + dateAtGmt + ")");
            }
            case HOUR: {
                return this.atGmtTimezone("date_trunc('HOUR'," + dateAtGmt + ")");
            }
            case WEEK: {
                return this.atGmtTimezone("date_trunc('WEEK'," + dateAtGmt + ")");
            }
            case MONTH: {
                return this.atGmtTimezone("date_trunc('MONTH'," + dateAtGmt + ")");
            }
            case YEAR: {
                return this.atGmtTimezone("date_trunc('YEAR'," + dateAtGmt + ")");
            }
            case QUARTER: {
                return this.atGmtTimezone("date_trunc('QUARTER'," + dateAtGmt + ")");
            }
            case MINUTE: {
                return this.atGmtTimezone("date_trunc('MINUTE'," + dateAtGmt + ")");
            }
            case SECOND: {
                return this.atGmtTimezone("date_trunc('SECOND'," + dateAtGmt + ")");
            }
        }
        throw new QueryUtils.SQLGenerationException("Datetime with tz trunc with unit '" + rounding.toString() + "' not implemented for " + this.getId());
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "cast(date_trunc('DAY'," + inputDateExpression + ") as DATE)";
            }
            case WEEK: {
                return "cast(date_trunc('WEEK'," + inputDateExpression + ") as DATE)";
            }
            case MONTH: {
                return "cast(date_trunc('MONTH'," + inputDateExpression + ") as DATE)";
            }
            case YEAR: {
                return "cast(date_trunc('YEAR'," + inputDateExpression + ") as DATE)";
            }
            case QUARTER: {
                return "cast(date_trunc('QUARTER'," + inputDateExpression + ") as DATE)";
            }
        }
        throw new QueryUtils.SQLGenerationException("Date only trunc with unit '" + rounding.toString() + "' not implemented for " + this.getId());
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + inputDateExpression + ")";
            }
            case HOUR: {
                return "date_trunc('HOUR'," + inputDateExpression + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + inputDateExpression + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + inputDateExpression + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + inputDateExpression + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + inputDateExpression + ")";
            }
            case MINUTE: {
                return "date_trunc('MINUTE'," + inputDateExpression + ")";
            }
            case SECOND: {
                return "date_trunc('SECOND'," + inputDateExpression + ")";
            }
        }
        throw new QueryUtils.SQLGenerationException("Datetime no tz trunc with unit '" + rounding.toString() + "' not implemented for " + this.getId());
    }

    private String toSeconds(String date) {
        return "(DATE_PART('hour', " + date + " AT TIME ZONE 'UTC') * 3600  + DATE_PART('minute', " + date + " AT TIME ZONE 'UTC') * 60 + DATE_PART('second', " + date + " AT TIME ZONE 'UTC'))";
    }

    private String dateDiff(String part, String start, String end) {
        return "(DATE_PART('" + part + "', " + end + ") - DATE_PART('" + part + "', " + start + "))";
    }

    private String castAsTimeStampUTC(String date) {
        return "(CAST(" + date + " AS TIMESTAMPTZ) AT TIME ZONE 'UTC')";
    }

    protected String dateDiffMonth(String start, String end) {
        return this.dateDiff("year", start, end) + " * 12 + " + this.dateDiff("month", start, end) + " + (CASE WHEN CAST (" + this.dateDiff("day", start, end) + " as INT) < 0 AND " + this.castAsTimeStampUTC(end) + " > " + this.castAsTimeStampUTC(start) + " THEN  -1  ELSE  (CASE WHEN CAST (" + this.dateDiff("day", start, end) + " as INT) > 0 AND " + this.castAsTimeStampUTC(end) + " < " + this.castAsTimeStampUTC(start) + " THEN  1 ELSE    (CASE WHEN CAST (" + this.dateDiff("day", start, end) + " as INT) = 0    THEN      (CASE WHEN CAST ((" + this.toSeconds(end) + " - " + this.toSeconds(start) + ") as INT) < 0  AND " + this.castAsTimeStampUTC(end) + " > " + this.castAsTimeStampUTC(start) + "     THEN -1 ELSE        (CASE WHEN CAST ((" + this.toSeconds(end) + " - " + this.toSeconds(start) + ") as INT) > 0  AND " + this.castAsTimeStampUTC(end) + " < " + this.castAsTimeStampUTC(start) + "          THEN 1 ELSE 0 END)      END)    ELSE 0 END)    END) END)";
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.MOD, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.MOD.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String op1Expr = this.toSQLNoBrackets(args[0]);
                String op2Expr = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.MOD.priority);
                return "CAST(" + op1Expr + " AS NUMERIC) % " + op2Expr;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ROUND, "ROUND", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 1 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (args.length == 2) {
                    String arg1String = this.toSQLNoBrackets(args[0]);
                    String arg2String = this.toSQLNoBrackets(args[1]);
                    return "ROUND(CAST(" + arg1String + " AS NUMERIC), " + arg2String + ")";
                }
                return super.apply(args);
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DATEDIFF, null, QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.PARENTHESES.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.PLUS.priority);
                String start = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.PLUS.priority);
                Type type = Type.DATE;
                if (args[0].outputType != null && args[0].outputType.dssType != null) {
                    type = args[0].outputType.dssType;
                }
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "YEAR": {
                        return "EXTRACT(YEAR FROM AGE(" + end + "," + start + "))";
                    }
                    case "MONTH": {
                        return PostgresLikeSQLDialect.this.dateDiffMonth(start, end);
                    }
                    case "WEEK": {
                        if (type == Type.DATEONLY) {
                            return "TRUNC((" + end + " - " + start + ")/7)";
                        }
                        return "TRUNC(DATE_PART('day', " + end + " - " + start + ")/7)";
                    }
                    case "DAY": {
                        if (type == Type.DATEONLY) {
                            return "(" + end + " - " + start + ")";
                        }
                        return "DATE_PART('day', " + end + " - " + start + ")";
                    }
                    case "HOUR": {
                        return "TRUNC(EXTRACT(EPOCH FROM (" + end + " - " + start + "))/3600)";
                    }
                    case "MINUTE": {
                        return "TRUNC(EXTRACT(EPOCH FROM (" + end + " - " + start + "))/60)";
                    }
                    case "SECOND": {
                        return "EXTRACT(EPOCH FROM (" + end + " - " + start + "))";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Date difference with unit '" + unit + "' not implemented for " + PostgresLikeSQLDialect.this.getId());
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                if (args.length > 2) {
                    return "CAST((" + this.toSQLNoBrackets(args[0]) + " AT TIME ZONE " + this.toSQLNoBrackets(args[1]) + ")  AS TIMESTAMP) AT TIME ZONE " + this.toSQLNoBrackets(args[2]);
                }
                if (args.length > 1 && args[1] != null) {
                    return "CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP) AT TIME ZONE " + this.toSQLNoBrackets(args[1]);
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MEDIAN, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                QueryAst.Expr[] newExprs = new QueryAst.Expr[args.length + 1];
                System.arraycopy(args, 0, newExprs, 0, args.length);
                newExprs[args.length] = new QueryAst.ConstExpr(0.5);
                return PostgresLikeSQLDialect.this.getOperator(QueryUtils.OperatorType.PERCENTILE_CONT).apply(newExprs);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_CONT(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "string_agg", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                String column = this.toSQLNoBrackets(args[0]);
                String separator = null;
                boolean distinct = false;
                if (args.length > 1) {
                    QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                    String string = separator = separatorExpr == null ? null : this.toSQLNoBrackets(separatorExpr);
                }
                if (args.length > 2) {
                    QueryAst.ConstExpr distinctExpr = (QueryAst.ConstExpr)args[2];
                    boolean bl = distinct = distinctExpr == null ? false : (Boolean)distinctExpr.value;
                }
                if (separator == null) {
                    return "string_agg(" + (distinct ? "DISTINCT " : "") + " CAST(" + column + " AS TEXT), null)";
                }
                return "string_agg(" + (distinct ? "DISTINCT " : "") + " CAST(" + column + " AS TEXT), " + separator + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args[0] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[0]).value instanceof String) {
                    String value = (String)((QueryAst.ConstExpr)args[0]).value;
                    return "CAST(" + PostgresLikeSQLDialect.this.quoteString(value + "+00") + " AS TIMESTAMPTZ)";
                }
                String ret = this.toSQLNoBrackets(args[0]);
                return "CAST((" + ret + " || '+00') AS TIMESTAMPTZ)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "STRING_TO_TIMESTAMP", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args[0] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[0]).value instanceof String) {
                    String value = (String)((QueryAst.ConstExpr)args[0]).value;
                    return "CAST(" + PostgresLikeSQLDialect.this.quoteString(value) + " AS TIMESTAMP)";
                }
                String ret = this.toSQLNoBrackets(args[0]);
                return "CAST((" + ret + ") AS TIMESTAMP)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_DATE, "STRING_TO_DATE", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args[0] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[0]).value instanceof String) {
                    String value = (String)((QueryAst.ConstExpr)args[0]).value;
                    return "CAST(" + PostgresLikeSQLDialect.this.quoteString(value) + " AS DATE)";
                }
                String ret = this.toSQLNoBrackets(args[0]);
                return "CAST((" + ret + ") AS DATE)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.EXTRACT_FROM_INTERVAL, "EXTRACT_FROM_INTERVAL", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                DateRounding part;
                this.validateNumberOfParameters(args);
                String date = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                try {
                    part = DateRounding.valueOf((String)unit);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid date part: " + unit, e);
                }
                switch (part) {
                    case SECOND: {
                        return "EXTRACT(EPOCH FROM " + date + ")";
                    }
                    case MINUTE: {
                        return "EXTRACT(MINUTE FROM " + date + ")";
                    }
                    case HOUR: {
                        return "EXTRACT(HOUR FROM " + date + ")";
                    }
                    case DAY: {
                        return "EXTRACT(DAY FROM " + date + ")";
                    }
                    case WEEK: {
                        return "EXTRACT(WEEK FROM " + date + ")";
                    }
                    case MONTH: {
                        return "EXTRACT(MONTH FROM " + date + ")";
                    }
                    case QUARTER: {
                        return "EXTRACT(QUARTER FROM " + date + ")";
                    }
                    case YEAR: {
                        return "EXTRACT(YEAR FROM " + date + ")";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Unreachable");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "(" + input + " ~ " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS TEXT)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = PostgresLikeSQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "TO_DATE(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')::TIMESTAMP";
                    }
                    return "(TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "')::TIMESTAMP AT TIME ZONE '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = PostgresLikeSQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType == Type.DATEONLY || requestedType == Type.DATETIMENOTZ) {
                        return "TO_CHAR(" + input + ",'" + sqlFormat + "')";
                    }
                    return "TO_CHAR((" + input + ") at time zone '" + StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC") + "','" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                String replacement = this.toSQLNoBrackets(args[2]);
                return "REGEXP_REPLACE(" + column + ", " + regex + ", " + replacement + ", 'g')";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LEAST, "LEAST", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs > 0;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                List funcArgs = Lists.newArrayList((Object[])args).stream().map(a -> this.toSQLNoBrackets((QueryAst.Expr)a)).collect(Collectors.toList());
                String least = "LEAST(" + funcArgs.stream().collect(Collectors.joining(", ")) + ")";
                List nullableArgs = Lists.newArrayList((Object[])args).stream().filter(a -> !(a instanceof QueryAst.ConstExpr) || ((QueryAst.ConstExpr)a).value == null).collect(Collectors.toList());
                if (nullableArgs.isEmpty()) {
                    return least;
                }
                return "CASE WHEN " + nullableArgs.stream().map(a -> "(" + this.toSQLNoBrackets((QueryAst.Expr)a) + ") IS NULL").collect(Collectors.joining(" OR ")) + " THEN NULL ELSE " + least + " END";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.GREATEST, "GREATEST", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs > 0;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                List funcArgs = Lists.newArrayList((Object[])args).stream().map(a -> this.toSQLNoBrackets((QueryAst.Expr)a)).collect(Collectors.toList());
                String greatest = "GREATEST(" + funcArgs.stream().collect(Collectors.joining(", ")) + ")";
                List nullableArgs = Lists.newArrayList((Object[])args).stream().filter(a -> !(a instanceof QueryAst.ConstExpr) || ((QueryAst.ConstExpr)a).value == null).collect(Collectors.toList());
                if (nullableArgs.isEmpty()) {
                    return greatest;
                }
                return "CASE WHEN " + nullableArgs.stream().map(a -> "(" + this.toSQLNoBrackets((QueryAst.Expr)a) + ") IS NULL").collect(Collectors.joining(" OR ")) + " THEN NULL ELSE " + greatest + " END";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FACT, "FACTORIAL", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "CAST(FACTORIAL(CAST(" + this.toSQLNoBrackets(args[0]) + " AS INTEGER)) AS INTEGER)";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.TRIM, "BTRIM", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(STRPOS(", ", COALESCE(", ", '')) - 1)", false));
        this.addGenericFunction(QueryUtils.OperatorType.DEC2HEX, "TO_HEX", QueryUtils.Arity.UNARY);
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.PostgresStringLiteralFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META, QuotedPortionFinders.PostgresDollarQuotedLiteralFinder.META};
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "timestamp".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 63;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE && forParsing) {
            throw new IllegalArgumentException("Parsing timezone not implemented in db");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
            if (toEscape.matcher(part.text).matches()) {
                return "\"" + part.text.replace("\"", "\\\\\"") + "\"";
            }
            return part.text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.MONTH) {
            if (part.numeric) {
                return "MM";
            }
            if (part.shortened) {
                return "Mon";
            }
            return "FMMonth";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK) {
            if (part.numeric) {
                return hasIsoDatePart ? "ID" : "D";
            }
            if (part.shortened) {
                return "Dy";
            }
            return "FMDay";
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (forParsing && forParsing && part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE) {
            return SQLCapability.nok("Cannot parse with timezone");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Cannot format to clock hours");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getLogClause(double base, String argument) {
        return this.getLogClauseForSingleArgumentLog(base, argument);
    }

    @Override
    public boolean supportsTransactionalDdl() {
        return true;
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT schemaname, viewname FROM pg_views WHERE viewname LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "schemaname", " AND schemaname NOT IN ('pg_catalog', 'information_schema')");
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }
}

