/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaOptions;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.sql.regex.RegexDatabaseSupport;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public interface SQLDialect {
    public UpsertWriter getUpsertWriter();

    public UpdateSelectWriter getUpdateSelectWriter();

    public UniqueConstraintWriter getUniqueConstraintWriter();

    public MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter();

    default public boolean canInsertAndSelectConcurrently() {
        return true;
    }

    public void setDefaultLengthForSchemaColumn(Schema var1, List<SchemaColumn> var2, InfoMessage.InfoMessages var3);

    public void executePostConnectTasks(SQLConnectionProvider.SQLConnectionData var1, SQLConnectionProvider.SQLConnectionWrapper var2) throws SQLException;

    public DSSTypeSQLMapping getSQLType(SchemaColumn var1, Dataset var2);

    public String getQuotedTableFullName(SQLUtils.SQLTable var1);

    default public String escapeSchemaOrTableNameForJDBCMetadataQuerying(String identifier) {
        return identifier;
    }

    default public SQLUtils.SQLTable postProcessTableFoundThroughJDBCMetadataSearch(SQLUtils.SQLTable input) {
        return input;
    }

    default public String postProcessSchemaPatternForJDBCMetadataSearch(String input) {
        return input;
    }

    public boolean tableExists(AuthCtx var1, SQLConnectionProvider.SQLConnectionData var2, SQLConnectionProvider.SQLConnectionWrapper var3, String var4, String var5, String var6) throws Exception;

    public void fill(PreparedStatement var1, Type var2, int var3, String var4) throws SQLException;

    public void fillWithEmpty(PreparedStatement var1, Dataset var2, Type var3, int var4) throws SQLException;

    public String getValueAsDSSString(ResultSet var1, int var2, int var3, SchemaColumn var4, boolean var5, boolean var6, DateTimeZone var7) throws SQLException;

    public boolean lacksTimezoneInfo(String var1, int var2);

    public String getValueAsSQLString(Type var1, String var2);

    default public String appendLiteralForInsertStatementFromValueAsSQLString(Type type, String valueAsSQLString) {
        if (valueAsSQLString == null) {
            return "NULL";
        }
        return this.quoteString(valueAsSQLString);
    }

    public boolean needsDoubleNormalization();

    public boolean considerTypeTimestampAsDate();

    public long dateToTimeStamp(String var1);

    public String getPartitionFilterClause(Dataset var1, Partition var2);

    public InsertIntoCaster getInsertIntoCaster(@Nullable Dataset var1);

    public String getInsertStatementSQL(String var1, String var2, String var3, List<SchemaColumn> var4) throws SQLException;

    public String getCreateTableStatementSQL(AbstractSQLConnection var1, Dataset var2, InfoMessage.InfoMessages var3, boolean var4);

    public String generateTableStatementSQL(AbstractSQLConnection var1, Dataset var2, InfoMessage.InfoMessages var3, boolean var4);

    public void dropTable(AuthCtx var1, SQLConnectionProvider.SQLConnectionData var2, SQLConnectionProvider.SQLConnectionWrapper var3, SQLUtils.SQLTable var4) throws Exception;

    public void createTableIfNeeded(AuthCtx var1, SQLConnectionProvider.SQLConnectionData var2, SQLConnectionProvider.SQLConnectionWrapper var3, Dataset var4, boolean var5, InfoMessage.InfoMessages var6) throws Exception;

    default public void dropIfNeededAndCreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, Output.WriteMode mode, InfoMessage.InfoMessages messages) throws Exception {
        this.dropIfNeededAndCreateTableOrPartition(authCtx, connData, conn, dataset, partition, mode, false, messages);
    }

    public void dropIfNeededAndCreateTableOrPartition(AuthCtx var1, SQLConnectionProvider.SQLConnectionData var2, SQLConnectionProvider.SQLConnectionWrapper var3, Dataset var4, Partition var5, Output.WriteMode var6, boolean var7, InfoMessage.InfoMessages var8) throws Exception;

    public void dropAndRecreateTableOrPartition(AuthCtx var1, SQLConnectionProvider.SQLConnectionData var2, SQLConnectionProvider.SQLConnectionWrapper var3, Dataset var4, Partition var5, boolean var6, InfoMessage.InfoMessages var7) throws Exception;

    public void prepareTableForWriting(AuthCtx var1, SQLConnectionProvider.SQLConnectionData var2, SQLConnectionProvider.SQLConnectionWrapper var3, Output.WriteMode var4, Dataset var5, Partition var6, boolean var7, InfoMessage.InfoMessages var8) throws Exception;

    public String getLimitedQuery(String var1, long var2);

    public String getLimitedQuery(String var1, long var2, long var4);

    public boolean supportsInDatabaseCharts();

    public boolean supportsResultSetMetadataOnPreparedStatement(String var1);

    public String alterQueryForResultSetMetadataOnPreparedStatement(String var1);

    public ResultSetMetaData getResultSetMetadataOnPreparedStatement(PreparedStatement var1) throws Exception;

    public String extractStatistics(ResultSet var1);

    public boolean supportsDirectSchemaRetrieval();

    public boolean requireDirectSchemaRetrieval(ResultSetMetaData var1) throws SQLException;

    public Schema directRetrieveSchema(ResultSetMetaData var1, SchemaOptions var2) throws IOException;

    public Schema directRetrieveSchema(AuthCtx var1, AbstractSQLConnection var2, String var3, String var4, String var5, SchemaOptions var6) throws IOException, DKUSecurityException, SQLException;

    public Schema directRetrieveSchema(AuthCtx var1, AbstractSQLConnection var2, String var3, SchemaOptions var4) throws IOException, DKUSecurityException, SQLException;

    default public boolean supportsTablePartitionInfoRetrieval() {
        return false;
    }

    default public SchemaReader.TablePartitionInfo retrieveTablePartitionInfo(AuthCtx authCtx, AbstractSQLConnection conn, String catalog, String schema, String table) throws IOException, DKUSecurityException, SQLException {
        throw new UnsupportedOperationException("Table partition info retrieval is not available for this database");
    }

    public String getIdentifierQuoteChar();

    public String getStringQuoteChar();

    public int getIdentifiersMaxLength();

    public int getMaxPossibleVarcharLen();

    public int getDefaultVarcharLen();

    public boolean supportsCommitAndRollback();

    public boolean supportsTransactionalDdl();

    public String booleanRepr(Boolean var1);

    public String timeRange(String var1, String var2);

    public String datePartExpression(String var1, DatePart var2);

    public String dateonlyPartExpression(String var1, DatePart var2);

    public String datetimenotzPartExpression(String var1, DatePart var2);

    public String dateTrunc(String var1, DateRounding var2);

    public String dateonlyTrunc(String var1, DateRounding var2);

    public String datetimenotzTrunc(String var1, DateRounding var2);

    @Deprecated
    public String convertToVarchar(String var1, int var2);

    @Deprecated
    public String convertStringToNumber(String var1);

    public SQLCapability canFormatDate(String var1, boolean var2);

    public boolean canExtractMilliseconds();

    public String quoteIdentifier(String var1);

    public String quoteString(String var1);

    public String quoteDate(String var1);

    public String quoteDateOnly(String var1);

    public String quoteDatetimeNoTz(String var1);

    public boolean needsBackslashDoubling();

    public String captureGroup(int var1);

    default public boolean needsAstTranslationChecking() {
        return false;
    }

    public String getQuotedTableFullName(String var1, String var2, String var3);

    public String getQuotedColumnFullName(String var1, String var2, String var3, String var4);

    public String getInsertIntoInstruction(String var1, String var2, String var3, Schema var4);

    public String getCreateViewInstruction(String var1, String var2, String var3);

    public String getDropViewInstruction(String var1, String var2, String var3);

    public String getLeftoverPipelineViewsQuery(String var1);

    public String getSafeRandomTemporaryTableName(String var1);

    default public boolean supportsBatchUpdates(SQLConnectionProvider.SQLConnectionData connData) {
        return true;
    }

    default public boolean supportsInsertWithPreparedStatement(SQLConnectionProvider.SQLConnectionData connData) {
        return true;
    }

    default public SQLUtils.SQLTable getSafeRandomTemporaryTableName(String catalog, String schema, String prefix, String suffix) {
        return new SQLUtils.SQLTable(null, null, this.getSafeRandomTemporaryTableName(prefix) + suffix);
    }

    public String createTemporaryTable(SQLUtils.SQLTable var1, String var2);

    public String[] createTemporaryTableAs(SQLUtils.SQLTable var1, String var2);

    public String dropTemporaryTable(SQLUtils.SQLTable var1);

    public boolean supportsIndexing();

    public boolean supportsIndexingOnTemporaryTables();

    public String useUTCTimezone();

    public boolean isCatalogAware();

    public boolean isSchemaAware();

    public boolean canSQL99();

    public boolean canStddevAsAnalyticalFunctions();

    public boolean supportsNamedWindows();

    public boolean supportsGreatest();

    public boolean supportsNullsOrdering();

    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities();

    default public RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, long maxRecords, double ratio, Long seed) {
        if (samplingMethod == null) {
            return RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        if ((samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) && maxRecords <= 0L) {
            return RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        if ((samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO_EXACT) && (ratio < 0.0 || ratio > 1.0)) {
            return RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        return this.getRandomSampleClauseLocation(samplingMethod, seed);
    }

    default public RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        return RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    public String getRandomSampleClause(QueryAst.SampleClause var1);

    default public boolean needCast(SchemaColumn col, boolean isDatasetManaged) {
        return false;
    }

    default public boolean integerAggregateCanOverflow() {
        return false;
    }

    default public boolean canCastDSSFormatToTemporal() {
        return false;
    }

    default public ExpressionBuilder cast(SchemaColumn col, ExpressionBuilder eb) {
        return eb;
    }

    default public ExpressionBuilder getAdjustedColumnForTimeCondition(ExpressionBuilder col, SchemaColumn dimensionColumn, DatasetHandler.DatasetParams config, boolean isDatasetManaged) {
        return ExpressionUtils.getAdjustedColumn(col, dimensionColumn, config, isDatasetManaged, this);
    }

    default public String getStringForTimeDimensionValue(TimeDimensionValue timeValue, SchemaColumn dimensionColumn, DatasetHandler.DatasetParams config, boolean isDatasetManaged) {
        return ExpressionUtils.getStringForDimensionValue((DimensionValue)timeValue, dimensionColumn.getType());
    }

    default public boolean mustForceOutputColumnNameOverrides() {
        return false;
    }

    public NaturalJoinSupport getNaturalJoinSupport();

    public boolean isNaturalJoinImplicitlyInner();

    public boolean needsToHaveTrailingSemicolonsRemoved();

    public DefaultUnquotedCase getDefaultUnquotedCaseForTables();

    public RegexSupport regexSupport();

    public boolean supportsNonCapturingGroups();

    public boolean supportsLookAroundExpressions();

    default public boolean supportsCaseInsensitivityRegExp() {
        return false;
    }

    public RegexDatabaseSupport.RegexSupportStatus supportsRegExpReplaceExpressions(String var1, String var2);

    public boolean isValidIdentifier(String var1);

    public boolean hasCaseInsensitiveColumns();

    public boolean hasCaseInsensitiveComparisons();

    public boolean needsTruncateBeforeDropTemporaryTable();

    public String cleanupColumnName(String var1);

    public String applyOperator(QueryUtils.OperatorType var1, QueryAst.Expr ... var2);

    public QueryUtils.AbstractOperator getOperator(QueryUtils.OperatorType var1);

    default public boolean supportsOperator(QueryUtils.OperatorType opType) {
        return this.getOperator(opType) != null;
    }

    public boolean supportsCTEs();

    public boolean requiresColumnNamesInCTEs();

    public boolean requiresStrictTypeComparison();

    default public boolean shouldForceFormatForDateComparison() {
        return false;
    }

    default public boolean shouldForceFormatForDateOnlyComparison() {
        return false;
    }

    public boolean supportsWindowUnboundedFrame();

    public boolean supportsWindowCurrentRowFrame();

    public boolean supportsWindowTimeRangeFrame();

    public boolean supportsWindowNormalRangeFrame();

    public void checkWindowForAnalyticFunction(QueryUtils.OperatorType var1, QueryAst.Window var2);

    public String getCreateIndexStatement(String var1, SQLUtils.SQLTable var2, String var3);

    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders();

    public Splitter getSplitter();

    public void failIfInvalidColumnIdentifier(String var1);

    public String getColumnExpressionForBoolean(String var1);

    public String emptyFromClause();

    public String getDivisionClause(String var1, String var2);

    public String getLogClause(double var1, String var3);

    public LimitMethod getLimitMethod();

    public String limitQueryUsingWhere(long var1);

    default public boolean supportRetrieveTableRowCount() {
        return false;
    }

    default public DatasetRecordCount retrieveTableRowCount(SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLUtils.SQLTable sqlTable) throws SQLException {
        return null;
    }

    public SchemaColumn fromSQLType(String var1, int var2, String var3, int var4, int var5, AbstractSQLDatasetHandler.ReadTemporalMode var6, AbstractSQLDatasetHandler.ReadTemporalMode var7);

    public boolean supportsFromTimezoneNtzOperator();

    public String getId();

    public List<String> getTableTypes(SQLConnectionProvider.SQLConnectionData var1, GetTableTypesReason var2);

    public String generateTableCommentStatementQuery(AbstractSQLDatasetHandler.AbstractSQLConfig var1, String var2, InfoMessage.InfoMessages var3);

    public String generateColumnCommentStatementQuery(AbstractSQLDatasetHandler.AbstractSQLConfig var1, SchemaColumn var2, InfoMessage.InfoMessages var3);

    public boolean supportsWriteSQLComment();

    public String truncateDescription(String var1, String var2, boolean var3, InfoMessage.InfoMessages var4);

    public boolean supportsCommentsInCreateTableStatement();

    public void tryAddCommentToTable(SQLConnectionProvider.SQLConnectionWrapper var1, AbstractSQLDatasetHandler.AbstractSQLConfig var2, String var3, InfoMessage.InfoMessages var4);

    public void tryWriteColumnComments(AuthCtx var1, SQLConnectionProvider.SQLConnectionWrapper var2, AbstractSQLDatasetHandler.AbstractSQLConfig var3, List<SchemaColumn> var4, String var5, InfoMessage.InfoMessages var6);

    public int getMaxTableCommentLengthInChars();

    public int getMaxColumnCommentLengthInChars();

    default public boolean hasAccessToAliasInOrderByCaseStatement() {
        return false;
    }

    default public boolean supportGroupByIndex() {
        return true;
    }

    default public boolean filterWarning(SQLWarning warning) {
        return false;
    }

    default public boolean needSubQueryForConstantInWhereClause() {
        return false;
    }

    default public List<String> getTableTypesForConnectionDump(boolean includeSystemTables) {
        ArrayList browsedTypes = Lists.newArrayList((Object[])new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM", "EXTERNAL_TABLE", "VIRTUAL_VIEW"});
        if (includeSystemTables) {
            browsedTypes.add("SYSTEM TABLE");
        }
        return browsedTypes;
    }

    public static enum RandomSampleClauseLocation {
        NOT_SUPPORTED,
        FROM,
        WHERE,
        ORDER_BY_AND_LIMIT;

    }

    public static enum GetTableTypesReason {
        TABLE_EXISTS,
        LIST_FOR_CATALOG,
        LIST_FOR_EXPLORER;

    }

    public static enum LimitMethod {
        LIMIT,
        TOP,
        WHERE,
        SAMPLE,
        FETCH_FIRST_ROWS_FIRST;

    }

    public static enum RegexSupport {
        NONE,
        BASIC,
        POSIX;

    }

    public static enum DefaultUnquotedCase {
        LOWER,
        UPPER;

    }

    public static enum NaturalJoinSupport {
        NONE,
        ALL,
        INNER_ONLY;

    }

    public static interface MaterializedTemporaryTableWriter {
        public String generateCreateTemp(UpsertSpec var1);

        public String generateTruncateReal(UpsertSpec var1, PartitioningScheme var2);

        public String generateCopy(UpsertSpec var1);

        public String generateDropTemp(UpsertSpec var1);
    }

    public static interface UniqueConstraintWriter {
        public String generateCreate(UpsertSpec var1);

        public String generateDrop(UpsertSpec var1);
    }

    public static interface UpdateSelectWriter {
        public String generate(UpsertSpec var1);
    }

    public static interface UpsertWriter {
        public String generate(UpsertSpec var1);

        public boolean usesIndex();

        public boolean canUpsertConcurrently();
    }

    public static class UpsertSpec {
        public String sourceSelect;
        public String targetSelect;
        public SQLUtils.SQLTable target;
        public SQLUtils.SQLTable temp;
        public List<String> columns = new ArrayList<String>();
        public List<String> keys = new ArrayList<String>();
        public PartitioningScheme scheme = null;
        public SQLUtils.SQLTable index;
        public Dataset targetDataset;
        public ExpressionBuilder sourcePartitionFilter;
        public ExpressionBuilder targetPartitionFilter;
    }

    public static interface InsertIntoCaster {
        public ExpressionBuilder castIfNeeded(ExpressionBuilder var1, SchemaColumn var2);
    }
}

