/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.sql.bigquery.BigQueryAbortedOperationException;
import com.dataiku.dip.sql.bigquery.QueryResult;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpRequestInitializer;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpResponseException;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelib.com.google.api.client.json.JsonFactory;
import com.dataiku.dss.shadelib.com.google.api.client.json.jackson2.JacksonFactory;
import com.dataiku.dss.shadelib.com.google.api.client.util.Data;
import com.dataiku.dss.shadelib.com.google.api.core.ApiClock;
import com.dataiku.dss.shadelib.com.google.api.gax.paging.Page;
import com.dataiku.dss.shadelib.com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.dataiku.dss.shadelib.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.dataiku.dss.shadelib.com.google.api.gax.retrying.RetrySettings;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.Bigquery;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.ConnectionProperty;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.DatasetReference;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.ErrorProto;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.JobReference;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.ProjectList;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameter;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameterType;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryRequest;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryResponse;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.TableDataList;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.TableFieldSchema;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.TableRow;
import com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.TableSchema;
import com.dataiku.dss.shadelib.com.google.cloud.BaseService;
import com.dataiku.dss.shadelib.com.google.cloud.BaseServiceException;
import com.dataiku.dss.shadelib.com.google.cloud.ExceptionHandler;
import com.dataiku.dss.shadelib.com.google.cloud.PageImpl;
import com.dataiku.dss.shadelib.com.google.cloud.RetryHelper;
import com.dataiku.dss.shadelib.com.google.cloud.ServiceOptions;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQuery;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryError;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryException;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryOptions;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryRetryConfig;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryRetryHelper;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.DatasetId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.EmptyTableResult;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldValue;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.FieldValueList;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Job;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.LegacySQLTypeName;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.QueryJobConfiguration;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.QueryParameterValue;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Schema;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableResult;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.dataiku.dss.shadelib.com.google.cloud.http.HttpTransportOptions;
import com.dataiku.dss.shadelib.com.google.common.base.Function;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.threeten.bp.Duration;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;

public class BigQueryRpcClient {
    private static final ExceptionHandler BIGQUERY_EXCEPTION_HANDLER = ExceptionHandler.newBuilder().abortOn(new Class[]{RuntimeException.class}).abortOn(new Class[]{InterruptedException.class}).retryOn(new Class[]{ConnectException.class}).retryOn(new Class[]{UnknownHostException.class}).addInterceptors(new ExceptionHandler.Interceptor[]{BaseService.EXCEPTION_HANDLER_INTERCEPTOR}).build();
    private static final BigQueryRetryConfig DEFAULT_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().retryOnMessage(new String[]{"Exceeded rate limits:"}).retryOnMessage(new String[]{"Job exceeded rate limits:"}).retryOnRegEx(new String[]{".*exceed.*rate.*limit.*"}).build();
    private static final RetrySettings DEFAULT_JOB_WAIT_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(Duration.ofHours((long)12L)).setInitialRetryDelay(Duration.ofSeconds((long)1L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).build();
    private static final String UNABLE_TO_RETRIEVE_THE_LIST_OF_PROJECTS = "Unable to retrieve the list of projects.";
    private final Bigquery bigQuerySpi;
    private final BigQueryOptions options;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.client.native");

    public BigQueryRpcClient(BigQueryOptions options) {
        this.bigQuerySpi = BigQueryRpcClient.buildQuerySpi(options);
        this.options = options;
    }

    public ProjectList listProjects(Long maxResults, String pageToken) {
        try {
            return (ProjectList)this.bigQuerySpi.projects().list().setMaxResults(maxResults).setPageToken(pageToken).execute();
        }
        catch (HttpResponseException e) {
            throw new BigQueryException(e.getStatusCode(), UNABLE_TO_RETRIEVE_THE_LIST_OF_PROJECTS, (Throwable)e);
        }
        catch (IOException e) {
            throw new BigQueryException(0, UNABLE_TO_RETRIEVE_THE_LIST_OF_PROJECTS, (Throwable)e);
        }
    }

    public Page<ProjectList.Projects> listProjects(Long maxResults) {
        ImmutableMap optionsMap = ImmutableMap.of((Object)BigQueryRpc.Option.MAX_RESULTS, (Object)maxResults);
        return this.listProjects((Map<BigQueryRpc.Option, Object>)optionsMap);
    }

    public static boolean isFastQuerySupported(QueryJobConfiguration config) {
        return BooleanUtils.isNotTrue((Boolean)config.dryRun()) && config.getClustering() == null && config.getCreateDisposition() == null && config.getDestinationEncryptionConfiguration() == null && config.getDestinationTable() == null && config.getJobTimeoutMs() == null && config.getMaximumBillingTier() == null && config.getPriority() == null && config.getRangePartitioning() == null && config.getSchemaUpdateOptions() == null && config.getTableDefinitions() == null && config.getTimePartitioning() == null && config.getUserDefinedFunctions() == null && config.getWriteDisposition() == null;
    }

    public QueryResult executeQuery(String projectId, QueryJobConfiguration queryConfig, Long pageSize, @Nullable AtomicBoolean abortFlag) {
        ExecuteQueryResponse response = this.executeQueryWithRetry(projectId, queryConfig, abortFlag);
        if (abortFlag != null && abortFlag.get()) {
            throw new BigQueryAbortedOperationException("Query aborted");
        }
        logger.info((Object)"Processing query response");
        if (response.isComplete()) {
            return this.processCompleteResponse(response);
        }
        logger.info((Object)"Query is still running. Waiting for it to complete.");
        return this.processCompleteResponse(this.waitForQueryResults(response.jobId, pageSize, abortFlag));
    }

    public QueryResult waitForAndReturnResults(Job job, Long pageSize, @Nullable AtomicBoolean abortFlag) {
        return this.processCompleteResponse(this.waitForQueryResults(job.getJobId(), pageSize, abortFlag), job);
    }

    private ExecuteQueryResponse waitForQueryResults(JobId jobId, Long pageSize, final @Nullable AtomicBoolean abortFlag) {
        try {
            ExecuteQueryResponse response = (ExecuteQueryResponse)BigQueryRetryHelper.runWithRetries(() -> this.getQueryResultsWithRetry(jobId, pageSize, abortFlag), (RetrySettings)DEFAULT_JOB_WAIT_SETTINGS, (ResultRetryAlgorithm)new BasicResultRetryAlgorithm<ExecuteQueryResponse>(){

                public boolean shouldRetry(Throwable prevThrowable, ExecuteQueryResponse prevResponse) {
                    return prevResponse != null && !prevResponse.completed && (abortFlag == null || !abortFlag.get());
                }
            }, (ApiClock)this.options.getClock(), (BigQueryRetryConfig)DEFAULT_RETRY_CONFIG);
            if (abortFlag != null && abortFlag.get()) {
                throw new BigQueryAbortedOperationException("Query aborted while waiting for query results");
            }
            return response;
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            if (abortFlag != null && abortFlag.get()) {
                throw new BigQueryAbortedOperationException("Query aborted while waiting for query results");
            }
            throw BigQueryRpcClient.wrapException((RuntimeException)((Object)e));
        }
    }

    private ExecuteQueryResponse getQueryResultsWithRetry(JobId jobId, Long pageSize, AtomicBoolean abortFlag) {
        JobId resolvedJobId = this.resolveJobId(jobId);
        try {
            ImmutableMap optionsMap = pageSize != null ? ImmutableMap.of((Object)BigQueryRpc.Option.MAX_RESULTS, (Object)pageSize) : ImmutableMap.of();
            GetQueryResultsResponse results = (GetQueryResultsResponse)BigQueryRetryHelper.runWithRetries(() -> {
                if (abortFlag != null && abortFlag.get()) {
                    throw new BigQueryAbortedOperationException("Query aborted while waiting for query results");
                }
                return this.getQueryResultsNoRetry(resolvedJobId.getProject(), resolvedJobId.getJob(), resolvedJobId.getLocation(), (Map<BigQueryRpc.Option, Object>)optionsMap);
            }, (RetrySettings)this.options.getRetrySettings(), (ResultRetryAlgorithm)BIGQUERY_EXCEPTION_HANDLER, (ApiClock)this.options.getClock(), (BigQueryRetryConfig)DEFAULT_RETRY_CONFIG);
            return new ExecuteQueryResponse(results);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryRpcClient.wrapException((RuntimeException)((Object)e));
        }
    }

    private TableDataPageFetcher tableDataPageFetcher(TableId table, Schema schema, String cursor) {
        ImmutableMap optionMap = ImmutableMap.of();
        return new TableDataPageFetcher(table, schema, cursor, (Map<BigQueryRpc.Option, Object>)optionMap);
    }

    private QueryResult processCompleteResponse(ExecuteQueryResponse response) {
        return this.processCompleteResponse(response, null);
    }

    private QueryResult processCompleteResponse(ExecuteQueryResponse response, @Nullable Job job) {
        EmptyTableResult tableResult;
        Preconditions.checkArgument((boolean)response.isComplete(), (Object)"Query has not completed yet.");
        if (response.errors != null) {
            throw new BigQueryException(response.errors);
        }
        if (response.pageToken != null) {
            TableId tableId;
            long numRows = response.rows == null ? 0L : (long)response.rows.size();
            logger.info((Object)String.format("Query is complete, and multiple pages are needed to retrieve all rows. Response contains %d rows out of %d", numRows, response.totalRows));
            TableId tableId2 = tableId = job == null ? null : ((QueryJobConfiguration)job.getConfiguration()).getDestinationTable();
            if (tableId == null) {
                logger.info((Object)"Refresh job to get the destination table");
                job = ((BigQuery)this.options.getService()).getJob(response.jobId, new BigQuery.JobOption[0]);
                tableId = ((QueryJobConfiguration)job.getConfiguration()).getDestinationTable();
            }
            TableDataPageFetcher pageFetcher = this.tableDataPageFetcher(tableId, response.schema, response.pageToken);
            TableResult tableResult2 = new TableResult(response.schema, response.totalRows, (Page)new PageImpl((PageImpl.NextPageFetcher)pageFetcher, response.pageToken, response.rows));
            return new QueryResult((BigQuery)this.options.getService(), response.jobId, tableResult2, false, job);
        }
        if (response.totalRows == 0L) {
            logger.info((Object)"Query is complete, but query returned 0 rows");
            tableResult = new EmptyTableResult(response.schema);
        } else {
            logger.info((Object)"Query is complete, with all rows present in the response");
            tableResult = new TableResult(response.schema, response.totalRows, (Page)new PageImpl(null, null, response.rows));
        }
        return new QueryResult((BigQuery)this.options.getService(), response.jobId, (TableResult)tableResult, true, job);
    }

    private ExecuteQueryResponse executeQueryWithRetry(String projectId, QueryJobConfiguration config, AtomicBoolean abortFlag) {
        ExecuteQueryResponse response;
        QueryRequest queryRequestSpi = BigQueryRpcClient.toQueryRequestSpi(config);
        try {
            response = (ExecuteQueryResponse)BigQueryRetryHelper.runWithRetries(() -> {
                if (abortFlag != null && abortFlag.get()) {
                    throw new BigQueryAbortedOperationException("Query aborted");
                }
                return this.executeQueryNoRetry(projectId, queryRequestSpi);
            }, (RetrySettings)this.options.getRetrySettings(), (ResultRetryAlgorithm)BIGQUERY_EXCEPTION_HANDLER, (ApiClock)this.options.getClock(), (BigQueryRetryConfig)DEFAULT_RETRY_CONFIG);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryRpcClient.wrapException((RuntimeException)((Object)e));
        }
        return response;
    }

    private ExecuteQueryResponse executeQueryNoRetry(String projectId, QueryRequest content) {
        try {
            return new ExecuteQueryResponse((QueryResponse)this.bigQuerySpi.jobs().query(projectId, content).execute());
        }
        catch (IOException e) {
            throw new BigQueryException(e);
        }
    }

    private GetQueryResultsResponse getQueryResultsNoRetry(String projectId, String jobId, String location, Map<BigQueryRpc.Option, Object> options) {
        try {
            return (GetQueryResultsResponse)this.bigQuerySpi.jobs().getQueryResults(projectId, jobId).setPrettyPrint(Boolean.valueOf(false)).setLocation(location).setMaxResults((Long)options.get(BigQueryRpc.Option.MAX_RESULTS)).setPageToken((String)options.get(BigQueryRpc.Option.PAGE_TOKEN)).setStartIndex(options.get(BigQueryRpc.Option.START_INDEX) != null ? BigInteger.valueOf((Long)options.get(BigQueryRpc.Option.START_INDEX)) : null).setTimeoutMs((Long)options.get(BigQueryRpc.Option.TIMEOUT)).execute();
        }
        catch (IOException e) {
            throw new BigQueryException(e);
        }
    }

    private JobId resolveJobId(JobId jobId) {
        jobId = jobId.getProject() != null ? jobId : jobId.toBuilder().setProject(this.options.getProjectId()).build();
        jobId = jobId.getLocation() != null ? jobId : jobId.toBuilder().setLocation(this.options.getLocation()).build();
        return jobId;
    }

    private Page<ProjectList.Projects> listProjects(Map<BigQueryRpc.Option, Object> optionsMap) {
        try {
            ProjectList result = (ProjectList)RetryHelper.runWithRetries(() -> this.listProjectsRpcNoRetry((Map<BigQueryRpc.Option, Object>)optionsMap), (RetrySettings)this.options.getRetrySettings(), (ResultRetryAlgorithm)BIGQUERY_EXCEPTION_HANDLER, (ApiClock)this.options.getClock());
            String cursor = result.getNextPageToken();
            ImmutableMap pageOptionMap = Strings.isNullOrEmpty((String)cursor) ? optionsMap : ImmutableMap.of();
            List projects = result.getProjects();
            if (projects == null) {
                projects = Collections.emptyList();
            }
            return new PageImpl((PageImpl.NextPageFetcher)new ProjectDataPageFetcher(cursor, (Map<BigQueryRpc.Option, Object>)pageOptionMap), cursor, projects);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryRpcClient.wrapException((RuntimeException)((Object)e));
        }
    }

    private ProjectList listProjectsRpcNoRetry(Map<BigQueryRpc.Option, Object> options) {
        try {
            return (ProjectList)this.bigQuerySpi.projects().list().setPrettyPrint(Boolean.valueOf(false)).setMaxResults((Long)options.get(BigQueryRpc.Option.MAX_RESULTS)).setPageToken((String)options.get(BigQueryRpc.Option.PAGE_TOKEN)).execute();
        }
        catch (IOException e) {
            throw new BigQueryException(e);
        }
    }

    private static QueryRequest toQueryRequestSpi(QueryJobConfiguration jobConf) {
        QueryRequest request = new QueryRequest();
        if (jobConf.getConnectionProperties() != null) {
            request.setConnectionProperties(jobConf.getConnectionProperties().stream().map(property -> {
                ConnectionProperty properties = new ConnectionProperty();
                properties.setKey(property.getKey());
                properties.setValue(property.getValue());
                return properties;
            }).collect(Collectors.toList()));
        }
        if (jobConf.getDefaultDataset() != null) {
            request.setDefaultDataset(BigQueryRpcClient.datasetReference(jobConf.getDefaultDataset()));
        }
        if (jobConf.getMaxResults() != null) {
            request.setMaxResults(jobConf.getMaxResults());
        }
        request.setCreateSession(jobConf.createSession());
        request.setQuery(jobConf.getQuery());
        request.setRequestId(UUID.randomUUID().toString());
        if (jobConf.getPositionalParameters() != null) {
            request.setQueryParameters(Lists.transform((List)jobConf.getPositionalParameters(), value -> {
                QueryParameter queryParam = new QueryParameter();
                queryParam.setParameterValue(BigQueryRpcClient.toValueSpi(value));
                queryParam.setParameterType(BigQueryRpcClient.toTypeSpi(value));
                return queryParam;
            }));
        }
        request.setLabels(jobConf.getLabels());
        request.setUseQueryCache(Boolean.valueOf(true));
        request.setUseLegacySql(Boolean.valueOf(false));
        return request;
    }

    private static FieldList fieldList(List<TableFieldSchema> fields) {
        return FieldList.of((Iterable)Lists.transform(fields, fieldSchema -> {
            FieldList subFields = fieldSchema.getFields() != null ? BigQueryRpcClient.fieldList(fieldSchema.getFields()) : null;
            Field.Builder fieldBuilder = Field.newBuilder((String)fieldSchema.getName(), (LegacySQLTypeName)LegacySQLTypeName.valueOf((String)fieldSchema.getType()), (FieldList)subFields);
            if (fieldSchema.getMode() != null) {
                fieldBuilder.setMode(Field.Mode.valueOf((String)fieldSchema.getMode()));
            }
            if (fieldSchema.getDescription() != null) {
                fieldBuilder.setDescription(fieldSchema.getDescription());
            }
            if (fieldSchema.getMaxLength() != null) {
                fieldBuilder.setMaxLength(fieldSchema.getMaxLength());
            }
            if (fieldSchema.getScale() != null) {
                fieldBuilder.setScale(fieldSchema.getScale());
            }
            if (fieldSchema.getPrecision() != null) {
                fieldBuilder.setPrecision(fieldSchema.getPrecision());
            }
            return fieldBuilder.build();
        }));
    }

    private static List<FieldValueList> transformTableData(Iterable<TableRow> tableRows, final Schema schema) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)(tableRows != null ? tableRows : ImmutableList.of()), (Function)new Function<TableRow, FieldValueList>(){
            final FieldList fields;
            {
                this.fields = schema != null ? schema.getFields() : null;
            }

            public FieldValueList apply(TableRow row) {
                return BigQueryRpcClient.fieldValueList(row.getF(), this.fields);
            }
        }));
    }

    private static FieldValueList fieldValueList(List<?> row, FieldList schema) {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(row.size());
        if (schema != null) {
            if (schema.size() != row.size()) {
                throw new IllegalArgumentException("Row size and fields schema sizes should match");
            }
            Iterator schemaIter = schema.iterator();
            Iterator<?> rowIter = row.iterator();
            while (rowIter.hasNext() && schemaIter.hasNext()) {
                values.add(BigQueryRpcClient.fieldValue(rowIter.next(), (Field)schemaIter.next()));
            }
        } else {
            for (Object cell : row) {
                values.add(BigQueryRpcClient.fieldValue(cell, null));
            }
        }
        return FieldValueList.of(values, (FieldList)schema);
    }

    private static FieldValue fieldValue(Object cell, Field recordSchema) {
        if (Data.isNull((Object)cell)) {
            return FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, null);
        }
        if (cell instanceof String) {
            return FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)cell);
        }
        if (cell instanceof List) {
            return FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.REPEATED, (Object)BigQueryRpcClient.fieldValueList((List)cell, null));
        }
        if (cell instanceof Map) {
            Map cellMap = (Map)cell;
            if (cellMap.containsKey("f")) {
                FieldList subFieldsSchema = recordSchema != null ? recordSchema.getSubFields() : null;
                return FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.RECORD, (Object)BigQueryRpcClient.fieldValueList((List)cellMap.get("f"), subFieldsSchema));
            }
            if (cellMap.containsKey("v")) {
                return BigQueryRpcClient.fieldValue(cellMap.get("v"), recordSchema);
            }
        }
        throw new IllegalArgumentException("Unexpected table cell format");
    }

    private static QueryParameterType toTypeSpi(QueryParameterValue value) {
        QueryParameterType result = new QueryParameterType();
        result.setType(value.getType().toString());
        if (value.getArrayType() != null) {
            QueryParameterType arrayType = new QueryParameterType();
            arrayType.setType(value.getArrayType().toString());
            result.setArrayType(arrayType);
        }
        if (value.getStructTypes() != null) {
            ArrayList<QueryParameterType.StructTypes> structTypes = new ArrayList<QueryParameterType.StructTypes>();
            for (Map.Entry entry : value.getStructTypes().entrySet()) {
                QueryParameterType.StructTypes structType = new QueryParameterType.StructTypes();
                structType.setName((String)entry.getKey());
                structType.setType(BigQueryRpcClient.toTypeSpi((QueryParameterValue)entry.getValue()));
                structTypes.add(structType);
            }
            result.setStructTypes(structTypes);
        }
        return result;
    }

    private static com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameterValue toValueSpi(QueryParameterValue value) {
        com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameterValue result = new com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameterValue();
        result.setValue(value.getValue());
        if (value.getArrayValues() != null) {
            result.setArrayValues(Lists.transform((List)value.getArrayValues(), BigQueryRpcClient::toValueSpi));
        }
        if (value.getStructValues() != null) {
            HashMap<String, com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameterValue> structValues = new HashMap<String, com.dataiku.dss.shadelib.com.google.api.services.bigquery.model.QueryParameterValue>();
            for (Map.Entry structValue : value.getStructValues().entrySet()) {
                structValues.put((String)structValue.getKey(), BigQueryRpcClient.toValueSpi((QueryParameterValue)structValue.getValue()));
            }
            result.setStructValues(structValues);
        }
        return result;
    }

    private static DatasetReference datasetReference(DatasetId datasetId) {
        return new DatasetReference().setProjectId(datasetId.getProject()).setDatasetId(datasetId.getDataset());
    }

    private static RuntimeException wrapException(RuntimeException e) {
        if (e.getCause() instanceof BaseServiceException || e.getCause() instanceof BigQueryAbortedOperationException) {
            return (RuntimeException)e.getCause();
        }
        return new BigQueryException(0, e.getMessage(), e.getCause());
    }

    private static Bigquery buildQuerySpi(BigQueryOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        return new Bigquery.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.getHost()).setApplicationName(options.getApplicationName()).build();
    }

    private static class ExecuteQueryResponse {
        public final boolean completed;
        public final Schema schema;
        public final long totalRows;
        public final String pageToken;
        public final JobId jobId;
        public final List<BigQueryError> errors;
        public final List<FieldValueList> rows;

        public ExecuteQueryResponse(QueryResponse response) {
            this(response.getJobComplete(), response.getSchema(), response.getNumDmlAffectedRows(), response.getTotalRows(), response.getPageToken(), response.getJobReference(), response.getRows(), response.getErrors());
        }

        public ExecuteQueryResponse(GetQueryResultsResponse response) {
            this(response.getJobComplete(), response.getSchema(), response.getNumDmlAffectedRows(), response.getTotalRows(), response.getPageToken(), response.getJobReference(), response.getRows(), response.getErrors());
        }

        private ExecuteQueryResponse(Boolean completed, TableSchema schema, Long numDmlAffectedRows, BigInteger totalRows, String pageToken, JobReference jobReference, List<TableRow> rows, List<ErrorProto> errors) {
            this.completed = completed != null && completed != false;
            this.schema = ExecuteQueryResponse.schemaFromSpi(schema);
            this.totalRows = this.getTotalRows(numDmlAffectedRows, totalRows);
            this.pageToken = pageToken;
            this.jobId = ExecuteQueryResponse.jobId(jobReference);
            this.errors = this.getBigQueryErrors(errors);
            this.rows = BigQueryRpcClient.transformTableData(rows, this.schema);
        }

        public boolean isComplete() {
            return this.errors != null || this.completed;
        }

        private List<BigQueryError> getBigQueryErrors(List<ErrorProto> errors) {
            if (errors == null) {
                return null;
            }
            ImmutableList.Builder errorsBuilder = ImmutableList.builder();
            for (ErrorProto error : errors) {
                errorsBuilder.add((Object)ExecuteQueryResponse.bigQueryError(error));
            }
            return errorsBuilder.build();
        }

        private long getTotalRows(Long numDmlAffectedRows, BigInteger totalRows) {
            long numRows = numDmlAffectedRows == null && totalRows == null ? 0L : (numDmlAffectedRows != null ? numDmlAffectedRows.longValue() : totalRows.longValue());
            return numRows;
        }

        private static BigQueryError bigQueryError(ErrorProto errorProto) {
            return new BigQueryError(errorProto.getReason(), errorProto.getLocation(), errorProto.getMessage(), errorProto.getDebugInfo());
        }

        private static Schema schemaFromSpi(TableSchema tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            List<TableFieldSchema> fields = tableSchema.getFields();
            if (fields == null) {
                fields = Collections.emptyList();
            }
            return Schema.of((Iterable)BigQueryRpcClient.fieldList(fields));
        }

        private static JobId jobId(JobReference jobRef) {
            return JobId.newBuilder().setProject(jobRef.getProjectId()).setJob(jobRef.getJobId()).setLocation(jobRef.getLocation()).build();
        }
    }

    private class TableDataPageFetcher
    implements PageImpl.NextPageFetcher<FieldValueList> {
        private final Map<BigQueryRpc.Option, Object> requestOptions;
        private final TableId table;
        private final Schema schema;

        public TableDataPageFetcher(TableId table, Schema schema, String cursor, Map<BigQueryRpc.Option, Object> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)BigQueryRpc.Option.PAGE_TOKEN, (String)cursor, optionMap);
            this.table = table;
            this.schema = schema;
        }

        public Page<FieldValueList> getNextPage() {
            return this.listTableDataWithRetry(this.table, this.schema, this.requestOptions);
        }

        private Page<FieldValueList> listTableDataWithRetry(TableId tableId, Schema schema, Map<BigQueryRpc.Option, Object> optionsMap) {
            try {
                TableId completeTableId = TableId.of((String)(Strings.isNullOrEmpty((String)tableId.getProject()) ? BigQueryRpcClient.this.options.getProjectId() : tableId.getProject()), (String)tableId.getDataset(), (String)tableId.getTable());
                TableDataList result = (TableDataList)RetryHelper.runWithRetries(() -> this.listTableDataRpcNoRetry(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), (Map<BigQueryRpc.Option, Object>)optionsMap), (RetrySettings)BigQueryRpcClient.this.options.getRetrySettings(), (ResultRetryAlgorithm)BIGQUERY_EXCEPTION_HANDLER, (ApiClock)BigQueryRpcClient.this.options.getClock());
                String cursor = result.getPageToken();
                ImmutableMap pageOptionMap = Strings.isNullOrEmpty((String)cursor) ? optionsMap : ImmutableMap.of((Object)BigQueryRpc.Option.START_INDEX, (Object)0L);
                return new PageImpl((PageImpl.NextPageFetcher)new TableDataPageFetcher(tableId, schema, cursor, (Map<BigQueryRpc.Option, Object>)pageOptionMap), cursor, BigQueryRpcClient.transformTableData(result.getRows(), schema));
            }
            catch (RetryHelper.RetryHelperException e) {
                throw BigQueryRpcClient.wrapException((RuntimeException)((Object)e));
            }
        }

        private TableDataList listTableDataRpcNoRetry(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, Object> options) {
            try {
                return (TableDataList)BigQueryRpcClient.this.bigQuerySpi.tabledata().list(projectId, datasetId, tableId).setPrettyPrint(Boolean.valueOf(false)).setMaxResults((Long)options.get(BigQueryRpc.Option.MAX_RESULTS)).setPageToken((String)options.get(BigQueryRpc.Option.PAGE_TOKEN)).setStartIndex(options.get(BigQueryRpc.Option.START_INDEX) != null ? BigInteger.valueOf((Long)options.get(BigQueryRpc.Option.START_INDEX)) : null).execute();
            }
            catch (IOException e) {
                throw new BigQueryException(e);
            }
        }
    }

    private class ProjectDataPageFetcher
    implements PageImpl.NextPageFetcher<ProjectList.Projects> {
        private final Map<BigQueryRpc.Option, Object> requestOptions;

        public ProjectDataPageFetcher(String cursor, Map<BigQueryRpc.Option, Object> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)BigQueryRpc.Option.PAGE_TOKEN, (String)cursor, (Map)(optionMap == null ? ImmutableMap.of() : optionMap));
        }

        public Page<ProjectList.Projects> getNextPage() {
            return BigQueryRpcClient.this.listProjects(this.requestOptions);
        }
    }
}

