/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.bigquery.BigQuerySchemaHandler;
import com.dataiku.dip.sql.bigquery.BigQuerySimbaAvroReader;
import com.dataiku.dip.util.ReflectionUtils;
import com.dataiku.dip.utils.DKULogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BigQuerySimbaResultReader {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery");

    @Nullable
    public static String readStructOrArray(ResultSet rs2, int columnIndex, SchemaColumn schemaColumn) throws SQLException {
        String value = null;
        SQLException simbaSQLException = null;
        RuntimeException simbaRuntimeException = null;
        try {
            value = rs2.getString(columnIndex);
            if (value == null) {
                return null;
            }
        }
        catch (SQLException e) {
            simbaSQLException = e;
        }
        catch (RuntimeException e) {
            simbaRuntimeException = e;
        }
        if (rs2.getClass().getName().startsWith("com.simba.")) {
            try {
                Object resultSet = ReflectionUtils.getFieldValue(rs2, "m_resultSet");
                List<?> rowData = BigQuerySimbaResultReader.getRowData(resultSet);
                if (rowData != null) {
                    Object o = rowData.get(columnIndex - 1);
                    return o == null ? null : o.toString();
                }
                List columns = (List)ReflectionUtils.getFieldValue(resultSet, "m_columns");
                Object columnMetadata = columns.get(columnIndex - 1);
                Object row = BigQuerySimbaResultReader.getHTRow(resultSet);
                Object columnName = ReflectionUtils.invokeMethod(columnMetadata, "getName", new Object[0]);
                Object columnValue = ReflectionUtils.invokeMethod(row, "get", columnName);
                if (schemaColumn.getType() == Type.OBJECT) {
                    return BigQuerySimbaAvroReader.readStruct(columnValue).toString();
                }
                return BigQuerySimbaAvroReader.readArray(columnValue).toString();
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to retrieve Struct or Array value using reflection. Using getString() instead.", (Throwable)e);
            }
        }
        if (simbaRuntimeException != null) {
            throw simbaRuntimeException;
        }
        if (simbaSQLException != null) {
            throw simbaSQLException;
        }
        value = value.replace("{\"v\":]}", "{\"v\":[]}");
        return BigQuerySimbaResultReader.forceQuoteEscape(value);
    }

    private static List<?> getRowData(Object resultSet) throws ReflectiveOperationException {
        try {
            Object dataHandler = ReflectionUtils.getFieldValue(resultSet, "m_dataHandler");
            if ("com.simba.googlebigquery.googlebigquery.dataengine.BQHTDataHandler".equals(dataHandler.getClass().getName())) {
                return null;
            }
            return (List)ReflectionUtils.getFieldValue(dataHandler, "m_rowData");
        }
        catch (NoSuchFieldException e) {
            return BigQuerySimbaResultReader.getRowData1201000(resultSet);
        }
    }

    private static List<?> getRowData1201000(Object resultSet) throws ReflectiveOperationException {
        try {
            Object restDataHandler = ReflectionUtils.getFieldValue(resultSet, "m_restDataHandler");
            return (List)ReflectionUtils.getFieldValue(restDataHandler, "m_rowData");
        }
        catch (NoSuchFieldException e) {
            return BigQuerySimbaResultReader.getRowData1191012(resultSet);
        }
    }

    private static List<?> getRowData1191012(Object resultSet) throws ReflectiveOperationException {
        return (List)ReflectionUtils.getFieldValue(resultSet, "m_rowData");
    }

    private static Object getHTRow(Object resultSet) throws ReflectiveOperationException {
        try {
            Object dataHandler = ReflectionUtils.getFieldValue(resultSet, "m_dataHandler");
            return ReflectionUtils.getFieldValue(dataHandler, "m_row");
        }
        catch (NoSuchFieldException e) {
            return BigQuerySimbaResultReader.getHTRow12111014(resultSet);
        }
    }

    private static Object getHTRow12111014(Object resultSet) throws ReflectiveOperationException {
        Object htDataHandler = ReflectionUtils.getFieldValue(resultSet, "m_HTDataHandler");
        return ReflectionUtils.getFieldValue(htDataHandler, "m_row");
    }

    private static String forceQuoteEscape(String input) {
        if (BigQuerySchemaHandler.HIERARCHICAL_ESCAPE_QUOTE) {
            String output = input.replaceAll("\\$", "\\\\\\$");
            Matcher m = Pattern.compile("(?s)(?i)(\"v\":\")(.*?)(?=\"[}])").matcher(output);
            StringBuffer fixedJson = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(fixedJson, m.group(1) + m.group(2).replace("\"", "\\\\\""));
            }
            m.appendTail(fixedJson);
            return fixedJson.toString().replaceAll("\\\\\\$", "\\$");
        }
        return input;
    }
}

