/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.crecipes.sync;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.streaming.crecipes.sync.CSyncExecutor;
import com.dataiku.dip.streaming.crecipes.sync.CSyncRecipeParams;
import com.dataiku.dip.streaming.crecipes.sync.SparkCSyncRecipeDef;
import com.dataiku.dip.streaming.crecipes.sync.SparkCSyncRecipeDefBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class SparkCSyncRecipeExecutor
extends AbstractSparkBasedRecipeRunner
implements CSyncExecutor {
    private final String recipeFullId;
    private final CSyncRecipeParams.SparkParams sparkParams;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.spark.csync");

    public SparkCSyncRecipeExecutor(JobActivity activity, CSyncRecipeParams.SparkParams sparkParams, String recipeFullId) {
        super(activity);
        this.sparkParams = sparkParams;
        this.recipeFullId = recipeFullId;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void run() throws Exception {
        this.run(this.authCtxService.getAuthCtx());
    }

    @Override
    public void run(AuthCtx authCtx) throws Exception {
        SparkCSyncRecipeDefBuilder builder = new SparkCSyncRecipeDefBuilder(this.activity);
        final SparkCSyncRecipeDef recipeDef = builder.build();
        this.runSpark("csync", this.sparkParams.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return SparkCSyncRecipeExecutor.this.sparkParams.sparkConfig;
            }

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File serializedFile = new File(runDir, "spark-csync-desc.json");
                JSON.prettyToFile((Object)recipeDef, (File)serializedFile);
                return helper.makeClassJob("DSS (CSync): " + SparkCSyncRecipeExecutor.this.recipeFullId, false, effectiveConf, "com.dataiku.dip.spark.recipe.CSyncRecipeEntryPoint", serializedFile.getAbsolutePath());
            }
        }, null);
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash environmentStash = new EnvironmentStash();
        environmentStash.fillDefault();
        ContinuousActivity continuousActivity = new ContinuousActivity();
        continuousActivity.projectKey = this.recipe.getProjectKey();
        continuousActivity.recipeId = this.recipe.getName();
        environmentStash.fillForContinuousRecipe(this.authCtxService.getAuthCtx(), continuousActivity, tmpDir);
        environmentStash.env.putAll(extraEnv);
        return environmentStash;
    }

    @Override
    public void abort() {
        this.notifyBeforeAborting();
    }

    @Override
    public void init() throws Exception {
    }
}

