/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileLinesMultiMatcher {
    public static MultimatchResponse multimatch(File file, List<String> patterns) throws FileNotFoundException, IOException {
        MultimatchResponse ret = new MultimatchResponse();
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        for (String p : patterns) {
            compiled.add(Pattern.compile(p));
            ret.patternResponses.add(new MatchResponse());
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            int lineNo = 0;
            block6: while ((line = br.readLine()) != null) {
                ++lineNo;
                int i = 0;
                while (true) {
                    if (i >= compiled.size()) continue block6;
                    Matcher m = ((Pattern)compiled.get(i)).matcher(line);
                    if (m.find()) {
                        SingleMatch sm = new SingleMatch();
                        sm.lineNo = lineNo;
                        sm.matchContent = m.group();
                        ret.patternResponses.get((int)i).matches.add(sm);
                    }
                    ++i;
                }
                break;
            }
        }
        return ret;
    }

    public static class MultimatchResponse {
        public List<MatchResponse> patternResponses = new ArrayList<MatchResponse>();

        public boolean hasMatch(int patternIdx) {
            return this.patternResponses.get((int)patternIdx).matches.size() > 0;
        }
    }

    public static class MatchResponse {
        public List<SingleMatch> matches = new ArrayList<SingleMatch>();
    }

    public static class SingleMatch {
        public int lineNo;
        public String matchContent;
    }
}

