/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonObject;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ThreadLocalManualVariablesService
extends VariablesService {
    public ThreadLocal<HierarchicalVariablesContext> global = new ThreadLocal();
    public ThreadLocal<Map<String, HierarchicalVariablesContext>> perProject = new ThreadLocal();
    public ThreadLocal<String> dssUserLogin = new ThreadLocal();

    private void addUserLogin(HierarchicalVariablesContext hvc) {
        if (StringUtils.isNotBlank((String)this.dssUserLogin.get()) && !hvc.has("dssUserLogin")) {
            JsonObject ret = new JsonObject();
            ret.addProperty("dssUserLogin", this.dssUserLogin.get());
            hvc.addLevel(ret);
        }
    }

    @Override
    public VariablesContext getGlobalContext() {
        return this.global.get();
    }

    @Override
    public VariablesContext getGlobalContextAndUserLogin(AuthCtx authCtx) {
        HierarchicalVariablesContext hvc = this.global.get();
        this.addUserLogin(hvc);
        return hvc;
    }

    public void setDSSUserLogin(String userLogin) {
        this.dssUserLogin.set(userLogin);
    }

    public void setGlobalContext(HierarchicalVariablesContext g) {
        this.global.set(g);
    }

    public void setProjectContexts(Map<String, HierarchicalVariablesContext> p) {
        this.perProject.set(p);
    }

    @Override
    public VariablesContext getContext(String projectKey) {
        if (StringUtils.isBlank((String)projectKey)) {
            throw new IllegalArgumentException("projectKey is empty");
        }
        if (this.perProject.get() == null) {
            throw new Error("No variables context for project " + projectKey);
        }
        HierarchicalVariablesContext hvc = this.perProject.get().get(projectKey);
        if (hvc == null) {
            throw new Error("No variables context for project " + projectKey);
        }
        return hvc;
    }

    @Override
    public VariablesContext getContextAndUserLogin(String projectKey, AuthCtx authCtx) {
        HierarchicalVariablesContext hvc = (HierarchicalVariablesContext)this.getContext(projectKey);
        this.addUserLogin(hvc);
        return hvc;
    }

    @Override
    public VariablesContext getForConnection(DSSConnection connection, AuthCtx authCtx) {
        return this.global.get();
    }

    @Override
    public VariablesContext getForConnectionAndProject(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        return this.getContext(projectKey);
    }

    @Override
    public VariablesContext getForEverything(DSSConnection connection, AuthCtx authCtx, String projectKey) {
        return this.getContext(projectKey);
    }
}

