/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.bokeh;

import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.bokeh.AbstractBokehWebAppHandler;
import java.io.IOException;

public class BokehWebAppHandler
extends AbstractBokehWebAppHandler {
    private RelFile directory;

    public BokehWebAppHandler(WebApp webapp) {
        super(webapp);
        this.directory = new RelFile(new String[]{"projects", webapp.projectKey, "web_apps", webapp.id});
    }

    @Override
    public void readCodeFiles() {
        try {
            TransactionRef t = TransactionContext.retrieveRead();
            if (t.isFile(this.getBackendFile())) {
                this.params.python = t.readStringUTF8(this.getBackendFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void writeCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (this.params.isBackendEnabled() && this.params.python != null) {
            t.writeStringUTF8(this.getBackendFile(), this.params.python);
        }
    }

    @Override
    public void deleteCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(this.directory);
    }

    @Override
    public void initCustomWebApp() throws IOException {
    }

    private RelFile getBackendFile() {
        return this.directory.append(new String[]{"backend.py"});
    }
}

